<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>
<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">预占保单号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="policyNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">订单号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="orderNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">状态</label>
                            <div class="layui-input-inline">
                                <select name="status" lay-search>
                                    <option value="">请选择</option>
                                    <option value="1">发送成功</option>
                                    <option value="2">消费成功</option>
                                    <option value="3">消费失败</option>
                                </select>
                            </div>
                        </div>

                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="." lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>
        <input hidden id="requestBody">
        <table class="layui-hide" id="currentTableId" lay-filter="currentTableFilter"></table>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#currentTableId',
            url: '${ctx}/log/AsyncOrderMq/page',
            cols: [[
                {field: 'id', width: 180, title: 'ID', sort: true,hide:true},
                {field: 'createTime', title: '报案时间'},
                {field: 'policyNo',  title: '预占保单号'},
                {field: 'orderNo', title: '订单号'},
                /*{field: 'requestContent', title: '请求报文'},
                {field: 'responseContent',  title: '响应报文'},*/
                {field: 'remark', title: '提示信息'},
                {field: 'status', title: '状态',fixed: "right", align: "center",templet: '#selectFlag'}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('currentTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        //监听table表格
        table.on('tool(currentTableFilter)', function (obj) {
            var data = obj.data;
            /*$("#requestBody").val(data.requestContent);
            console.log("此行的报文："+$("#requestBody").val());*/
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '重新请求',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['90%', '90%'],
                    content: '${ctx}/log/AsyncOrderMq/edit?id='+data.id,
                    btn: ['重新请求','关闭'],
                    yes: function(index){
                        //当点击‘确定’按钮的时候，获取弹出层返回的值
                        var requestBody = window["layui-layer-iframe" + index].callbackdata();
                        //打印返回的值，看是否有我们想返回的值。
                        console.log("子页面返回值："+requestBody);
                        $.ajax({
                            url: '${ctx}/log/AsyncOrderMq/doQuotePrice',
                            data: {"request":requestBody,
                            "id":data.id},
                            method: 'POST',
                            success: function (data) {
                                var index = layer.alert(data.msg, {
                                    title: '结果'
                                }, function () {

                                    layer.close(index);
                                    if(data.code == 0){
                                        table.reload("currentTableId");
                                    }
                                })
                            },
                            error: function (data) {
                                layer.alert(data, {
                                    title: '结果'
                                })
                            }
                        })


                    },
                    cancel: function(){
                        //右上角关闭回调
                    }
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }
        });

    });
</script>
<script type="text/html" id="selectFlag" >

    {{#  if(d.status == "3"){ }}
    <button type="button" class="layui-btn layui-btn-sm layui-btn-danger" lay-event="edit">重新请求</button>
    {{#  } else if(d.status == "1" || d.status == "2") { }}
    <button type="button" class="layui-btn layui-btn-sm layui-btn-disabled">成功</button>
    {{#  } }}

</script>
</body>
</html>
