<!DOCTYPE html>
<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">批改账号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="creator" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">保单号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="policyNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">批改类型</label>
                            <div class="layui-input-inline" style="float:left;width:250px;margin-right:10px;">
                                <select name="endorseType" SIZE="1" v>
                                    <option style='display: none'></option>
                                    <option value="01">退保</option>
                                    <option value="04">注销</option>
                                    <option value="06">普通批改</option>
                                    <option value="08">批改被保险人清单</option>
                                    <option value="09">批改雇员清单</option>
                                    <option value="10">保期平移</option>
                                    <option value="77">保额保费批改</option>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="." lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>
        <table class="layui-hide" id="currentTableId" lay-filter="currentTableFilter"></table>
        <script type="text/html" id="channelUserTableBar">
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">详情</a>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>

    //通过layui.use('laydate', callback)
    layui.use(['laydate', 'form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#currentTableId',
            url: '${ctx}/log/correctOrder/page',
            /*id, channel_code, product_code, order_no, policy_no, proposal_no, amount, premium*/
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                // {field: 'id', width: 160, title: 'ID', sort: true},
                {field: 'creator',  title: '批改账号'},
                {field: 'policyNo',  title: '保单号'},
                {field: 'endorseType',  title: '批改类型',templet:function(d){
                        var endorStr = '';
                        if(d.endorseType=='01'){
                            endorStr = '退保';
                        }else if(d.endorseType=='04'){
                            endorStr = '注销';
                        }else if(d.endorseType=='06'){
                            endorStr = '普通批改';
                        }else if(d.endorseType=='08'){
                            endorStr = '批改被保险人清单';
                        }else if(d.endorseType=='09'){
                            endorStr = '批改雇员清单';
                        }else if(d.endorseType=='10'){
                            endorStr = '保期平移';
                        }else if(d.endorseType=='77'){
                            endorStr = '保额保费批改';
                        }
                        return endorStr
                    }},
                {field: 'status',  title: '状态',templet:function(d){
                        return d.status=='1'? '成功':'失败'
                    }},
                // {field: 'cancelDate',  title: '生效日期'},
                {title: '操作',  templet: '#channelUserTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });
            if(isEmptyObject(data.field)){
                alert('请输入查询条件！');
                return false;
            }
            //执行搜索重载
            table.reload('currentTableId', {
                page: {
                    curr: 1

                }
                , where: data.field
            }, 'data');

            return false;
        });
        table.on('tool(currentTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '查看订单详情',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/log/correctOrder/toAddOrEdit?id=' + data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }else if (obj.event === 'doEdit') {
                var index = layer.open({
                    title: '编辑订单详情',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/log/correctOrder/toAddOrEdit?id=' + data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }
        });
    });
</script>
</body>
</html>
