<!DOCTYPE html>
<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">出单账号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">保单号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="policyNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">投保单号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="proposalNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">续保单号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="renewalPolicyNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">投保状态</label>
                            <div class="layui-input-inline" style="float:left;width:250px;margin-right:10px;">
                                <select name="status" SIZE="1" v>
                                    <option style='display: none'></option>
                                    <option value="00">新增</option>
                                    <option value="01">校验通过</option>
                                    <option value="02">转投保成功</option>
                                    <option value="03">已支付未转保</option>
                                    <option value="04">转保单成功</option>
                                    <option value="05">转保待支付，已生成保单，但未支付</option>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">订单号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="orderNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        </br>

                        <div class="layui-inline"> <!-- 注意：这一层元素并不是必须的 -->
                            <label class="layui-form-label">订单生成</label>
                            <input type="text" class="layui-input" name="startCreateTime" id="test1" placeholder="起始时间">
                            <input type="text" class="layui-input" name="endCreateTime" id="test2" placeholder="结束时间">
                        </div>

                        <div class="layui-inline"> <!-- 注意：这一层元素并不是必须的 -->
                            <label class="layui-form-label">保单生成</label>
                            <input type="text" class="layui-input" name="startDate" id="test3" placeholder="起始时间">
                            <input type="text" class="layui-input" name="endDate" id="test4" placeholder="结束时间">
                        </div>

                        <div class="layui-inline"> <!-- 注意：这一层元素并不是必须的 -->
                            <label class="layui-form-label">起保时间</label>
                            <input type="text" class="layui-input" id="test5" name="startBaoTime" placeholder="起始时间">
                            <input type="text" class="layui-input" id="test6" name="endBaoTime" placeholder="结束时间">
                        </div>

                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="." lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>
        <table class="layui-hide" id="currentTableId" lay-filter="currentTableFilter"></table>
        <script type="text/html" id="channelUserTableBar">
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">详情</a>
            <@security.authorize access='hasAnyAuthority("admin","order-edit-button")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="doEdit" data-icon="fa fa-plus-circle">编辑</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    //通过layui.use('laydate', callback)
    layui.use(['laydate', 'form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table,
            laydate = layui.laydate;

        laydate.render({
            elem: '#test1',
            type: 'datetime'
        });
        laydate.render({
            elem: '#test2',
            type: 'datetime'
        });
        laydate.render({
            elem: '#test3',
            type: 'datetime'
        });
        laydate.render({
            elem: '#test4',
            type: 'datetime'
        });
        laydate.render({
            elem: '#test5',
            type: 'datetime'
        });
        laydate.render({
            elem: '#test6',
            type: 'datetime'
        });


        table.render({
            elem: '#currentTableId',
            url: '${ctx}/log/order/page',
            /*id, channel_code, product_code, order_no, policy_no, proposal_no, amount, premium*/
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                // {field: 'id', width: 160, title: 'ID', sort: true},
                {field: 'creator',  title: '出单账号'},
                {field: 'planCode',  title: '商品代码'},
                {field: 'orderNo',  title: '订单号'},
                {field: 'policyNo',  title: '保单号'},
                {field: 'proposalNo',  title: '投保单号'},
                {field: 'amount',  title: '保险金额'},
                {field: 'premium',  title: '保费'},
                {title: '操作',  templet: '#channelUserTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });
            if(isEmptyObject(data.field)){
                alert('请输入查询条件！');
                return false;
            }
            //执行搜索重载
            table.reload('currentTableId', {
                page: {
                    curr: 1

                }
                , where: data.field
            }, 'data');

            return false;
        });
        table.on('tool(currentTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '查看订单详情',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/log/order/edit?id=' + data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }else if (obj.event === 'doEdit') {
                var index = layer.open({
                    title: '编辑订单详情',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/log/order/toEdit?id=' + data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }
        });
    });
</script>
</body>
</html>
