<!DOCTYPE html>
<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">任务类型</label>
                            <div class="layui-input-inline" style="float:left;width:300px;margin-right:20px;">
                                <select name="pushType" SIZE="1" lay-verify="required" v>
                                     <option style='display: none'></option>
                                   <#list taskTypeList?if_exists as taskType>
                                     <option  data-configName="${taskType.valueDesc!""}" value="${taskType.value!}"> ${taskType.valueDesc!}</option>
                                   </#list>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">任务状态</label>
                            <div class="layui-input-inline" style="float:left;width:300px;margin-right:10px;">
                                <select name="pushStatus" SIZE="1" v>
                                    <option style='display: none'></option>
                                    <option value="0">未推送</option>
                                    <option value="1">推送成功</option>
                                    <option value="2">推送中</option>
                                    <option value="3">重推等待中</option>
                                    <option value="4">推送失败</option>
                                    <option value="5">无须推送</option>
                                </select>
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">创建时间</label>
                             <div class="layui-input-inline" style="float:left;width:300px;margin-right:20px;">
                            <input type="text" class="layui-input" id="startTime" name="startTime" lay-verify="required" />
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">到</label>
                             <div class="layui-input-inline" style="float:left;width:300px;margin-right:20px;">
                             <input type="text" class="layui-input" id="endTime" name="endTime" lay-verify="required" />
                             </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">业务号</label>
                            <div class="layui-input-inline" style="float:left;width:300px;margin-right:20px;">
                                <input type="text" name="businessKey" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="." lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>
        <table class="layui-hide" id="currentTableId" lay-filter="currentTableFilter"></table>
        <script type="text/html" id="channelUserTableBar">
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="view" data-icon="fa fa-plus-circle">详情</a>
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="push" data-icon="fa fa-plus-circle">推送</a>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>

    //通过layui.use('laydate', callback)
    layui.use(['laydate', 'form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;
        laydate.render({
            elem: '#startTime',
            value: new Date(new Date().getTime()-1000*60*60*24*3),
            type: 'datetime'
        });
        laydate.render({
            elem: '#endTime',
            value: new Date(),
            type: 'datetime'
        });
        table.render({
            elem: '#currentTableId',
            url: '${ctx}/log/push/page-async',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {field: 'pushType', width: 295, title: '任务类型'},
                {field: 'businessKey', width: 245,  title: '业务号'},
                {field: 'pushStatus', width: 100,  title: '推送状态',templet:function(d){
                        var endorStr = '';
                        if(d.pushStatus=='0'){
                            endorStr = '未推送';
                        }else if(d.pushStatus=='1'){
                            endorStr = '推送成功';
                        }else if(d.pushStatus=='2'){
                            endorStr = '推送中';
                        }else if(d.pushStatus=='3'){
                             endorStr = '重推等待中';
                         }else if(d.pushStatus=='4'){
                            endorStr = '推送失败';
                        }else if(d.pushStatus=='5'){
                             endorStr = '无须推送';
                         }
                        return endorStr
                    }},
                {field: 'pushStep', width: 90,  title: '已推次数'},
                {field: 'lastPushTime', width: 160,  title: '最后一次推送时间'},
                {title: '操作', width: 250, templet: '#channelUserTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 10,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var s1 = new Date($('#startTime').val().substring(0, 10).replace(/-/g, "/"));
            var s2 = new Date($('#endTime').val().substring(0, 10).replace(/-/g, "/"));
            var days = parseInt((s2.getTime() - s1.getTime()) / (1000 * 60 * 60 * 24));
            if (days > 3) {
                alert('查询时间范围不能超过3天！');
                return false;
            }
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('currentTableId', {
                page: {
                    curr: 1

                }
                , where: data.field
            }, 'data');

            return false;
        });
        table.on('tool(currentTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'view') {
                var index = layer.open({
                    title: '查看详情',
                    type: 2,
                    shade: 0.2,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/log/push/toView-async?id=' + data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }
            if (obj.event === 'push') {
                $.ajax({
                    url: '${ctx}/log/push/toPush-async?id=' + data.id,
                    data: data.id,
                    method: 'POST',
                    success: function (data1) {
                        var index = layer.alert(data1.msg, {
                            title: '结果'
                        }, function () {
                            // layer.close(index);
                            // layuimini.closeCurrentTab();
                            layer.close(index);
                            if(data1.code == 0){
                                table.reload("currentTableId");
                            }
                        })
                    },
                    error: function (data2) {
                        layer.alert(data2, {
                            title: '结果'
                        })
                    }
                })
            }
        });
    });
</script>
</body>
</html>
