<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>
<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">流水号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="requestId" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">报案号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="registNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">立案号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="claimNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">结案号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="endCaseNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">报案渠道</label>
                            <div class="layui-input-inline">
                                <select name="channelType" lay-search>
                                    <option value="">请选择</option>
                                    <option value="01">电话(01)</option>
                                    <option value="02">邮件(02)</option>
                                    <option value="03">快递(03)</option>
                                    <option value="04">淘宝(04)</option>
                                    <option value="05">微信(05)</option>
                                    <option value="06">南航(06)</option>
                                    <option value="07">CRM(07)</option>
                                    <option value="08">渠道(08)</option>
                                    <option value="09">携程(09)</option>
                                    <option value="10">建行客户专属(10)</option>
                                    <option value="11">京me(11)</option>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">用户账号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">保单号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="policyNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">理赔类型</label>
                            <div class="layui-input-inline">
                                <select name="damageResult" lay-search>
                                    <option value="">请选择</option>
                                    <option value="07">医疗</option>
                                    <option value="22">旅行延误</option>
                                    <option value="23">行李延误</option>
                                    <option value="24">行程变更</option>
                                    <option value="26">家财与财务丢失</option>
                                    <option value="25">拒签</option>
                                    <option value="27">租车</option>
                                    <option value="28">个责</option>
                                    <option value="99">其他</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <div class="layui-input-block">
                            <button class="layui-btn" lay-submit="" lay-filter="channelUserAddOrEditFormFilter">立即提交</button>
                            <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        //监听提交
        form.on('submit(channelUserAddOrEditFormFilter)', function (data) {
            $.ajax({
                url: '${ctx}/log/regist/doAddOrEdit',
                data: data.field,
                method: 'POST',
                success: function (data) {
                    var index = layer.alert(data.msg, {
                        title: '结果'
                    }, function () {
                        // layer.close(index);
                        // layuimini.closeCurrentTab();

                        layer.close(index);

                        if(data.code == 0){
                            parent.layui.table.reload("currentTableId");
                            var iframeIndex = parent.layer.getFrameIndex(window.name);
                            parent.layer.close(iframeIndex);
                        }
                    })
                },
                error: function (data) {
                    layer.alert(data, {
                        title: '结果'
                    })
                }
            })
            return false;
        });




    });
</script>
</body>
</html>
