<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>
<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">流水号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="requestId" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">报案号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="registNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">立案号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="claimNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">结案号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="endCaseNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">报案渠道</label>
                            <div class="layui-input-inline">
                                <select name="channelType" lay-search>
                                    <option value="">请选择</option>
                                    <option value="01">电话(01)</option>
                                    <option value="02">邮件(02)</option>
                                    <option value="03">快递(03)</option>
                                    <option value="04">淘宝(04)</option>
                                    <option value="05">微信(05)</option>
                                    <option value="06">南航(06)</option>
                                    <option value="07">CRM(07)</option>
                                    <option value="08">渠道(08)</option>
                                    <option value="09">携程(09)</option>
                                    <option value="10">建行客户专属(10)</option>
                                    <option value="11">京me(11)</option>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">用户账号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">保单号</label>
                            <div class="layui-input-inline">
                                <input type="text" name="policyNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">理赔类型</label>
                            <div class="layui-input-inline">
                                <select name="damageResult" lay-search>
                                    <option value="">请选择</option>
                                    <option value="07">医疗</option>
                                    <option value="22">旅行延误</option>
                                    <option value="23">行李延误</option>
                                    <option value="24">行程变更</option>
                                    <option value="26">家财与财务丢失</option>
                                    <option value="25">拒签</option>
                                    <option value="27">租车</option>
                                    <option value="28">个责</option>
                                    <option value="99">其他</option>
                                </select>
                            </div>
                        </div>

                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="." lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>
        <script type="text/html" id="registIndexToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","channelUser-page-Button-add")'>
                    <button id="regist-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加 </button>
                </@security.authorize>
            </div>
        </script>
        <table class="layui-hide" id="currentTableId" lay-filter="currentTableFilter"></table>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#currentTableId',
            toolbar: '#registIndexToolbar',
            url: '${ctx}/log/regist/page',
            cols: [[
                // {field: 'id', width: 180, title: 'ID', sort: true},
                {field: 'createTime', title: '报案时间'},
                {field: 'requestId',  title: '报案流水号'},
                {field: 'registNo', title: '报案号'},
                {field: 'claimNo', title: '立案号'},
                {field: 'endCaseNo',  title: '结案号'},
                {field: 'externalId', title: '外部唯一编码',hide:true},
                {field: 'channelType', title: '报案渠道',templet: function (d) {
                        if (d.channelType != null) {
                            if (d.channelType == '01') {
                                return '电话';
                            } else if (d.channelType == '02') {
                                return '邮件';
                            } else if (d.channelType == '03') {
                                return '快递';
                            } else if (d.channelType == '04') {
                                return '淘宝';
                            } else if (d.channelType == '05') {
                                return '微信';
                            } else if (d.channelType == '06') {
                                return '南航';
                            } else if (d.channelType == '07') {
                                return 'CRM';
                            } else if (d.channelType == '08') {
                                return '渠道';
                            } else if (d.channelType == '09') {
                                return '携程';
                            } else if (d.channelType == '10') {
                                return '建行客户专属';
                            } else if (d.channelType == '11') {
                                return '京me';
                            }
                        } else {
                            return '--';
                        }
                    }},
                {field: 'userCode', title: '用户编码'},
                {field: 'policyNo', title: '保单号'},
                {field: 'damageResult',  title: '理赔类型',templet: function (d) {
                        if (d.damageResult != null) {
                            if (d.damageResult == '07') {
                                return '医疗';
                            }else if (d.damageResult == '22') {
                                return '旅行延误';
                            }else if (d.damageResult == '23') {
                                return '行李延误';
                            }else if (d.damageResult == '24') {
                                return '行程变更';
                            }else if (d.damageResult == '25') {
                                return '拒签';
                            }else if (d.damageResult == '26') {
                                return '家财及财产丢失';
                            }else if (d.damageResult == '27') {
                                return '租车';
                            }else if (d.damageResult == '28') {
                                return '个责';
                            }else if (d.damageResult == '99') {
                                return '其他';
                            }
                        } else {
                            return '--';
                        }
                    }}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('currentTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        $(document).on("click", "#regist-add-btn", function () {
            var index = layer.open({
                title: '添加报案记录',
                type: 2,
                shade: 0.2,
                maxmin: true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/log/regist/edit',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        });

    });
</script>
</body>
</html>
