<!DOCTYPE html>
<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">

                        <div class="layui-inline">
                            <label class="layui-form-label">出单账号</label>
                            <div class="layui-input-inline" style="float:left;width:300px;margin-right:20px;">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">产品代码</label>
                            <div class="layui-input-inline" style="float:left;width:300px;margin-right:20px;">
                                <input type="text" name="productCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label" style="width:130px">外部渠道订单号</label>
                            <div class="layui-input-inline" style="float:left;width:280px;margin-right:20px;">
                                <input type="text" name="agencyPolicyRef" autocomplete="off" class="layui-input">
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">保单号</label>
                            <div class="layui-input-inline" style="float:left;width:300px;margin-right:20px;">
                                <input type="text" name="policyNo" autocomplete="off" class="layui-input">
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">创建时间</label>
                             <div class="layui-input-inline" style="float:left;width:300px;margin-right:20px;">
                            <input type="text" class="layui-input" id="startTime" name="startTime"/>
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">到</label>
                             <div class="layui-input-inline" style="float:left;width:300px;margin-right:20px;">
                             <input type="text" class="layui-input" id="endTime" name="endTime"/>
                             </div>
                        </div>


                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="." lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>
        <table class="layui-hide" id="currentTableId" lay-filter="currentTableFilter"></table>
        <script type="text/html" id="warnLogTableBar">
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="view" data-icon="fa fa-plus-circle">详情</a>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>

    //通过layui.use('laydate', callback)
    layui.use(['laydate', 'form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;
        laydate.render({
            elem: '#startTime',
            value: new Date(new Date().getTime()-1000*60*60*24*7),
            type: 'datetime'
        });
        laydate.render({
            elem: '#endTime',
            value: new Date(),
            type: 'datetime'
        });
        table.render({
            elem: '#currentTableId',
            url: '${ctx}/log/warn/page',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {field: 'userCode', width: 120, title: '出单帐号'},
                {field: 'channelName', width: 200,  title: '外部渠道'},
                {field: 'productCode', width: 90,  title: '产品代码'},
                {field: 'agencyPolicyRef', width: 200,  title: '外部渠道订单号'},
                {field: 'errorMessage', width: 160,  title: '错误消息'},
                {field: 'proposalNo', width: 220,  title: '投保单号'},
                {field: 'policyNo', width: 220,  title: '保单号'},
                {title: '操作', width: 130, templet: '#warnLogTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 10,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var s1 = new Date($('#startTime').val().substring(0, 10).replace(/-/g, "/"));
            var s2 = new Date($('#endTime').val().substring(0, 10).replace(/-/g, "/"));
            var days = parseInt((s2.getTime() - s1.getTime()) / (1000 * 60 * 60 * 24));
            if (days > 7) {
                alert('查询时间范围不能超过7天！');
                return false;
            }
            var result = JSON.stringify(data.field);

            //执行搜索重载
            table.reload('currentTableId', {
                page: {
                    curr: 1

                }
                , where: data.field
            }, 'data');

            return false;
        });
        table.on('tool(currentTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'view') {
                var index = layer.open({
                    title: '查看详情',
                    type: 2,
                    shade: 0.2,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/log/warn/toView?id=' + data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }
        });
    });
</script>
</body>
</html>
