<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>
<table class="layui-hide" id = "menuTableId" lay-filter="menu" style="height: 100%"></table>
<script type="text/html" id="toolbarDemo">
    <div class="layui-btn-group">
        <button class="layui-btn layui-btn-sm" id="data-menu-add-btn"><i class="layui-icon">&#xe654;</i>新增</button>
        <button class="layui-btn layui-btn-sm" lay-event="btn-expand">全部展开</button>
        <button class="layui-btn layui-btn-sm" lay-event="btn-fold">全部折叠</button>
        <button class="layui-btn layui-btn-sm" lay-event="btn-refresh">刷新表格</button>
        <#--<button class="layui-btn layui-btn-sm" lay-event="updata"><i class="layui-icon">&#xe642;</i>修改</button>-->
        <#--<button class="layui-btn layui-btn-sm" lay-event="delete"><i class="layui-icon">&#xe640;</i>删除</button>-->
        <#--<button class="layui-btn layui-btn-sm" lay-event="refresh"><i class="layui-icon">&#xe666;</i>刷新</button>-->
    </div>
</script>
<script type="text/html" id="menuTableBar">
    <a class="layui-btn layui-btn-xs data-count-add" href="javascript:;" lay-event="add"
       data-icon="fa fa-plus-circle">新增</a>
    <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit"
       data-icon="fa fa-plus-circle">编辑</a>
    <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
</script>
<#--<div class="layuimini-container">-->
    <#--<div class="layuimini-main">-->
       <#---->
<#--</div>-->
<#include "../layout/body_js.ftl"/>
<script>
    layui.use(['treetable', 'table', 'layer'], function () {
        var table = layui.table;
        var layer = layui.layer;
        var treetable = layui.treetable;
        var _tools = {
            renderTable: function(){
                //渲染表格
                layer.load(2);  //加载层
                treetable.render({
                    height: 'full-160',
                    id:'menuTableId',
                    treeColIndex: 0,	//树形图标显示在第几列
                    treeSpid: '0',		//最上级的父级id
                    treeIdName: 'id',	//id字段的名称
                    treePidName: 'parentId',	//父级节点字段
                    treeDefaultClose: false,	//是否默认折叠
                    treeLinkage: false,		//父级展开时是否自动展开所有子级
                    elem: '#menuTableId',	//表格id
                    url: '${ctx}/menu/loadMenu',
                    toolbar: '#toolbarDemo',
                    page: false,
                    cols: [[
                        // {type:'checkbox'},
                        {field: 'name', title: '菜单名称'},
                        {field: 'url' , title: '地址'},
                        {field: 'icon' , hide : true, title: '图标'},
                        {field: 'idx', title: '排序'},
                        {title: '操作',  templet: '#menuTableBar', fixed: "right", align: "center"}
                    ] ],

                    //数据渲染完的回调

                    done: function () {
                        //关闭加载
                        layer.closeAll('loading');
                    }
                });
            }
        }
        window.tools = _tools;
        window.tools.renderTable();

        // 监听添加操作
        $(document).on("click", "#data-menu-add-btn", function () {
            var index = layer.open({
                title: '新增',
                type: 2,
                shade: 0.2,
                maxmin: true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/menu/addOrEditPage',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        });
        table.on('toolbar(menu)',function (obj) {
            if(obj.event === 'btn-expand'){
                treetable.expandAll("#menuTableId");
            }else if(obj.event==='btn-fold'){
                treetable.foldAll('#menuTableId');
            }else if(obj.event==='btn-refresh'){
                tools.renderTable();
            }
        });
        table.on('tool(menu)', function(obj){
            var data = obj.data;
            if(obj.event === 'add'){
                var parentId = data.id;
                layer.open({
                    title: '新增',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/menu/addOrEditPage?parentId=' + parentId,
                });
            }else if(obj.event === 'edit'){
                var id = data.id;
                layer.open({
                    title: '编辑',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/menu/addOrEditPage?id=' + id,
                });
            }else if(obj.event === "delete"){
                layer.confirm('确定要删除吗', function (index) {
                    $.ajax({
                        url: '${ctx}/menu/delete',
                        method: 'POST',
                        data: {"id":data.id},
                        success: function (_data) {
                            layer.close(index);
                            layer.alert('删除成功');
                            tools.renderTable();
                        },
                        error: function (_data) {
                            layer.alert('删除失败' + JSON.stringify(_data))
                        }
                    })

                });
            }
        });


    });

</script>
</body>
</html>
