<!DOCTYPE html>
<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label" style="width: 130px">商品/方案代码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="rationCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label" style="width: 130px">商品/方案名称</label>
                            <div class="layui-input-inline">
                                <input type="text" name="rationName" autocomplete="off" class="layui-input">
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">类型</label>
                            <div class="layui-input-inline" style="float:left;width:250px;margin-right:10px;">
                                <select name="rationFlag" SIZE="1" v>
                                    <option style='display: none'></option>
                                    <option value="1">保障方案</option>
                                    <option value="2">商品</option>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="." lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>
        <table class="layui-hide" id="currentTableId" lay-filter="currentTableFilter"></table>
        <script type="text/html" id="productTableBar">
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">详情</a>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>

    //通过layui.use('laydate', callback)
    layui.use(['laydate', 'form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#currentTableId',
            url: '${ctx}/product/ration/page',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                // {field: 'id', width: 160, title: 'ID', sort: true},
                {field: 'rationCode',  title: '商品/方案代码'},
                {field: 'rationName',  title: '商品/方案名称'},
                {field: 'relateRationCode',  title: '保障方案代码'},
                {field: 'productCode',  title: '产品代码'},
                {field: 'classCode',  title: '产品线'},
                {field: 'rationFlag',  title: '类型',templet:function(d){
                        var endorStr = '';
                        if(d.rationFlag=='2'){
                            endorStr = '商品';
                        }else if(d.rationFlag=='1'){
                            endorStr = '保障方案';
                        }
                        return endorStr
                    }},
                {title: '操作',  templet: '#productTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('currentTableId', {
                page: {
                    curr: 1

                }
                , where: data.field
            }, 'data');

            return false;
        });
        table.on('tool(currentTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '查看商品详情',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/product/ration/toDetail?id=' + data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }
        });
    });
</script>
</body>
</html>
