<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
            background-color: #ffffff;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">请求URI</label>
                            <div class="layui-input-inline">
                                <input type="text" name="interfaceUrl" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
<#--                            <label class="layui-form-label">有效标志</label>-->
                            <div class="layui-input-inline">
                                <input type="checkbox" checked  name="validFlag" lay-skin="switch"  lay-text="有效|无效">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="" lay-filter="channel-router-data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <#--<div class="layui-btn-group">-->
<#--&lt;#&ndash;            <button class="layui-btn data-add-btn">添加</button>&ndash;&gt;-->
            <#--<button class="layui-btn" href="javascript:;"  data-icon="fa fa-plus-circle">添加</button>-->
<#--&lt;#&ndash;            <button class="layui-btn layui-btn-danger data-delete-btn">删除</button>&ndash;&gt;-->
        <#--</div>-->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","routeDefinition-page-Button-add")'>
                    <button id="router-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加 </button>
                </@security.authorize>
                <@security.authorize access='hasAnyAuthority("admin","routeDefinition-page-Button-delete")'>
                    <button class="layui-btn layui-btn-sm layui-btn-danger data-delete-btn" lay-event="deleteAll"> 删除 </button>
                </@security.authorize>

            </div>
        </script>
        <table class="layui-hide" id="currentTableId" lay-data="{id:'currentTableId'}" lay-filter="currentTableFilter"></table>
        <script type="text/html" id="currentTableBar">
            <#--<a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" data-iframe-tab="${ctx}/router/edit?id={{d.id}}" data-title="编辑主路由信息" data-icon="fa fa-plus-circle">编辑</a>-->
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" data-icon="fa fa-plus-circle" lay-event="edit">编辑</a>
            <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#currentTableId',
            url: '${ctx}/router/page',
            toolbar: '#toolbarDemo',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {type: "checkbox",  fixed: "left"},
                // {field: 'id',  title: 'ID', sort: true},
                {field: 'interfaceUrl',  title: '请求URI'},
                {field: 'defaultChannelUser', title: '默认用户'},
                {field: 'defaultProductType',  title: '默认产品'},
                {field: 'defaultBusinessType',  title: '默认业务'},
                // {field: 'encrypType', width: 100, title: '加密方式'},
                // {field: 'encrypKey', width: 100, title: '加密key'},
                // {field: 'decrypKey', width: 100, title: '解密key'},
                {field: 'validFlag',  title: '有效标志',templet: function (d) {
                        return d.validFlag==1? '有效':'无效'
                    }},
                {title: '操作',  templet: '#currentTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(channel-router-data-search-btn)', function (data) {
            if(data.field.validFlag=="on"){
                data.field.validFlag=1
            }else{
                data.field.validFlag=0;
            }
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('currentTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        // $(".data-add-btn").on("click", function () {
        //     layer.msg('添加数据');
        // });

        <#--data-iframe-tab="${ctx}/router/add" data-title="添加主路由信息"-->
        // 监听添加操作
       $(document).on("click","#router-add-btn",function(){
           var index = layer.open({
               title: '添加路由',
               type: 2,
               shade: 0.2,
               maxmin:true,
               shadeClose: true,
               area: ['100%', '100%'],
               content: '${ctx}/router/add',
           });
           $(window).on("resize", function () {
               layer.full(index);
           });
       });

        //监听表格复选框选择
        table.on('checkbox(currentTableFilter)', function (obj) {
            console.log(obj)
        });

        table.on('tool(currentTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑路由',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/router/edit?id='+data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'delete') {
                layer.confirm('确定删除吗？', function (index) {
                    $.ajax({
                        url: '${ctx}/router/delete?id='+data.id,
                        method: 'POST',
                        success :function (_data) {
                            obj.del();
                            layer.close(index);
                            // layer.alert('删除成功')
                        },
                        error : function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })

                });
            }
        });

        table.on('toolbar(currentTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            if(obj.event === 'deleteAll'){
                var datas = checkStatus.data;
                var arrNew=new Array();
                var test2='';
                for(var i in datas){
                    console.log(datas[i].id);
                    arrNew.push(datas[i].id);
                    test2 = test2 + datas[i].id + ',';
                }
                console.log(test2);
                if(arrNew.length==0){
                    layer.alert("请选择一条数据");
                    return false;
                }
                layer.confirm('真的删除么', function (index) {
                    $.ajax({
                        url: '${ctx}/router/deleteAll',
                        method: 'POST',
                        data: {"test2":test2},
                        success: function (data) {
                            layer.alert('删除成功');
                            location.reload();
                        },
                        error: function (_data) {
                            layer.alert('删除失败' + JSON.stringify(_data))
                        }
                    })

                });
            }


        });


    });
</script>
</body>
</html>
