<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <#setting number_format="#">
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <form class="layui-form" action="">
            <#if routerRule?? && routerRule.id?? >
                <input type="hidden" name="id" value="${routerRule.id?c}">
            </#if>
            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">路由ID</label>
                    <div class="layui-input-inline">
                        <select  name="routerId">
                        <#list routerList?if_exists as router>
                            <option <#if routerRule.routerId?? &&  routerRule.routerId ==  router.id>selected</#if> value="${router.id}">${router.interfaceUrl}</option>
                        </#list>
                    </select>
                    </div>
                </div>

                <div class="layui-inline">
                    <label class="layui-form-label">业务类型</label>
                    <div class="layui-input-inline">
                        <input type="text" name="businessType" autocomplete="off" class="layui-input" value="${routerRule.businessType!""}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">规则字段</label>
                    <div class="layui-input-inline">
                        <input type="text" name="fieldName" placeholder="请输入" autocomplete="off"  value="${routerRule.fieldName!""}"
                               class="layui-input">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">规则表达式</label>
                    <div class="layui-input-inline">
                        <input type="text" name="expression" class="layui-input" value="${routerRule.expression!""}">
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <label class="layui-form-label">有效标志</label>
                <div class="layui-input-block">
                    <#--<input type="checkbox" checked value="<#if routerRule.validFlag??>${routerRule.validFlag?c}<#else>${routerRule.validFlag!"1"}</#if>" name="validFlag" lay-skin="switch" lay-text="有效|无效">-->
                    <#if routerRule.validFlag??>
                        <input type="checkbox" <#if routerRule.validFlag==1>checked</#if>   name="validFlag" lay-skin="switch" lay-text="有效|无效">
                    <#else>
                        <input type="checkbox" checked   name="validFlag" lay-skin="switch" lay-text="有效|无效">
                    </#if>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button class="layui-btn" lay-submit="" lay-filter="addOrEditFormFilter">立即提交</button>
                    <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                </div>
            </div>
        </form>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'layedit', 'laydate'], function () {
        var form = layui.form
            , $ = layui.jquery
            , layuimini = layui.layuimini
            , layer = layui.layer;

        //自定义验证规则
        form.verify({});

        //监听指定开关

        //监听提交
        form.on('submit(addOrEditFormFilter)', function (data) {
            if(data.field.validFlag=="on"){
                data.field.validFlag=1
            }else{
                data.field.validFlag=0;
            }
            $.ajax({
                url: '${ctx}/router/rule/doAddOrEdit',
                data: data.field,
                method: 'POST',
                success: function (data) {
                    var index = layer.alert(data.msg, {
                        title: '结果'
                    }, function () {
                        // layer.close(index);
                        // layuimini.closeCurrentTab();

                        parent.layui.table.reload("routerRuleTableId");
                        layer.close(index);
                        var iframeIndex = parent.layer.getFrameIndex(window.name);
                        parent.layer.close(iframeIndex);

                    })
                },
                error: function (data) {
                    layer.alert(data, {
                        title: '结果'
                    })
                }
            })
            return false;
        });
    });
</script>
</body>
</html>
