<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">匹配地址</label>
                            <div class="layui-input-inline">
                                <#--<input type="text" name="routerId" autocomplete="off" class="layui-input">-->
                                <select  name="routerId">
                                    <option  value="">请选择</option>
                                    <#list routerList?if_exists as router>
                                        <option  value="${router.id}">${router.interfaceUrl}</option>
                                    </#list>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">业务类型</label>
                            <div class="layui-input-inline">
                                <input type="text" name="businessType" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">规则字段</label>
                            <div class="layui-input-inline">
                                <input type="text" name="fieldName" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <#--<div class="layui-btn-group">-->
<#--&lt;#&ndash;            <button class="layui-btn data-add-btn">添加</button>&ndash;&gt;-->
            <#--<button class="layui-btn" href="javascript:;" data-iframe-tab="${ctx}/router/rule/add" data-title="添加主路由信息" data-icon="fa fa-plus-circle">添加</button>-->
<#--&lt;#&ndash;            <button class="layui-btn layui-btn-danger data-delete-btn">删除</button>&ndash;&gt;-->
        <#--</div>-->
        <script type="text/html" id="routerRuleIndexToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","channelConfig-page-Button-add")'>
                    <button id="router-rule-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 添加 </button>
                </@security.authorize>
                <@security.authorize access='hasAnyAuthority("admin","channelConfig-page-Button-delete")'>
                    <button class="layui-btn layui-btn-sm layui-btn-danger data-delete-btn" lay-event="deleteAll"> 删除 </button>
                </@security.authorize>
            </div>
        </script>
        <table class="layui-hide" id="routerRuleTableId" lay-filter="routerRuleTableFilter"></table>
        <script type="text/html" id="routerRuleTableBar">
            <#--<a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" data-iframe-tab="${ctx}/router/rule/edit?id={{d.id}}" data-title="编辑路由规则信息" data-icon="fa fa-plus-circle">编辑</a>-->
            <@security.authorize access='hasAnyAuthority("admin","channelConfig-table-Button-edit")'>
                <a class="layui-btn layui-btn-xs data-count-edit" data-icon="fa fa-plus-circle" lay-event="edit">编辑</a>
            </@security.authorize>
            <@security.authorize access='hasAnyAuthority("admin","channelConfig-table-Button-delete")'>
                <a class="layui-btn layui-btn-xs layui-btn-danger data-count-delete" lay-event="delete">删除</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#routerRuleTableId',
            url: '${ctx}/router/rule/page',
            toolbar: '#routerRuleIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {type: "checkbox", fixed: "left"},
                // {field: 'id', title: 'ID', sort: true},
                {field: 'interFaceUrl', title: '匹配地址'},
                {field: 'fieldName', title: '规则字段'},
                {field: 'expression', title: '规则表达式'},
                {field: 'businessType', title: '业务类型'},
                {field: 'validFlag', title: '有效标志',templet: function (d) {
                        return d.validFlag==1? '有效':'无效'
                    }},
                {title: '操作', templet: '#routerRuleTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('routerRuleTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        // 监听添加操作
        // $(".data-add-btn").on("click", function () {
        //     layer.msg('添加数据');
        // });

        // 监听添加操作
        $(document).on("click","#router-rule-add-btn",function () {
            var index = layer.open({
                title: '添加路由规则',
                type: 2,
                shade: 0.2,
                maxmin:true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/router/rule/add',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        })


        //
        // // 监听删除操作
        // $(".data-delete-btn").on("click", function () {
        //     var checkStatus = table.checkStatus('routerRuleTableId')
        //         , data = checkStatus.data;
        //     layer.alert(JSON.stringify(data));
        // });
        //
        // //监听表格复选框选择
        // table.on('checkbox(routerRuleTableFilter)', function (obj) {
        //     console.log(obj)
        // });

        table.on('tool(routerRuleTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑路由规则',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/router/rule/edit?id='+data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/router/rule/delete?id='+data.id,
                        method: 'POST',
                        success :function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除成功')
                        },
                        error : function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })

                });
            }
        });


        table.on('toolbar(routerRuleTableFilter)', function (obj) {
            var checkStatus = table.checkStatus(obj.config.id);
            if(obj.event === 'deleteAll'){
                var datas = checkStatus.data;
                var arrNew=new Array();
                var test2='';
                for(var i in datas){
                    console.log(datas[i].id);
                    arrNew.push(datas[i].id);
                    test2 = test2 + datas[i].id + ',';
                }
                console.log(test2);
                if(arrNew.length==0){
                    layer.alert("请选择一条数据");
                    return false;
                }
                layer.confirm('真的删除么',{skin: 'layui-layer-molv'}, function (index) {
                    $.ajax({
                        url: '${ctx}/router/rule/deleteAll',
                        method: 'POST',
                        data: {"test2":test2},
                        success: function (data) {
                            layer.alert('删除成功');
                            location.reload();
                        },
                        error: function (_data) {
                            layer.alert('删除失败' + JSON.stringify(_data))
                        }
                    })

                });
            }


        });

    });
</script>
</body>
</html>
