<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
        .layui-btn-margin{
            margin: 5px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">BD_CODE</label>
                            <div class="layui-input-block">
                                <input type="text" id="channel-code" name="bdCode" autocomplete="off"
                                        class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">归属业务员</label>
                            <div class="layui-input-inline">
                                <input type="text" id="channel-code" name="bdName" autocomplete="off"
                                        class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                            <button type="button" id="search" class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索
                            </button>
                            <#--<a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>-->
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <table class="layui-hide" id="BDInfoTableId" lay-filter="BDInfoTableFilter"></table>
        <#--<div class="layui-btn-container" style="text-align:center">
            <button  class="layui-btn layui-btn-primary">取消</button>
            <button type="button" id="search" class="layui-btn" lay-submit="" >确认</button>
        </div>-->
    </div>
</div>
<#include "../layout/body_js.ftl"/>
<#--<script type="text/html" id="serialNumber">
    {{d.LAY_TABLE_INDEX+1}}
</script>-->
<script>
    var callbackdata = function (obj) {
        var checkStatus = layui.table.checkStatus('BDInfoTableId').data;
        var data ;
        if (checkStatus.length == 0) {
            alert("请选择一条数据");
            data = {
                code: "-1"
            };
        } else {
            data = {
                code: checkStatus[0].bdCode,
                name: checkStatus[0].bdName
            };

        }
        return data;
    }


    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;


        table.render({
            elem: '#BDInfoTableId',
            url: '${ctx}/subAccount/bdInfo/page',
            cols: [[
                {fixed: "left",title: '选择',type: "radio" },
                {field: 'numbers', title: '序号',align: "center",width:80,type: 'numbers'},
                {field: 'bdCode', title: 'BD_CODE',align: "center",width:200},
                {field: 'bdName', title: '归属业务员',align: "center",}
                ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 10,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            //执行搜索重载
            table.reload('BDInfoTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');

            return false;
        });

        /*// 监听添加操作
        $(document).on("click", "#channel-user-add-btn", function () {
            var index = layer.open({
                title: '添加用户',
                type: 2,
                shade: 0.2,
                maxmin: true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/channel/user/add',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        })*/
        // // 监听删除操作
        // $(".data-delete-btn").on("click", function () {
        //     var checkStatus = table.checkStatus('channelUserConfigTableId')
        //         , data = checkStatus.data;
        //     layer.alert(JSON.stringify(data));
        // });
        //
        // //监听表格复选框选择
        // table.on('checkbox(channelUserConfigTableFilter)', function (obj) {
        //     console.log(obj)
        // });

        table.on('tool(BDInfoTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑用户信息',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/channel/user/edit?id=' + data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/channel/user/delete?id=' + data.id,
                        method: 'POST',
                        success: function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除成功')
                        },
                        error: function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })

                });
            }
        });
    });
</script>
</body>
</html>
