<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
        .layui-btn-margin{
            margin: 5px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>搜索信息</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <#-- 若录入了渠道代码则根据渠道代码自动带出，支持修改 -->
                            <label class="layui-form-label">渠道名称</label>
                            <div class="layui-input-block">
                                <input id="channel-name" type="hidden" name="channelName">
                                <select id="channel-select" lay-filter="channel-select" lay-verify="required"  lay-search>
                                    <option value>请选择渠道</option>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <#-- 若选择了渠道名称则根据渠道名称自动带出，支持修改-->
                            <label class="layui-form-label">渠道代码</label>
                            <div class="layui-input-inline">
                                <input type="text" id="channel-code" name="channelCode" autocomplete="off"
                                       lay-verify="required" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                            <button type="button" id="search" class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索
                            </button>
                            <#--<a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>-->
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <script type="text/html" id="channelUserIndexToolbar">
            <div class="layui-btn-container layui-layout-right" >
                <button id="channel-user-add-btn" class="layui-btn layui-btn-primary layui-btn-margin"> 添加</button>
                <button id="channel-user-addAll-btn" class="layui-btn layui-btn-primary layui-btn-margin" > 批量授权</button>
                <button id="channel-user-addAll-sync" class="layui-btn layui-btn-primary layui-btn-margin" > 一键授权</button>
<#--                <button class="layui-btn layui-btn-sm layui-btn-danger data-delete-btn" lay-event="deleteAll"> 删除</button>-->
                </div>
        </script>
        <table class="layui-hide" id="subAccountTableId" lay-filter="channelUserTableFilter"></table>
        <script type="text/html" id="subAccountTableBar">
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit"
               data-icon="fa fa-plus-circle" lay-filter="channelUserDetail">查看</a>
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="authorization"
               data-icon="fa fa-plus-circle">授权</a>
            <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="syncUserCode"
               data-icon="fa fa-plus-circle">一键同步</a>
        </script>
    </div>
</div>
<#include "../layout/body_js.ftl"/>
<#--<script type="text/html" id="serialNumber">
    {{d.LAY_TABLE_INDEX+1}}
</script>-->
<script>

    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        var channelCode = $("#channel-code").val();

        //下拉框渠道数据
        $.post('${ctx}/subAccount/getChannelList', function (rs) {
            //item是返回的数据集合中的每个元素
            $.each(rs.data, function (index, item) {
                // 追加option节点
                $("#channel-select").append(new Option(item.agentName, item.agentCode));
            });
            //重新渲染下拉框
            form.render('select');
        });

        //监听渠道名称下拉框
        form.on('select(channel-select)', function (data) {
            if (data.value == "") {
                $("#channel-code").val("");
                $("#channel-name").val("");
            } else {
                $("#channel-code").val(data.value);
                $("#channel-name").val(data.elem[data.elem.selectedIndex].text);
            }
            form.render('select');
        });

        //监听渠道代码输入框
        $("#channel-code").on("input", function (e) {
            let value = e.delegateTarget.value;
            if(value != ""){
                let option =  $("#channel-select").find("option[value="+value+"]");
                if(option.length > 0){
                    $(option[0]).prop("selected",true);
                    $("#channel-name").val($(option)[0].text);
                    form.render();
                    return;
                }
            }
            $("#channel-name").val("");
            $("#channel-select").find("option:first-child").prop("selected",true);
            form.render();
        });

        /*$(document).on('click', '#search', function () {

        });*/






        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            channelCode=$("#channel-code").val();
            var result = JSON.stringify(data.field);
            // layer.alert(result, {
            //     title: '最终的搜索信息'
            // });

            table.render({
                elem: '#subAccountTableId',
                url: '${ctx}/subAccount/page',
                toolbar: '#channelUserIndexToolbar',
                defaultToolbar: [],
                cols: [[
                    {type: "checkbox", fixed: "left"},
                    {field: 'numbers', title: '序号',align: "center",width:80,type: 'numbers'},
                    {field: 'userCode', title: '出单账号',align: "center",width:200},
                    {field: 'userName', title: '出单账号名称',align: "center",},
                    {field: '', title: '状态',align: "center",width:120,templet: function (d) {
                            /*alert(d.effective_date+","+d.expire_date+","+d.userName);*/
                            if (d.effectiveDate === null || typeof d.effectiveDate === 'undefined' || d.expireDate === null || typeof d.expireDate === 'undefined') {
                                return '--';
                            }
                            var date = new Date();
                            var effectiveDate = new Date(d.effectiveDate);
                            var expireDate = new Date(d.expireDate);
                            if (date.getTime()>effectiveDate.getTime() && date.getTime()<expireDate.getTime() ){
                                return '生效';
                            }else {
                                return '失效';
                            }
                        }},
                    {field: 'createTime', title: '创建时间',align: "center",width:200},
                    {title: '操作', templet: '#subAccountTableBar', fixed: "right", align: "center",width:200}
                ]],
                limits: [10, 15, 20, 25, 50, 100],
                limit: 15,
                page: true,
                where: data.field
            });

            //执行搜索重载
            // table.reload('subAccountTableId', {
            //     page: {
            //         curr: 1
            //     }
            //     , where: data.field
            // }, 'data');

            return false;
        });


        // 监听添加操作
        $(document).on("click", "#channel-user-add-btn", function () {
            /*alert(channelCode);*/
            var index = layer.open({
                title: '添加用户',
                type: 2,
                shade: 0.2,
                maxmin: true,
                shadeClose: true,
                area: ['100%', '100%'],
                content: '${ctx}/subAccount/toAdd?agentCode=' + channelCode,
            });
            $(window).on("resize", function () {
                layer.full(index);
            });

            return false;
        });



        // 监听一键同步渠道操作
        $(document).on("click", "#channel-user-addAll-sync", function () {
            layer.confirm('执行后，会将该渠道下所有账号原授权数据清除，从销管系统同步授权数据。',{btn: ['确定', '取消'],title:"警告"}, function (index) {
                $.ajax({
                    url: '${ctx}/subAccount/syncChannelCode?channelCode='+channelCode,
                    method: 'POST',
                    success :function (_data) {
                        layer.close(index);
                        layer.alert(_data.msg);
                    },
                    error : function (_data) {
                        layer.close(index);
                        layer.alert('同步失败');

                    }
                })

            });
        });



        $(document).on("click", "#channel-user-addAll-btn", function () {
            var checkStatus = table.checkStatus('subAccountTableId').data;
            if (checkStatus.length == 0) {
                alert("请选择一条数据");

            } else {
                var index = layer.open({
                    title: '添加用户',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: 'batchAuthorization',
                    success: function (layero, index) {
                        // 获取子页面的iframe
                        var iframe = window['layui-layer-iframe' + index];
                        // 向子页面的全局函数child传参
                        iframe.checkStatus=JSON.stringify(checkStatus);
                        console.log("选中的表格数据"+checkStatus);
                        iframe.channelCode=$("input[name='channelCode']").val();
                        var str = "";
                        for (var i = 0; i < checkStatus.length; i++) {
                            str += checkStatus[i].userCode+ ",";
                        }
                        //去掉最后一个逗号(如果不需要去掉，就不用写)
                        if (str.length > 0) {
                            str = str.substr(0, str.length - 1);
                        }
                        iframe.userCode=str;
                    }
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });

                return false;
            }

        });

        // // 监听删除操作
        // $(".data-delete-btn").on("click", function () {
        //     var checkStatus = table.checkStatus('channelUserConfigTableId')
        //         , data = checkStatus.data;
        //     layer.alert(JSON.stringify(data));
        // });
        //
        // //监听表格复选框选择
        // table.on('checkbox(channelUserConfigTableFilter)', function (obj) {
        //     console.log(obj)
        // });

        //监听table表格
        table.on('tool(channelUserTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '账号查看',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/subAccount/detail?userCode=' + data.userCode,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'authorization') {
                var index = layer.open({
                    title: '账号授权',
                    type: 2,
                    shade: 0.2,
                    maxmin: true,
                    shadeClose: true,
                    area: ['100%', '100%'],
                    content: '${ctx}/subAccount/toAuthorization?userCode=' + data.userCode,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }else if (obj.event === 'syncUserCode') {

                layer.confirm('执行后，会将该账号原授权数据清除，从销管系统同步授权数据。',{btn: ['确定', '取消'],title:"警告"}, function (index) {
                    $.ajax({
                        url: '${ctx}/subAccount/syncUserCode?channelCode='+channelCode+'&userCode='+data.userCode,
                        method: 'POST',
                        success :function (_data) {
                            layer.close(index);
                            layer.alert(_data.msg);
                        },
                        error : function (_data) {
                            layer.close(index);
                            layer.alert('同步失败');

                        }
                    })

                });
            }
        });


    });
</script>
</body>
</html>
