<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <#setting number_format="#">
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <form class="layui-form" action="">
            <#if apisSystemDataDict?? && apisSystemDataDict.id?? >
                <input type="hidden" name="id" value="${apisSystemDataDict.id?c}">
            </#if>
            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">字典代码</label>
                    <div class="layui-input-inline">
                        <input type="text" name="dictCode" autocomplete="off" class="layui-input" value="${apisSystemDataDict.dictCode!""}">
                    </select>
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">字典名称</label>
                    <div class="layui-input-inline">
                        <input type="text" name="dictName" autocomplete="off" class="layui-input" value="${apisSystemDataDict.dictName!""}">
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">字典类型</label>
                    <div class="layui-input-inline">
                        <select name="dictType" lay-search="">
                            <option value=""></option>
                            <option <#if apisSystemDataDict.dictType?? &&  apisSystemDataDict.dictType == '1'>selected</#if> value="1">系统配置</option>
                            <option <#if apisSystemDataDict.dictType?? &&  apisSystemDataDict.dictType == '2'>selected</#if> value="2">系统代码</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-inline">
                    <label class="layui-form-label">有效标志</label>
                    <div class="layui-input-block">
                        <#if apisSystemDataDict.validStatus??>
                            <input type="checkbox" <#if apisSystemDataDict.validStatus=='1'>checked</#if>   name="validStatus" lay-skin="switch" lay-text="有效|无效">
                        <#else>
                            <input type="checkbox" checked   name="validStatus" lay-skin="switch" lay-text="有效|无效">
                        </#if>
                    </div>
                </div>
                <div class="layui-inline">
                    <label class="layui-form-label">备注</label>
                    <div class="layui-input-inline">
                        <input type="text" name="remark" class="layui-input" value="${apisSystemDataDict.remark!""}">
                    </div>
                </div>
            </div>
            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button class="layui-btn" lay-submit="" lay-filter="addOrEditFormFilter">立即提交</button>
                    <button type="reset" class="layui-btn layui-btn-primary">重置</button>
                </div>
            </div>
        </form>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'layedit', 'laydate'], function () {
        var form = layui.form
            , $ = layui.jquery
            , layuimini = layui.layuimini
            , layer = layui.layer;

        //自定义验证规则
        form.verify({});

        //监听指定开关

        //监听提交
        form.on('submit(addOrEditFormFilter)', function (data) {
            if(data.field.validStatus=="on"){
                data.field.validStatus="1"
            }else{
                data.field.validStatus="0";
            }
            $.ajax({
                url: '${ctx}/system/dataDict/doAddOrEdit',
                data: data.field,
                method: 'POST',
                success: function (data) {
                    var index = layer.alert(data.msg, {
                        title: '结果'
                    }, function () {
                        // layer.close(index);
                        // layuimini.closeCurrentTab();

                        parent.layui.table.reload("dataDictTableId");
                        layer.close(index);
                        var iframeIndex = parent.layer.getFrameIndex(window.name);
                        parent.layer.close(iframeIndex);

                    })
                },
                error: function (data) {
                    layer.alert(data, {
                        title: '结果'
                    })
                }
            })
            return false;
        });
    });
</script>
</body>
</html>
