<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
             margin: 10px;
         }
        .layui-form-label {
            width: 90px;
        }
        .textarea-inherit {
            width: 100%;
            height: 400px;
            overflow: auto;
            word-break: break-all; //解决兼容问题
        }
         .required-icon{
             color:#F00;
         }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <form class="layui-form" action="#" id="form" method="post">
            <input type="hidden" name="id" value="${(role.id)!""}">
            <div class="layui-form-item" >
                <label class="layui-form-label" style="width: 20% "><span class="required-icon">*</span>角色名称</label>
                <div class="layui-inline" style="width: 50% ">
                    <input type="text" name="name" lay-verify="required"  placeholder="" autocomplete="off" class="layui-input" value="${(role.name)!""}">
                </div>
            </div>
            <div class="layui-form-item">
                <label class="layui-form-label" style="width: 20% "><span class="text-red">
            </span><span class="required-icon">*</span>有效状态</label>
                <div class="layui-inline" style="width: 50%">
                    <select id="batchNumber" name="validFlag" id="validFlag" lay-verify="required" class="layui-form-select">
                        <option value="1" <#if (role.validFlag)?? && ((role.validFlag!"") == 1) >selected="selected"</#if>>有效</option>
                        <option value="0" <#if (role.validFlag)?? && ((role.validFlag!"") == 0) >selected="selected"</#if>>无效</option>
                    </select>
                </div>
            </div>

            <div class="layui-form-item">
                <div id="tree" class="demo-tree-more"></div>
            </div>


            <div class="layui-form-item" style="margin-left:280px;margin-top: 50px">
                <div class="layui-input-block">
                    <button type="button" class="layui-btn layui-btn-primary" onclick="btnCancel();">取消</button>
                    <button class="layui-btn" lay-submit="" lay-filter="updateBtn">提交</button>
                </div>
            </div>
        </form>
    </div>

</div>
<#include "../../layout/body_js.ftl"/>
<script>

    var ctx = '${ctx}';
    layui.use(['form', 'layedit', 'laydate','layer', 'tree', 'util'], function () {
        var form = layui.form
            , $ = layui.jquery
            , layuimini = layui.layuimini
            , layer = layui.layer;

        //自定义验证规则
        form.verify({});

        //树相关
        var tree = layui.tree;
        let util = layui.util;
        var data = getTreeData();
        console.info(data);
        tree.render({
            id: tree
            , elem: "#tree"
            , data: data
            , showCheckbox: true  //是否显示复选框
            , id: 'treeId'
            , isJump: false //是否允许点击节点时弹出新窗口跳转
        });
        //按钮事件
        util.event('lay-demo', {
            getChecked: function (othis) {
                var checkedData = tree.getChecked('demoId1'); //获取选中节点的数据
                layer.alert(JSON.stringify(checkedData), {shade: 0});
                console.log(checkedData);
            }
            , reload: function () {
                //重载实例
                tree.reload('demoId1', {});
            }
        });
        initTree();
            var submitFlag = true;
            form.on('submit(updateBtn)', function (data) {
                if (submitFlag) {
                    submitFlag = false;  //只能提交一次
                    // var ajaxData = $("#form").serializeObject();
                    var ajaxData = JSON.stringify($("#form").serializeObject());
                    $.ajax({
                        url: ctx + '/rolePerm/saveRole',
                        contentType: 'application/json',
                        dataType: 'JSON',
                        method: 'post',
                        data: ajaxData,
                        success: function (map) {
                            if (map.code == "1") {
                                layer.alert(map.msg, {
                                    icon: 1  //提示图标样式
                                }, function (index) {
                                    layer.close(index);
                                    // parent.window.location.href = ctx + "/rolePerm/permissionsManage";
                                    parent.layui.table.reload("ediRouterTableId");
                                    var iframeIndex = parent.layer.getFrameIndex(window.name);
                                    parent.layer.close(iframeIndex);
                                });
                            } else {
                                layer.alert(map.msg, {
                                    icon: 2  //提示图标样式
                                }, function (index) {
                                    layer.close(index);
                                });
                                submitFlag = true;
                            }
                        }
                    });
                }
                return false;
            });
    });

    //关闭窗口
    function btnCancel() {
        // parent.closeWindow();
        let index = parent.layer.getFrameIndex(window.name);
        parent.layer.close(index);
    }
    function getTreeData() {
        let treeData = [];
        $.ajax({
            url: ctx + '/rolePerm/getRoleTree',
            type: 'post',
            dataType: 'json',
            async: false,
            success: function (data) {
                if (data) {
                    treeData = data;
                } else {
                    layer.msg('初始化菜单失败。' + data.message, {icon: 2, time: 2000});
                }
            },
            error: function (msg) {
                layer.msg('请求服务器出错，初始化菜单失败', {icon: 2, time: 2000});
            }
        });
        return treeData;
    }
    function initTree() {
        var id = $("input[name='id']").val();
        if (id != null && id != '') {
            $.ajax({
                type: 'get',
                url: ctx + '/rolePerm/findPerm?id=' + id,
                datatype: 'json',
                success: function (result) {
                    layui.use('tree', function () {
                        var treeMenu = layui.tree;
                        console.info(result)
                        treeMenu.setChecked('treeId', result);
                    });
                }
            });
        }
    }

    $.fn.serializeObject = function() {
        var o = {};
        var a = this.serializeArray();
        $.each(a, function() {
            if (o[this.name]) {
                if (!o[this.name].push) {
                    o[this.name] = [ o[this.name] ];
                }
                o[this.name].push(this.value || '');
            } else {
                o[this.name] = this.value || '';
            }
        });
        return o;
    };

</script>

</body>
</html>
