<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend>角色管理</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">

                        <div class="layui-inline">
                            <label class="layui-form-label">角色名称</label>
                            <div class="layui-input-inline">
                                <input type="text" name="name" autocomplete="off" class="layui-input">
                            </div>
                        </div>

                        <div class="layui-inline">
                            <label class="layui-form-label">有效状态</label>
                            <div class="layui-inline" style="width: 50%">
                                <select name="validFlag" id="validFlag"   lay-search>
                                    <option value="">全部</option>
                                    <option value="1">有效</option>
                                    <option value="0">无效</option>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <button class="layui-btn layui-btn layui-btn-primary" type="reset">重 置</button>
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <script type="text/html" id="ediRouterIndexToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","roleManage-page-Button-add")'>
                    <button id="edi-router-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 新增 </button>
                </@security.authorize>
            </div>

        </script>
        <table class="layui-hide" id="ediRouterTableId" lay-filter="ediRouterTableFilter"></table>
        <script type="text/html" id="ediRouterTableBar">
            <@security.authorize access='hasAnyAuthority("admin","roleManage-page-Button-edit")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="edit" data-icon="fa fa-plus-circle">维护</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#ediRouterTableId',
            url: '${ctx}/rolePerm/permissionsManagePage',
            toolbar: '#ediRouterIndexToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {field: 'numbers', width: 190, title: '序号', sort: true,templet: '#xuhao'},
                {field: 'name', width: 400, title: '角色名称'},
                {field: 'validFlag', width: 400, title: '有效状态',templet: function (d) {
                        return d.validFlag? '有效':'无效'
                    }},
                {title: '维护', minWidth: 300, templet: '#ediRouterTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            //执行搜索重载
            table.reload('ediRouterTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');
            return false;
        });

        // 监听添加操作
        $(document).on("click","#edi-router-add-btn",function () {
            var index = layer.open({
                title: '新增角色',
                type: 2,
                shade: 0.2,
                maxmin:true,
                shadeClose: true,
                area: ['80%', '80%'],
                content: '${ctx}/rolePerm/addRole',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });
            return false;
        })

        table.on('tool(ediRouterTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'edit') {
                var index = layer.open({
                    title: '编辑角色',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['80%', '80%'],
                    content: '${ctx}/rolePerm/addRole?id='+data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/edi/router/delete?id='+data.id,
                        method: 'POST',
                        success :function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除成功')
                        },
                        error : function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除失败' + JSON.stringify(_data))

                        }
                    })

                });
            }
        });

    });
</script>
<script type="text/html" id="xuhao">
    {{d.LAY_TABLE_INDEX+1}}
</script>
</body>
</html>
