<!DOCTYPE html>
<html>
<head>
    <title>首页</title>
    <#include "../../layout/head_css.ftl"/>
    <style>
        body {
            margin: 10px;
        }
    </style>
</head>
<body>

<div class="layuimini-container">
    <div class="layuimini-main">
        <fieldset class="layui-elem-field layuimini-search">
            <legend style="font-weight: bold">用户管理</legend>
            <div style="margin: 10px 10px 10px 10px">
                <form class="layui-form layui-form-pane" action="">
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">用户代码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">用户编码</label>
                            <div class="layui-input-inline">
                                <input type="text" name="userCode" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                        <div class="layui-inline">
                            <button class="layui-btn layui-btn layui-btn-primary" type="reset">重 置</button>
                            <a class="layui-btn" lay-submit="" lay-filter="data-search-btn">搜索</a>
                        </div>
                    </div>
                    <div class="layui-form-item">
                        <div class="layui-inline">
                            <label class="layui-form-label">用户状态</label>
                            <div class="layui-inline" style="width: 190px">
                                <select name="validFlag" id="validFlag"   lay-search>
                                    <option value="">全部</option>
                                    <option value="1">有效</option>
                                    <option value="0">无效</option>
                                </select>
                            </div>
                        </div>
                        <div class="layui-inline">
                            <label class="layui-form-label">角色名称</label>
                            <div class="layui-input-inline">
                                <input type="text" name="roleName" autocomplete="off" class="layui-input">
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </fieldset>

        <script type="text/html" id="userManageToolbar">
            <div class="layui-btn-container">
                <@security.authorize access='hasAnyAuthority("admin","userManage-page-Button-add")'>
                    <button id="edi-router-add-btn" class="layui-btn layui-btn-sm data-add-btn"> 新增 </button>
                </@security.authorize>
            </div>
        </script>
        <table class="layui-hide" id="ediRouterTableId" lay-filter="ediRouterTableFilter"></table>
        <script type="text/html" id="ediRouterTableBar">
            <@security.authorize access='hasAnyAuthority("admin","userManage-page-Button-view")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="showUserDetail" data-icon="fa fa-plus-circle">查看</a>
            </@security.authorize>
            <@security.authorize access='hasAnyAuthority("admin","userManage-page-Button-setupRole")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="setupRole" data-icon="fa fa-plus-circle">角色配置</a>
            </@security.authorize>
            <@security.authorize access='hasAnyAuthority("admin","userManage-page-Button-delete")'>
                <a class="layui-btn layui-btn-xs data-count-edit" href="javascript:;" lay-event="delete" data-icon="fa fa-plus-circle">删除</a>
            </@security.authorize>
        </script>
    </div>
</div>
<#include "../../layout/body_js.ftl"/>
<script>
    layui.use(['form', 'table'], function () {
        var $ = layui.jquery,
            form = layui.form,
            table = layui.table;

        table.render({
            elem: '#ediRouterTableId',
            url: '${ctx}/rolePerm/userManagePage',
            toolbar: '#userManageToolbar',
            defaultToolbar: ['filter', 'exports', 'print', {
                title: '提示',
                layEvent: 'LAYTABLE_TIPS',
                icon: 'layui-icon-tips'
            }],
            cols: [[
                {field: 'numbers', width: 100, title: '序号', sort: true,templet: '#xuhao'},
                {field: 'userCode', width: 160, title: '用户代码'},
                {field: 'userName', width: 160, title: '用户姓名'},
                {field: 'roleName', width: 200, title: '角色名称'},
                {field: 'validFlag', width: 120, title: '用户状态',templet: function (d) {
                        return d.validFlag==1? '有效':'无效'
                    }},
                {title: '操作', minWidth: 190, templet: '#ediRouterTableBar', fixed: "right", align: "center"}
            ]],
            limits: [10, 15, 20, 25, 50, 100],
            limit: 15,
            page: true
        });

        // 监听搜索操作
        form.on('submit(data-search-btn)', function (data) {
            //执行搜索重载
            table.reload('ediRouterTableId', {
                page: {
                    curr: 1
                }
                , where: data.field
            }, 'data');
            return false;
        });

        // 监听添加操作
        $(document).on("click","#edi-router-add-btn",function () {
            var index = layer.open({
                title: '新增用户',
                type: 2,
                shade: 0.2,
                maxmin:true,
                shadeClose: true,
                area: ['80%', '80%'],
                content: '${ctx}/rolePerm/addUser',
            });
            $(window).on("resize", function () {
                layer.full(index);
            });
            return false;
        })
        table.on('tool(ediRouterTableFilter)', function (obj) {
            var data = obj.data;
            if (obj.event === 'showUserDetail') {
                var index = layer.open({
                    title: '查看用户信息',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['80%', '80%'],
                    content: '${ctx}/rolePerm/showUserDetail?userId='+data.id,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            }else if (obj.event === 'setupRole') {
                var index = layer.open({
                    title: '用户角色编辑',
                    type: 2,
                    shade: 0.2,
                    maxmin:true,
                    shadeClose: true,
                    area: ['80%', '80%'],
                    content: '${ctx}/rolePerm/viewUserRole?userId='+data.id+"&roleId="+data.roleId,
                });
                $(window).on("resize", function () {
                    layer.full(index);
                });
            } else if (obj.event === 'delete') {
                layer.confirm('真的删除行么', function (index) {
                    $.ajax({
                        url: '${ctx}/rolePerm/delUser?userId='+data.id,
                        method: 'POST',
                        success :function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert('删除成功')
                        },
                        error : function (_data) {
                            obj.del();
                            layer.close(index);
                            layer.alert(_data.msg)

                        }
                    })
                });
            }
        });

    });

</script>

<script type="text/html" id="xuhao">
    {{d.LAY_TABLE_INDEX+1}}
</script>
</body>
</html>
