/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.aop;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.annotation.RequiredAuth;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.expection.ReqRespTypeException;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.MeiXinReqExtractCache;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MeiXinRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MeiXinResponse;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import java.time.LocalDateTime;
import java.util.Arrays;
import org.apache.commons.lang3.ObjectUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ReqExtractAspect {
    private static final Logger log = LoggerFactory.getLogger(ReqExtractAspect.class);
    private static final String CLASS_METHOD_SPLIT = "#";

    @Around(value="@annotation(requiredAuth)")
    public Object around(ProceedingJoinPoint jp, RequiredAuth requiredAuth) throws Throwable {
        String methodName = jp.getSignature().getName();
        String className = jp.getSignature().getDeclaringType().getSimpleName();
        String classMethodName = className + CLASS_METHOD_SPLIT + methodName;
        Object request = Arrays.stream(jp.getArgs()).filter(e -> e instanceof MeiXinRequest).findFirst().orElse(null);
        if (ObjectUtils.isEmpty(request) || !(request instanceof MeiXinRequest)) {
            log.error("\u65b9\u6cd5\uff1a{}\uff0c\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u5f02\u5e38\uff1a{}", (Object)classMethodName, request);
            throw new ReqRespTypeException((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        log.warn("\u9541\u4fe1->\u4eac\u4e1c\u5b89\u8054request\u65b9\u6cd5\uff1a{}\uff0c \u8bf7\u6c42\uff1a{}", (Object)classMethodName, (Object)JSON.toJSONString(request));
        MeiXinRequest meiXinRequest = request;
        MeiXinReqExtractCache.setReqExtract((MeiXinRequest)meiXinRequest);
        Object response = jp.proceed();
        if (ObjectUtils.isEmpty((Object)response) || !(response instanceof MeiXinResponse)) {
            log.error("\u65b9\u6cd5\uff1a{}\uff0c \u54cd\u5e94\u53c2\u6570\u7c7b\u578b\u5f02\u5e38\uff1a{}", (Object)classMethodName, ObjectUtils.isEmpty((Object)response) ? null : response.getClass());
            throw new ReqRespTypeException((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        MeiXinResponse meiXinResponse = (MeiXinResponse)response;
        meiXinResponse.setRequestType(meiXinRequest.getRequestType());
        meiXinResponse.setRequestId(meiXinRequest.getRequestId());
        meiXinResponse.setCompanyId(meiXinRequest.getCompanyId());
        meiXinResponse.setResponseTime(LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
        MeiXinReqExtractCache.clear();
        log.warn("\u9541\u4fe1->\u4eac\u4e1c\u5b89\u8054response\u65b9\u6cd5\uff1a{}\uff0c \u54cd\u5e94\uff1a{}", (Object)classMethodName, (Object)JSON.toJSONString((Object)meiXinResponse));
        return meiXinResponse;
    }
}

