/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.expection;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.expection.AuthException;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.expection.NeedWarnException;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.expection.ReqRespTypeException;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.MeiXinReqExtractCache;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MeiXinRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MeiXinResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.vo.WarnConvertVo;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.WarnSendUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionAdvice.class);
    @Autowired
    WarnSendUtil warnSendUtil;

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public MeiXinResponse<Object> badRequestException(MethodArgumentNotValidException e) {
        BindingResult bindingResult = e.getBindingResult();
        LinkedHashMap errorMap = new LinkedHashMap();
        bindingResult.getFieldErrors().forEach(fieldError -> errorMap.put(fieldError.getField(), fieldError.getDefaultMessage()));
        log.error("\u53c2\u6570\u6821\u9a8c\u5931\u8d25\uff1a{}", errorMap);
        Object target = bindingResult.getTarget();
        if (target instanceof MeiXinRequest) {
            MeiXinRequest request = (MeiXinRequest)target;
            MeiXinReqExtractCache.setReqExtract((MeiXinRequest)request);
        }
        return this.makeMeiXinResponse((ErrorCode)AnalysisErrorCodeEnum.ERR_B010006, errorMap);
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public MeiXinResponse<Object> badRequestException(IllegalArgumentException e) {
        return this.makeMeiXinResponse((ErrorCode)AnalysisErrorCodeEnum.ERR_B010001, null);
    }

    @ExceptionHandler(value={AuthException.class})
    public MeiXinResponse<Object> handleAuthException(AuthException e) {
        return this.makeMeiXinResponse((ApisBusinessException)e);
    }

    @ExceptionHandler(value={ReqRespTypeException.class})
    public MeiXinResponse<Object> handleReqRespTypeException(ReqRespTypeException e) {
        return this.makeMeiXinResponse((ApisBusinessException)e);
    }

    @ExceptionHandler(value={NeedWarnException.class})
    public MeiXinResponse<Object> handleNeedWarnException(HttpServletRequest request, NeedWarnException e) {
        WarnConvertVo warnConvertVo = WarnConvertVo.builder().requestUrl(request.getRequestURI()).warnConvertHandler(e.getWarnConvertHandler()).data(e.getData()).errCode(e.getErrorCode()).errMessage(e.getMessage()).build();
        this.warnSendUtil.claimConvertSendEmail(warnConvertVo);
        return this.makeMeiXinResponse((ApisBusinessException)e);
    }

    private MeiXinResponse<Object> makeMeiXinResponse(ApisBusinessException e) {
        return this.makeMeiXinResponse(e.getErrorCode(), e.getMessage(), null);
    }

    private MeiXinResponse<Object> makeMeiXinResponse(ErrorCode errorCode, Object responseData) {
        return this.makeMeiXinResponse(errorCode.getKey(), errorCode.getValue(), responseData);
    }

    private MeiXinResponse<Object> makeMeiXinResponse(String resultCode, String resultMsg, Object responseData) {
        MeiXinRequest reqExtract = MeiXinReqExtractCache.getReqExtract();
        MeiXinReqExtractCache.clear();
        MeiXinResponse meiXinResponse = new MeiXinResponse();
        meiXinResponse.setResponseData(responseData);
        if (ObjectUtils.isEmpty((Object)reqExtract)) {
            meiXinResponse.setResultCode(resultCode);
            meiXinResponse.setResultMsg(resultMsg);
            return meiXinResponse;
        }
        meiXinResponse.setRequestType(reqExtract.getRequestType());
        meiXinResponse.setRequestId(reqExtract.getRequestId());
        meiXinResponse.setResponseTime(LocalDateTimeUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMddHHmmss"));
        meiXinResponse.setCompanyId(reqExtract.getCompanyId());
        meiXinResponse.setResultCode(resultCode);
        meiXinResponse.setResultMsg(resultMsg);
        return meiXinResponse;
    }
}

