/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.interceptor;

import com.jdaz.sinosoftgz.apis.business.app.analysisapp.annotation.RequiredAuth;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.expection.AuthException;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.hanlder.AuthHandler;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.SpringContextUtil;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import java.lang.reflect.Method;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class AuthInterceptor
implements HandlerInterceptor {
    @Resource
    private SpringContextUtil springContextUtil;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            Class authHandler;
            AuthHandler realHandler;
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            RequiredAuth annotation = method.getAnnotation(RequiredAuth.class);
            if (ObjectUtils.isNotEmpty((Object)annotation) && !(realHandler = (AuthHandler)this.springContextUtil.getBean(authHandler = annotation.authHandler())).verifyAuth(request).booleanValue()) {
                throw new AuthException((ErrorCode)AnalysisErrorCodeEnum.ERR_A010004);
            }
            return true;
        }
        return false;
    }
}

