/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.job;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.agent.MxClaimEndCasePushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core.MxClaimMaterialPushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core.MxInsureOrderPushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core.MxTransferNoticePushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core.ThirdpClaimRegistPushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.ClaimMediaUploadUtil;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@ConditionalOnProperty(prefix="scheduling", name={"enabled"}, havingValue="true")
public class Task {
    private static final Logger log = LoggerFactory.getLogger(Task.class);
    @Autowired
    private MxInsureOrderPushService mxInsureOrderPushService;
    @Autowired
    private ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Value(value="${analysis.task.max_push_times}")
    private Integer maxPushTimes;
    @Autowired
    private MxTransferNoticePushService mxTransferNoticePushService;
    @Autowired
    private ThirdpClaimRegistPushService thirdpClaimRegistPushService;
    @Autowired
    private MxClaimEndCasePushService mxClaimEndCasePushService;
    @Autowired
    private MxClaimMaterialPushService mxClaimMaterialPushService;
    @Autowired
    ClaimMediaUploadUtil claimMediaUploadUtil;

    public void uploadMxNewOrderToRiskTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.MX_NEW_ORDER_UPLOAD_TO_RISK.getKey())) {
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.MX_NEW_ORDER_UPLOAD_TO_RISK.getValue(), this.maxPushTimes);
                log.warn("\u4e0a\u4f20\u9541\u4fe1\u521b\u5efa\u56e2\u5355\u6570\u636e\u5230\u788e\u7ba1\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.mxInsureOrderPushService.uploadMxOrderDataToInsureRisk(t));
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u9541\u4fe1\u521b\u5efa\u56e2\u5355\u6570\u636e\u5230\u788e\u7ba1\u4efb\u52a1\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.MX_NEW_ORDER_UPLOAD_TO_RISK.getKey());
            }
        }
    }

    public void uploadMxAddInsuredToRiskTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.MX_ADD_INSURED_UPLOAD_TO_RISK.getKey())) {
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.MX_ADD_INSURED_UPLOAD_TO_RISK.getValue(), this.maxPushTimes);
                log.warn("\u4e0a\u4f20\u9541\u4fe1\u6279\u589e\u88ab\u4fdd\u4eba\u6570\u636e\u5230\u788e\u7ba1\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.mxInsureOrderPushService.uploadMxOrderDataToInsureRisk(t));
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u9541\u4fe1\u6279\u589e\u88ab\u4fdd\u4eba\u6570\u636e\u5230\u788e\u7ba1\u4efb\u52a1\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.MX_ADD_INSURED_UPLOAD_TO_RISK.getKey());
            }
        }
    }

    public void uploadMxAddSumInsuredToRiskTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.MX_ADD_SUM_INSURED_UPLOAD_TO_RISK.getKey())) {
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.MX_ADD_SUM_INSURED_UPLOAD_TO_RISK.getValue(), this.maxPushTimes);
                log.warn("\u4e0a\u4f20\u9541\u4fe1\u6279\u589e\u88ab\u4fdd\u4eba\u6570\u636e\u5230\u788e\u7ba1\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.mxInsureOrderPushService.uploadMxOrderDataToInsureRisk(t));
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u9541\u4fe1\u6279\u589e\u88ab\u4fdd\u4eba\u6570\u636e\u5230\u788e\u7ba1\u4efb\u52a1\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.MX_ADD_SUM_INSURED_UPLOAD_TO_RISK.getKey());
            }
        }
    }

    public void uploadMxYqAddSumInsuredToRiskTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.MX_YQ_ADD_INSURED_UPLOAD_TO_RISK.getKey())) {
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.MX_YQ_ADD_INSURED_UPLOAD_TO_RISK.getValue(), this.maxPushTimes);
                log.warn("\u4e0a\u4f20\u9541\u4fe1\u836f\u4f01\u6279\u589e\u88ab\u4fdd\u4eba\u6570\u636e\u5230\u788e\u7ba1\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.mxInsureOrderPushService.uploadMxOrderDataToInsureRisk(t));
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u9541\u4fe1\u836f\u4f01\u6279\u589e\u88ab\u4fdd\u4eba\u6570\u636e\u5230\u788e\u7ba1\u4efb\u52a1\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.MX_YQ_ADD_INSURED_UPLOAD_TO_RISK.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void billsCheckTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.SG_BILLS_CHECK.getKey())) {
            try {
                Integer hour = DateUtil.hour((Date)new Date(), (boolean)true);
                String endDateStr = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + " " + hour + ":00:00";
                DateTime endDate = DateUtil.parse((CharSequence)endDateStr, (String)"yyyy-MM-dd HH:mm:ss");
                DateTime beginDate = DateUtil.offsetHour((Date)endDate, (int)-24);
                log.warn("\u9541\u4fe1\u8f6c\u8d26\u901a\u77e5\u788e\u7ba1-\u5bf9\u8d26\u4efb\u52a1\u5f00\u59cb,\u67e5\u8be2\u8d77\u59cb\u65f6\u95f4\uff1a{},\u7ed3\u675f\u65f6\u95f4\uff1a{}", (Object)beginDate, (Object)endDate);
                this.mxTransferNoticePushService.billsCheck((Date)beginDate, (Date)endDate);
            }
            catch (Exception e) {
                log.error("\u9541\u4fe1\u8f6c\u8d26\u901a\u77e5\u788e\u7ba1-\u5bf9\u8d26: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.SG_BILLS_CHECK.getKey());
            }
        }
    }

    public void thirdpClaimRegistTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getKey())) {
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getValue(), this.maxPushTimes);
                log.warn("\u63a8\u9001\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.thirdpClaimRegistPushService.pushThirdpClaimRegistTask(t));
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u4fe1\u606f\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getKey());
            }
        }
    }

    public void compensateThirdpClaimRegistTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getKey())) {
            try {
                log.warn("\u63a8\u9001\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001\u4efb\u52a1-\u8865\u507f\u4efb\u52a1\u5f00\u59cb");
                Boolean success = this.thirdpClaimRegistPushService.compensateThirdpClaimRegistTask();
                log.warn("\u63a8\u9001\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001\u4efb\u52a1-\u8865\u507f\u4efb\u52a1\u7ed3\u675f\uff1a{}", (Object)success);
            }
            catch (Exception e) {
                log.error("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001\u4efb\u52a1-\u8865\u507f\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getKey());
            }
        }
    }

    public void compensateMediaTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getKey())) {
            try {
                log.warn("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u5f71\u50cf\u4e34\u65f6\u63a8\u9001\u4efb\u52a1\u5f00\u59cb");
                Boolean success = this.claimMediaUploadUtil.uploadMxClaimMediaTask();
                log.warn("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u5f71\u50cf\u4e34\u65f6\u63a8\u9001\u4efb\u52a1\u7ed3\u675f\uff1a{}", (Object)success);
            }
            catch (Exception e) {
                log.error("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u5f71\u50cf\u4e34\u65f6\u63a8\u9001\u4efb\u52a1-\u8865\u507f: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getKey());
            }
        }
    }

    public void mxYkfClaimEndCasePushTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YKF.getKey())) {
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YKF.getValue(), this.maxPushTimes);
                log.warn("\u788e\u7ba1\u7406\u8d54\u7ed3\u6848\u63a8\u9001-\u836f\u5eb7\u4ed8\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.mxClaimEndCasePushService.pushYkfClaimEndCaseTask(t));
            }
            catch (Exception e) {
                log.error("\u788e\u7ba1\u7406\u8d54\u7ed3\u6848\u63a8\u9001-\u836f\u5eb7\u4ed8\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YKF.getKey());
            }
        }
    }

    public void mxYqClaimEndCasePushTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YQ.getKey())) {
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YQ.getValue(), this.maxPushTimes);
                log.warn("\u788e\u7ba1\u7406\u8d54\u7ed3\u6848\u63a8\u9001-\u836f\u4f01\u65f6\u4efb\u52a1\u5f00\u59cb=={}", (Object)taskList.size());
                taskList.forEach(t -> this.mxClaimEndCasePushService.pushYqClaimEndCaseTask(t));
            }
            catch (Exception e) {
                log.error("\u788e\u7ba1\u7406\u8d54\u7ed3\u6848\u63a8\u9001-\u836f\u4f01\u5b9a\u65f6\u4efb\u52a1\u51fa\u9519: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YQ.getKey());
            }
        }
    }

    public void compensateBillsCheckTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.SG_BILLS_CHECK_BC.getKey())) {
            log.warn("\u9541\u4fe1\u8f6c\u8d26\u901a\u77e5\u788e\u7ba1-\u5bf9\u8d26\uff08\u5931\u8d25\u8865\u507f\uff09\u5f00\u59cb\uff1a");
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.BILL_CHECK_DETAIL_UPLOAD.getValue(), this.maxPushTimes);
                taskList.forEach(t -> {
                    String[] dateStr = t.getRemark().split("-");
                    DateTime beginDate = DateUtil.parse((CharSequence)dateStr[0], (String)"yyyyMMddHHmmss");
                    DateTime endDate = DateUtil.parse((CharSequence)dateStr[1], (String)"yyyyMMddHHmmss");
                    this.mxTransferNoticePushService.billCheckDetailUpload((Date)beginDate, (Date)endDate, null, null, t);
                });
            }
            catch (Exception e) {
                log.error("\u9541\u4fe1\u8f6c\u8d26\u901a\u77e5\u788e\u7ba1-\u5bf9\u8d26\uff08\u5931\u8d25\u8865\u507f\uff09: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.SG_BILLS_CHECK_BC.getKey());
            }
        }
    }

    public void sgClaimSupplementPushTask() {
        if (this.lock(ApisAutoTaskConstantsEnum.MX_CLAIM_SUPPLEMENT.getKey())) {
            log.warn("\u788e\u7ba1\u7406\u8d54\u8d44\u6599\u8865\u4f20\u5f00\u59cb\uff1a");
            try {
                List taskList = this.apisBusiAnalysisTaskLogService.getNeedPushTaskRecord(ApisAutoTaskConstantsEnum.MX_CLAIM_SUPPLEMENT.getValue(), this.maxPushTimes);
                taskList.forEach(t -> this.mxClaimMaterialPushService.pushClaimMaterialTask(t));
            }
            catch (Exception e) {
                log.error("\u788e\u7ba1\u7406\u8d54\u8d44\u6599\u8865\u4f20: ", (Throwable)e);
            }
            finally {
                this.deleteByKey(ApisAutoTaskConstantsEnum.MX_CLAIM_SUPPLEMENT.getKey());
            }
        }
    }

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 10L, TimeUnit.MINUTES);
    }

    public void deleteByKey(String key) {
        this.redisTemplate.delete((Object)key);
    }
}

