/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.mq;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core.MxTransferNoticePushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.mq.BillsCheckResultMqDTO;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxTransferNoticeOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxTransferNoticeOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="NO_JX_checkResult", selectorExpression="NO_JX_checkResult", consumerGroup="NO_JX_checkResultConsumerGroup")
public class BillsCheckResultTopicsListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(BillsCheckResultTopicsListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    ApisBusiMxTransferNoticeOrderService apisBusiMxTransferNoticeOrderService;
    @Autowired
    MxTransferNoticePushService mxTransferNoticePushService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received BillsCheckResultTopicsListener message: {}", (Object)message);
        Date startDate = new Date();
        String flag = "0";
        boolean dealFlag = false;
        try {
            BillsCheckResultMqDTO billsCheckResultMqDTO = (BillsCheckResultMqDTO)JSON.parseObject((String)message, BillsCheckResultMqDTO.class);
            ApisChannelConfigs apisChannelConfigs = this.mxTransferNoticePushService.getMerchantInfo();
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && billsCheckResultMqDTO.getMerchantId().equals(apisChannelConfigs.getConfigValue())) {
                dealFlag = true;
                this.updateStatus(billsCheckResultMqDTO);
            }
        }
        catch (Exception e) {
            flag = "1";
            log.error("BillsCheckResultTopicsListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            if (dealFlag) {
                ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
                apisMsgMqlogs.setCreateTime(startDate);
                apisMsgMqlogs.setMessage(message);
                apisMsgMqlogs.setTopic("NO_JX_checkResult:NO_JX_checkResult");
                apisMsgMqlogs.setConsumerGroup("NO_JX_checkResultConsumerGroup");
                apisMsgMqlogs.setErrorFlag(flag);
                apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
                this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
            }
        }
    }

    private void updateStatus(BillsCheckResultMqDTO billsCheckResultMqDTO) {
        ArrayList<String> failOrderNos = new ArrayList<String>();
        if (ObjectUtil.isNotEmpty((Object)billsCheckResultMqDTO.getErrorMessages())) {
            List errorMessages = billsCheckResultMqDTO.getErrorMessages();
            for (String message : errorMessages) {
                String[] arr = message.split(":");
                failOrderNos.add(arr[0]);
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"order_no", (Object)arr[0]);
                ApisBusiMxTransferNoticeOrder order = (ApisBusiMxTransferNoticeOrder)this.apisBusiMxTransferNoticeOrderService.getOne((Wrapper)queryWrapper, false);
                if (!ObjectUtil.isNotEmpty((Object)order)) continue;
                order.setCheckStatus(arr[1]);
                this.apisBusiMxTransferNoticeOrderService.updateById((Object)order);
            }
        }
        this.apisBusiMxTransferNoticeOrderService.updateCheckTaskStatusSuccess(billsCheckResultMqDTO.getCheckTaskNo(), failOrderNos);
    }
}

