/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.mq;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core.MxInsureOrderPushService;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxSubInsuredVoucher;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxSubInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxSubSuminsuredOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.MxCallbackPolicyInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.MxCallbackPolicyStatusRequest;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="PG_SubEndorStatus", selectorExpression="", consumerGroup="PG_SubEndorStatusConsumerGroup")
public class StatusChgResultTopicsListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(StatusChgResultTopicsListener.class);
    @Autowired
    private ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    private ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    private ApisBusiMxSubInsuredVoucherService apisBusiMxSubInsuredVoucherService;
    @Autowired
    private ApisBusiMxSubSuminsuredOrderService apisBusiMxSubSuminsuredOrderService;
    @Autowired
    private MxInsureOrderPushService mxInsureOrderPushService;
    @Value(value="${coreapi.thirdp.mxStatusChgCallback.url}")
    private String mxStatusChgCallbackUrl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received PG_SubEndorStatus:PG_SubEndorStatus message: {}", (Object)message);
        Date startDate = new Date();
        String flag = "0";
        try {
            boolean isAddTask = false;
            MxCallbackPolicyStatusRequest request = (MxCallbackPolicyStatusRequest)JSON.parseObject((String)message, MxCallbackPolicyStatusRequest.class);
            this.verifyData(request);
            List insureInfoList = request.getPolicyList();
            if (ObjectUtil.isNotEmpty((Object)insureInfoList)) {
                List orderNoList = insureInfoList.stream().filter(ins -> ObjectUtil.isNotEmpty((Object)ins) && StrUtil.isNotBlank((CharSequence)ins.getOrderNo())).map(ins -> ins.getOrderNo()).collect(Collectors.toList());
                List<MxCallbackPolicyInfo> virtualPolicyInfoList = insureInfoList.stream().filter(ins -> ObjectUtil.isNotEmpty((Object)ins) && StrUtil.equals((CharSequence)ins.getMxPolicyNo(), (CharSequence)ins.getOrderNo())).collect(Collectors.toList());
                List subInsuredVoucherList = null;
                Iterable subSuminsuredOrderList = null;
                if (ObjectUtil.isNotEmpty(orderNoList)) {
                    subInsuredVoucherList = this.apisBusiMxSubInsuredVoucherService.listByOrderNos(orderNoList, request.getContractNo(), "YKF", true);
                    subSuminsuredOrderList = this.apisBusiMxSubSuminsuredOrderService.listByOrderNos(orderNoList, request.getContractNo(), "YKF", true);
                }
                if (ObjectUtil.isNotEmpty(virtualPolicyInfoList)) {
                    ArrayList virtualInsuredVoucherList = new ArrayList();
                    virtualPolicyInfoList.forEach(pol -> {
                        ApisBusiMxSubInsuredVoucher voucher = new ApisBusiMxSubInsuredVoucher();
                        if (ObjectUtil.isNotEmpty((Object)pol.getStatusChgResult())) {
                            voucher.setStatusChgResult(pol.getStatusChgResult().toString());
                        }
                        voucher.setStatusChgTime(pol.getStatusTime());
                        voucher.setStatusChgComment(pol.getStatusComment());
                        voucher.setContractNo(request.getContractNo());
                        voucher.setMxPolicyNo(pol.getMxPolicyNo());
                        voucher.setPolicyNo(pol.getPolicyNo());
                        virtualInsuredVoucherList.add(voucher);
                    });
                    int updCount = this.apisBusiMxSubInsuredVoucherService.updateStatusChgByPolicyNo(virtualInsuredVoucherList, true);
                    if (updCount > 0) {
                        isAddTask = true;
                    }
                }
                if (ObjectUtil.isNotEmpty(subInsuredVoucherList)) {
                    isAddTask = true;
                    subInsuredVoucherList.forEach(voucher -> {
                        List callbackPolicyInfoList = insureInfoList.stream().filter(ins -> StrUtil.equals((CharSequence)voucher.getOrderNo(), (CharSequence)ins.getOrderNo()) && StrUtil.equals((CharSequence)voucher.getMxPolicyNo(), (CharSequence)ins.getMxPolicyNo()) && StrUtil.equals((CharSequence)voucher.getContractNo(), (CharSequence)request.getContractNo()) && StrUtil.equals((CharSequence)voucher.getPolicyNo(), (CharSequence)ins.getPolicyNo())).collect(Collectors.toList());
                        if (ObjectUtil.isNotEmpty(callbackPolicyInfoList)) {
                            if (ObjectUtil.isNotEmpty((Object)((MxCallbackPolicyInfo)callbackPolicyInfoList.get(0)).getStatusChgResult())) {
                                voucher.setStatusChgResult(((MxCallbackPolicyInfo)callbackPolicyInfoList.get(0)).getStatusChgResult().toString());
                            }
                            voucher.setStatusChgTime(((MxCallbackPolicyInfo)callbackPolicyInfoList.get(0)).getStatusTime());
                            voucher.setStatusChgComment(((MxCallbackPolicyInfo)callbackPolicyInfoList.get(0)).getStatusComment());
                        }
                    });
                    this.apisBusiMxSubInsuredVoucherService.updateStatusChgByIds(subInsuredVoucherList);
                }
                if (ObjectUtil.isNotEmpty(subSuminsuredOrderList)) {
                    isAddTask = true;
                    subSuminsuredOrderList.forEach(voucher -> {
                        List callbackPolicyInfoList = insureInfoList.stream().filter(ins -> StrUtil.equals((CharSequence)voucher.getOrderNo(), (CharSequence)ins.getOrderNo()) && StrUtil.equals((CharSequence)voucher.getMxPolicyNo(), (CharSequence)ins.getMxPolicyNo()) && StrUtil.equals((CharSequence)voucher.getContractNo(), (CharSequence)request.getContractNo()) && StrUtil.equals((CharSequence)voucher.getPolicyNo(), (CharSequence)ins.getPolicyNo())).collect(Collectors.toList());
                        if (ObjectUtil.isNotEmpty(callbackPolicyInfoList)) {
                            if (ObjectUtil.isNotEmpty((Object)((MxCallbackPolicyInfo)callbackPolicyInfoList.get(0)).getStatusChgResult())) {
                                voucher.setStatusChgResult(((MxCallbackPolicyInfo)callbackPolicyInfoList.get(0)).getStatusChgResult().toString());
                            }
                            voucher.setStatusChgTime(((MxCallbackPolicyInfo)callbackPolicyInfoList.get(0)).getStatusTime());
                            voucher.setStatusChgComment(((MxCallbackPolicyInfo)callbackPolicyInfoList.get(0)).getStatusComment());
                        }
                    });
                    this.apisBusiMxSubSuminsuredOrderService.updateStatusChgByIds((List)subSuminsuredOrderList);
                }
            }
            if (isAddTask) {
                ApisBusiAnalysisTaskLog task = new ApisBusiAnalysisTaskLog();
                task.setBusinessKey(request.getContractNo());
                task.setPushType(ApisAutoTaskConstantsEnum.MX_SUB_STATUS_CHG_CALLBACK.getValue());
                task.setPushContent(JSON.toJSONString((Object)request));
                task.setPushStatus("2");
                task.setPushStep(Integer.valueOf(0));
                task.setPushTargetUrl(this.mxStatusChgCallbackUrl);
                this.apisBusiAnalysisTaskLogService.save((Object)task);
                this.mxInsureOrderPushService.asyncMxStatusChgcallback(task);
            }
        }
        catch (Exception e) {
            flag = "1";
            log.error("StatusChgResultTopicsListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
            apisMsgMqlogs.setCreateTime(startDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("PG_SubEndorStatus:");
            apisMsgMqlogs.setConsumerGroup("PG_SubEndorStatusConsumerGroup");
            apisMsgMqlogs.setErrorFlag(flag);
            apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
        }
    }

    private void verifyData(MxCallbackPolicyStatusRequest request) throws ApisBusinessException {
        if (ObjectUtils.isEmpty((Object)request)) {
            log.error("Mq\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4f20\u5165\u6d88\u606f"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }
}

