/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.mq;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.agent.MxClaimEndCasePushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.mq.ThirdpClaimEndCaseMqDTO;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimEndCaseClaim;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimEndCaseRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYqClaimEndCasePaymentInfo;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYqClaimEndCaseRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.ChannelUserConfigUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.AnalysisConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.msg.entity.ApisMsgMqlogs;
import com.jdaz.sinosoftgz.apis.commons.service.msg.service.ApisMsgMqlogsService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.apache.rocketmq.spring.core.RocketMQListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@RocketMQMessageListener(topic="SendApisClaimStatus", selectorExpression="*", consumerGroup="SendApisClaimStatusConsumerGroup")
public class ThirdpClaimEndCaseTopicsListener
implements RocketMQListener<String> {
    private static final Logger log = LoggerFactory.getLogger(ThirdpClaimEndCaseTopicsListener.class);
    @Autowired
    ApisMsgMqlogsService apisMsgMqlogsService;
    @Autowired
    MxClaimEndCasePushService mxClaimEndCasePushService;
    @Autowired
    ApisBusiMxClaimRegistService apisBusiMxClaimRegistService;
    @Autowired
    ChannelUserConfigUtil channelUserConfigUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(String message) {
        log.warn("received ThirdpClaimEndCaseTopicsListener message: {}", (Object)message);
        Date startDate = new Date();
        String flag = "0";
        try {
            MxYqClaimEndCaseRequest request;
            ThirdpClaimEndCaseMqDTO dto = (ThirdpClaimEndCaseMqDTO)JSON.parseObject((String)message, ThirdpClaimEndCaseMqDTO.class);
            this.verifyData(dto);
            ApisBusiMxClaimRegist regist = this.apisBusiMxClaimRegistService.getByClaimApplyId(dto.getClaimApplyId());
            Object convertData = this.convertData(regist, dto);
            log.warn("\u8f6c\u6362\u540e\u7684\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)convertData));
            if (ObjectUtils.isNotEmpty((Object)convertData) && convertData instanceof MxYkfClaimEndCaseRequest) {
                MxYkfClaimEndCaseRequest request2 = (MxYkfClaimEndCaseRequest)convertData;
                if (ObjectUtils.isNotEmpty((Object)request2)) {
                    this.mxClaimEndCasePushService.pushYkfClaimEndCase(request2, dto.getClaimApplyId(), null);
                }
            } else if (ObjectUtils.isNotEmpty((Object)convertData) && convertData instanceof MxYqClaimEndCaseRequest && ObjectUtils.isNotEmpty((Object)(request = (MxYqClaimEndCaseRequest)convertData))) {
                this.mxClaimEndCasePushService.pushYqClaimEndCase(request, dto.getClaimApplyId(), regist, null);
            }
        }
        catch (Exception e) {
            flag = "1";
            log.error("ThirdpClaimEndCaseTopicsListener \u5f02\u5e38: ", (Throwable)e);
        }
        finally {
            ApisMsgMqlogs apisMsgMqlogs = new ApisMsgMqlogs();
            apisMsgMqlogs.setCreateTime(startDate);
            apisMsgMqlogs.setMessage(message);
            apisMsgMqlogs.setTopic("SendApisClaimStatus:*");
            apisMsgMqlogs.setConsumerGroup("SendApisClaimStatusConsumerGroup");
            apisMsgMqlogs.setErrorFlag(flag);
            apisMsgMqlogs.setReleaseTime(LocalDateTime.now());
            this.apisMsgMqlogsService.save((Object)apisMsgMqlogs);
        }
    }

    private Object convertData(ApisBusiMxClaimRegist regist, ThirdpClaimEndCaseMqDTO thirdpClaimEndCaseMqDTO) {
        if (ObjectUtils.isEmpty((Object)regist) || ObjectUtils.isEmpty((Object)regist.getProjectCode())) {
            log.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u9541\u4fe1\u7acb\u6848\u4fe1\u606f\uff0cclaimApplyId\uff1a{}", (Object)thirdpClaimEndCaseMqDTO.getClaimApplyId());
            return null;
        }
        if ("YKF".equals(regist.getProjectCode())) {
            MxYkfClaimEndCaseRequest request = new MxYkfClaimEndCaseRequest();
            request.setContractNo(regist.getContractNo());
            request.setTransactonNo(thirdpClaimEndCaseMqDTO.getTransactonNo());
            if (ObjectUtils.isNotEmpty((Object)thirdpClaimEndCaseMqDTO.getPaymentDate())) {
                request.setPaymentDate(DateUtil.format((Date)thirdpClaimEndCaseMqDTO.getPaymentDate(), (String)"yyyyMMddHHmmss"));
            }
            if (ObjectUtils.isNotEmpty((Object)thirdpClaimEndCaseMqDTO.getClaimAmount())) {
                request.setPaymentAmount(Integer.valueOf(thirdpClaimEndCaseMqDTO.getClaimAmount().movePointRight(2).intValue()));
            }
            ArrayList<MxYkfClaimEndCaseClaim> claimList = new ArrayList<MxYkfClaimEndCaseClaim>();
            MxYkfClaimEndCaseClaim claim = new MxYkfClaimEndCaseClaim();
            claim.setRegistNo(regist.getRegistNo());
            claim.setMxReportNo(regist.getMxReportNo());
            claim.setPolicyNo(regist.getPolicyNo());
            claim.setMxPolicyNo(regist.getMxPolicyNo());
            claim.setOrderNo(regist.getOrderNo());
            if (AnalysisConstants.ThirdpAcceptCaseStatus.PAYED.getValue().equals(thirdpClaimEndCaseMqDTO.getCaseStatus())) {
                claim.setClaimType(AnalysisConstants.MX_YKF_CLAIM_TYPE.PAYED);
            } else {
                claim.setClaimType(AnalysisConstants.MX_YKF_CLAIM_TYPE.REJECT);
            }
            claimList.add(claim);
            request.setClaimList(claimList);
            return request;
        }
        if ("YQ".equals(regist.getProjectCode())) {
            MxYqClaimEndCaseRequest request = new MxYqClaimEndCaseRequest();
            request.setReportNo(regist.getRegistNo());
            request.setMxReportNo(regist.getMxReportNo());
            request.setPolicyNo(regist.getPolicyNo());
            request.setMxPolicyNo(regist.getMxPolicyNo());
            request.setProjectCode(this.channelUserConfigUtil.getClaimProjectCodeByContractNo(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo()));
            request.setContractNo(regist.getContractNo());
            if (AnalysisConstants.ThirdpAcceptCaseStatus.PAYED.getValue().equals(thirdpClaimEndCaseMqDTO.getCaseStatus())) {
                request.setClaimStatus(AnalysisConstants.MX_YQ_CLAIM_STATUS.PAYED);
            } else {
                request.setClaimStatus(AnalysisConstants.MX_YQ_CLAIM_STATUS.REJECT);
            }
            request.setReason(thirdpClaimEndCaseMqDTO.getRemark());
            MxYqClaimEndCasePaymentInfo paymentInfo = new MxYqClaimEndCasePaymentInfo();
            paymentInfo.setTransId(thirdpClaimEndCaseMqDTO.getTransactonNo());
            paymentInfo.setPaymentDate(DateUtil.format((Date)thirdpClaimEndCaseMqDTO.getPaymentDate(), (String)"yyyyMMddHHmmss"));
            if (ObjectUtils.isNotEmpty((Object)thirdpClaimEndCaseMqDTO.getClaimAmount())) {
                paymentInfo.setPaymentAmount(Integer.valueOf(thirdpClaimEndCaseMqDTO.getClaimAmount().movePointRight(2).intValue()));
            }
            request.setPaymentInfo(paymentInfo);
            return request;
        }
        return null;
    }

    private void verifyData(ThirdpClaimEndCaseMqDTO dto) throws ApisBusinessException {
        if (ObjectUtils.isEmpty((Object)dto)) {
            log.error("Mq\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10008.getValue().replace("##", "\u4f20\u5165\u6d88\u606f"), ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
    }
}

