/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.agent;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimEndCaseRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYqClaimEndCaseRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MeiXinResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.ChannelUserConfigUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.MxHttpPushUtil;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.time.LocalDateTime;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MxClaimEndCasePushService {
    private static final Logger log = LoggerFactory.getLogger(MxClaimEndCasePushService.class);
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    ChannelUserConfigUtil channelUserConfigUtil;
    @Autowired
    MxHttpPushUtil mxHttpPushUtil;

    public void pushYkfClaimEndCase(MxYkfClaimEndCaseRequest mxYkfClaimEndCaseRequest, String businessKey, ApisBusiAnalysisTaskLog taskLog) {
        try {
            String pushUrl = this.apisChannelConfigsService.getConfigValue("MxYkfClaimEndCasePushUrl");
            if (ObjectUtils.isEmpty((Object)pushUrl)) {
                if (ObjectUtil.isNotEmpty((Object)taskLog)) {
                    taskLog.setPushStatus("5");
                    taskLog.setRemark("\u672a\u914d\u7f6e\u9541\u4fe1-\u836f\u5eb7\u4ed8-\u7406\u8d54\u7ed3\u6848\u63a8\u9001\u63a8\u9001URL");
                    this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
                }
                return;
            }
            if (ObjectUtil.isEmpty((Object)taskLog)) {
                taskLog = new ApisBusiAnalysisTaskLog();
                taskLog.setPushType(ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YKF.getValue());
                taskLog.setBusinessKey(businessKey);
                taskLog.setPushStep(Integer.valueOf(1));
            } else {
                taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
            }
            taskLog.setPushStatus("2");
            taskLog.setLastPushTime(LocalDateTime.now());
            taskLog.setPushTargetUrl(pushUrl);
            taskLog.setPushContent(JSON.toJSONString((Object)mxYkfClaimEndCaseRequest));
            log.warn("\u4eac\u4e1c\u5b89\u8054->\u9541\u4fe1-\u836f\u5eb7\u4ed8\u7406\u8d54\u7ed3\u6848\u63a8\u9001request\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)mxYkfClaimEndCaseRequest));
            MeiXinResponse response = this.mxHttpPushUtil.convertAndSendYkf(pushUrl, (Object)mxYkfClaimEndCaseRequest, ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YKF.getValue());
            log.warn("\u4eac\u4e1c\u5b89\u8054->\u9541\u4fe1-\u836f\u5eb7\u4ed8\u7406\u8d54\u7ed3\u6848\u63a8\u9001response\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)response));
            if (ObjectUtils.isEmpty((Object)response) || ObjectUtils.isEmpty((Object)response.getResultCode())) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u9541\u4fe1-\u836f\u5eb7\u4ed8-\u7406\u8d54\u7ed3\u6848\u63a8\u9001\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
            } else {
                if (AnalysisErrorCodeEnum.ERR_B000000.getKey().equals(response.getResultCode())) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                    log.error("\u9541\u4fe1-\u836f\u5eb7\u4ed8-\u7406\u8d54\u7ed3\u6848\u63a8\u9001\u6e20\u9053,\u8fd4\u56de\u5185\u5bb9:{}", (Object)response.getResultMsg());
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1-\u836f\u5eb7\u4ed8-\u7406\u8d54\u7ed3\u6848\u63a8\u9001\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            }
            taskLog.setErrMsg(e.getMessage());
        }
        if (ObjectUtils.isEmpty((Object)taskLog.getId())) {
            this.apisBusiAnalysisTaskLogService.saveTaskInfo(taskLog);
        } else {
            this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
        }
    }

    public void pushYkfClaimEndCaseTask(ApisBusiAnalysisTaskLog taskLog) {
        MxYkfClaimEndCaseRequest endCaseRequest;
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (ObjectUtil.isEmpty((Object)taskLog.getPushContent())) {
            log.error("\u4efb\u52a1businessKey={}, \u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u4fe1\u606f", (Object)taskLog.getBusinessKey());
            return;
        }
        try {
            endCaseRequest = (MxYkfClaimEndCaseRequest)JSON.parseObject((String)taskLog.getPushContent(), MxYkfClaimEndCaseRequest.class);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u65e5\u5fd7\u63a8\u9001\u5185\u5bb9\u5e8f\u5217\u5316\u5931\u8d25,", (Throwable)e);
            return;
        }
        this.pushYkfClaimEndCase(endCaseRequest, taskLog.getBusinessKey(), taskLog);
    }

    public void pushYqClaimEndCase(MxYqClaimEndCaseRequest mxYqClaimEndCaseRequest, String businessKey, ApisBusiMxClaimRegist regist, ApisBusiAnalysisTaskLog taskLog) {
        try {
            String pushUrl = null;
            if (ObjectUtil.isNotEmpty((Object)taskLog)) {
                pushUrl = taskLog.getPushTargetUrl();
            } else if (ObjectUtil.isNotEmpty((Object)regist)) {
                pushUrl = this.channelUserConfigUtil.getYqCallbackUrlByContractNo(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo());
            }
            if (ObjectUtils.isEmpty((Object)pushUrl)) {
                if (ObjectUtil.isNotEmpty((Object)taskLog)) {
                    taskLog.setPushStatus("5");
                    taskLog.setRemark("\u672a\u914d\u7f6e\u9541\u4fe1-\u836f\u4f01-\u7406\u8d54\u7ed3\u6848\u63a8\u9001\u63a8\u9001URL");
                    this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
                }
                return;
            }
            if (ObjectUtil.isEmpty((Object)taskLog)) {
                taskLog = new ApisBusiAnalysisTaskLog();
                taskLog.setPushType(ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YQ.getValue());
                taskLog.setBusinessKey(businessKey);
                taskLog.setPushStep(Integer.valueOf(1));
            } else {
                taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
            }
            taskLog.setPushStatus("2");
            taskLog.setLastPushTime(LocalDateTime.now());
            taskLog.setPushTargetUrl(pushUrl);
            taskLog.setPushContent(JSON.toJSONString((Object)mxYqClaimEndCaseRequest));
            log.warn("\u4eac\u4e1c\u5b89\u8054->\u9541\u4fe1-\u836f\u4f01\u7406\u8d54\u7ed3\u6848\u63a8\u9001request\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)mxYqClaimEndCaseRequest));
            MeiXinResponse response = this.mxHttpPushUtil.convertAndSendYq(pushUrl, (Object)mxYqClaimEndCaseRequest, ApisAutoTaskConstantsEnum.CLAIM_END_CASE_TO_MX_YQ.getValue());
            log.warn("\u4eac\u4e1c\u5b89\u8054->\u9541\u4fe1-\u836f\u4f01\u7406\u8d54\u7ed3\u6848\u63a8\u9001response\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)response));
            if (ObjectUtils.isEmpty((Object)response) || ObjectUtils.isEmpty((Object)response.getResultCode())) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u9541\u4fe1-\u836f\u4f01-\u7406\u8d54\u7ed3\u6848\u63a8\u9001\u6e20\u9053\u672a\u8fd4\u56de\u5185\u5bb9");
            } else {
                if (AnalysisErrorCodeEnum.ERR_B000000.getKey().equals(response.getResultCode())) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                    log.error("\u9541\u4fe1-\u836f\u4f01-\u7406\u8d54\u7ed3\u6848\u63a8\u9001\u6e20\u9053,\u8fd4\u56de\u5185\u5bb9:{}", (Object)response.getResultMsg());
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1-\u836f\u4f01-\u7406\u8d54\u7ed3\u6848\u63a8\u9001\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            }
            taskLog.setErrMsg(e.getMessage());
        }
        if (ObjectUtils.isEmpty((Object)taskLog.getId())) {
            this.apisBusiAnalysisTaskLogService.saveTaskInfo(taskLog);
        } else {
            this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
        }
    }

    public void pushYqClaimEndCaseTask(ApisBusiAnalysisTaskLog taskLog) {
        MxYqClaimEndCaseRequest endCaseRequest;
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (ObjectUtil.isEmpty((Object)taskLog.getPushContent())) {
            log.error("\u4efb\u52a1businessKey={}, \u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u4fe1\u606f", (Object)taskLog.getBusinessKey());
            return;
        }
        try {
            endCaseRequest = (MxYqClaimEndCaseRequest)JSON.parseObject((String)taskLog.getPushContent(), MxYqClaimEndCaseRequest.class);
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u65e5\u5fd7\u63a8\u9001\u5185\u5bb9\u5e8f\u5217\u5316\u5931\u8d25,", (Throwable)e);
            return;
        }
        this.pushYqClaimEndCase(endCaseRequest, taskLog.getBusinessKey(), null, taskLog);
    }
}

