/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimRegistImageData;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimSupplementDTO;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimSupplementRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.ThirdpClaimSupplementResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.ClaimMediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.AnalysisConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMaterial;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMaterialService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMediaService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ResponseHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MxClaimMaterialPushService {
    private static final Logger log = LoggerFactory.getLogger(MxClaimMaterialPushService.class);
    @Autowired
    ClaimMediaUploadUtil claimMediaUploadUtil;
    @Autowired
    ApisBusiMxClaimRegistService apisBusiMxClaimRegistService;
    @Autowired
    HttpRequestService httpRequestService;
    @Value(value="${coreapi.thirdp.mxClaimSupplement.url}")
    String mxClaimSupplementUrl;
    @Autowired
    ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiMxClaimMediaService apisBusiMxClaimMediaService;
    @Autowired
    ApisBusiMxClaimMaterialService apisBusiMxClaimMaterialService;

    public void convertAndPush(ApisBusiMxClaimMaterial apisBusiMxClaimMaterial, List<ApisBusiMxClaimMedia> mediaList, ApisBusiAnalysisTaskLog taskLog) {
        ApisBusiMxClaimRegist apisBusiMxClaimRegist = this.apisBusiMxClaimRegistService.getByMxReportNo(apisBusiMxClaimMaterial.getMxReportNo());
        if (ObjectUtil.isEmpty((Object)apisBusiMxClaimRegist)) {
            log.error("\u6839\u636e\u9541\u4fe1\u62a5\u6848\u53f7\uff1a{}\u627e\u4e0d\u5230\u7acb\u6848\u6570\u636e", (Object)apisBusiMxClaimMaterial.getMxReportNo());
            return;
        }
        try {
            mediaList = this.claimMediaUploadUtil.asyncUploadMxClaimMedia(apisBusiMxClaimRegist, mediaList);
            List imageDataList = this.covertImageData(mediaList);
            ThirdpClaimSupplementDTO thirdpClaimSupplementDTO = ThirdpClaimSupplementDTO.builder().claimApplyId(apisBusiMxClaimRegist.getClaimApplyId()).proposalOrder(apisBusiMxClaimRegist.getPk()).imageDatas(imageDataList).build();
            RequestHeadDTO requestHeadDTO = RequestHeadDTO.initRequestHead();
            requestHeadDTO.setConsumerID(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_CONSUMER_ID"));
            ThirdpClaimSupplementRequest thirdpClaimSupplementRequest = ThirdpClaimSupplementRequest.builder().head(requestHeadDTO).body(thirdpClaimSupplementDTO).build();
            taskLog.setPushContent(JSON.toJSONString((Object)thirdpClaimSupplementRequest));
            this.pushClaimMaterial(taskLog);
        }
        catch (ApisBusinessException e) {
            log.error("\u7406\u8d54\u8d44\u6599\u8865\u5145\u5f02\u6b65\u4e0a\u4f20\u5f71\u50cf\u5e76\u901a\u77e5\u788e\u7ba1\u5f02\u5e38:", (Throwable)e);
        }
    }

    private List<ThirdpClaimRegistImageData> covertImageData(List<ApisBusiMxClaimMedia> mediaList) {
        return mediaList.stream().map(media -> {
            ThirdpClaimRegistImageData imageData = new ThirdpClaimRegistImageData();
            imageData.setDataType(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_DATA_TYPE"));
            imageData.setDataUrl(media.getMediaUrl());
            imageData.setDataName(media.getMediaNo() + "." + media.getFileSuffix());
            imageData.setImageId(media.getImageId());
            return imageData;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushClaimMaterial(ApisBusiAnalysisTaskLog taskLog) {
        try {
            taskLog.setPushTargetUrl(this.mxClaimSupplementUrl);
            taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
            taskLog.setPushStatus("2");
            taskLog.setLastPushTime(LocalDateTime.now());
            String responseStr = this.httpRequestService.convertAndSendForThirdp(this.mxClaimSupplementUrl, taskLog.getPushContent(), ResponseHeadDTO.class, ApisAutoTaskConstantsEnum.MX_CLAIM_SUPPLEMENT.getKey());
            if (StringUtils.isNotEmpty((CharSequence)responseStr)) {
                ThirdpClaimSupplementResponse response = (ThirdpClaimSupplementResponse)JSON.parseObject((String)responseStr, ThirdpClaimSupplementResponse.class);
                if (AnalysisConstants.SG_BILLS_CHECK.RESPONSE_STATUS.SUCCESS.intValue() == response.getHead().getStatus()) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                    taskLog.setErrMsg(response.getHead().getAppMessage());
                }
            } else {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u788e\u7ba1\u7406\u8d54\u8d44\u6599\u8865\u4f20\u63a5\u53e3\u672a\u8fd4\u56de\u5185\u5bb9");
            }
        }
        catch (Exception e) {
            taskLog.setPushStatus("4");
            taskLog.setErrMsg(e.getLocalizedMessage());
        }
        finally {
            if (ObjectUtils.isEmpty((Object)taskLog.getId())) {
                this.apisBusiAnalysisTaskLogService.saveTaskInfo(taskLog);
            } else {
                this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
            }
        }
    }

    public void pushClaimMaterialTask(ApisBusiAnalysisTaskLog taskLog) {
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if (ObjectUtil.isEmpty((Object)taskLog.getPushContent())) {
            if (StringUtils.isBlank((CharSequence)taskLog.getBusinessKey())) {
                log.error("\u63a8\u9001\u4e1a\u52a1\u952ebusinessKey\u4e3a\u7a7a");
                return;
            }
            ApisBusiMxClaimMaterial apisBusiMxClaimMaterial = this.apisBusiMxClaimMaterialService.getMxClaimMaterial(taskLog.getBusinessKey());
            if (ObjectUtil.isEmpty((Object)apisBusiMxClaimMaterial)) {
                log.error("\u65e0\u53ef\u63a8\u9001\u7684\u8d44\u6599\u8865\u4f20\u4fe1\u606f:{}", (Object)taskLog.getBusinessKey());
                return;
            }
            List mediaList = this.apisBusiMxClaimMediaService.getByRequestId(taskLog.getBusinessKey());
            if (ObjectUtil.isEmpty((Object)mediaList)) {
                log.error("\u65e0\u53ef\u63a8\u9001\u7684\u591a\u5a92\u4f53\u4fe1\u606f:{}", (Object)taskLog.getBusinessKey());
                return;
            }
            this.convertAndPush(apisBusiMxClaimMaterial, mediaList, taskLog);
        } else {
            this.pushClaimMaterial(taskLog);
        }
    }
}

