/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core.MxInsureOrderPushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MeiXinResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.CoreThirdpPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.MxHttpPushUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.MxUploadInsureDataUtil;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxSubInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxSubSuminsuredOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.MxCallbackPolicyStatusRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.UploadRiskData;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.resp.ThirdpResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.resp.UploadRiskResData;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.time.LocalDateTime;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class MxInsureOrderPushService {
    private static final Logger log = LoggerFactory.getLogger(MxInsureOrderPushService.class);
    @Autowired
    private MxUploadInsureDataUtil mxUploadInsureDataUtil;
    @Autowired
    private ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    private ApisBusiMxSubInsuredVoucherService apisBusiMxSubInsuredVoucherService;
    private ApisBusiMxSubSuminsuredOrderService apisBusiMxSubSuminsuredOrderService;
    @Autowired
    private CoreThirdpPushUtil coreThirdpPushUtil;
    @Autowired
    private MxHttpPushUtil mxHttpPushUtil;
    @Value(value="${coreapi.thirdp.mxStatusChgCallback.url}")
    private String mxStatusChgCallbackUrl;
    private static final Predicate<ApisBusiAnalysisTaskLog> PUSH_TARGET_URL_NOT_BLANK_PREDICATE = taskLog -> ObjectUtil.isNotEmpty((Object)taskLog) && StrUtil.isNotBlank((CharSequence)taskLog.getPushTargetUrl());
    private static final Predicate<ApisBusiAnalysisTaskLog> PUSH_CONTENT_NOT_BLANK_PREDICATE = taskLog -> ObjectUtil.isNotEmpty((Object)taskLog) && StrUtil.isNotBlank((CharSequence)taskLog.getPushContent());

    public void commonDoTask(ApisBusiAnalysisTaskLog busiTaskLog, Predicate<ApisBusiAnalysisTaskLog> predicate, TaskBusinessFunction taskBusinessFunction) {
        if (ObjectUtil.isEmpty((Object)busiTaskLog)) {
            return;
        }
        boolean isValid = true;
        if (ObjectUtil.isNotEmpty(predicate)) {
            isValid = predicate.test(busiTaskLog);
        }
        if (!isValid) {
            busiTaskLog.setPushStatus("5");
            this.apisBusiAnalysisTaskLogService.updateById((Object)busiTaskLog);
            return;
        }
        boolean isUpdSuccess = false;
        try {
            busiTaskLog.setPushStatus("2");
            busiTaskLog.setPushStep(Integer.valueOf(busiTaskLog.getPushStep() + 1));
            busiTaskLog.setLastPushTime(LocalDateTime.now());
            isUpdSuccess = this.apisBusiAnalysisTaskLogService.updateById((Object)busiTaskLog);
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0taskLog\u4efb\u52a1\u72b6\u6001\u51fa\u9519\uff1a", (Throwable)e);
        }
        if (isUpdSuccess) {
            try {
                boolean isSuccess = taskBusinessFunction.doTask(busiTaskLog);
                if (isSuccess) {
                    busiTaskLog.setPushStatus("1");
                } else {
                    busiTaskLog.setPushStatus("4");
                }
            }
            catch (Exception e) {
                log.error("\u4efb\u52a1\u7c7b\u578b={}\uff0c\u4efb\u52a1businessKey={}\u6267\u884c\u51fa\u9519:", new Object[]{busiTaskLog.getPushType(), busiTaskLog.getBusinessKey(), e});
                busiTaskLog.setPushStatus("4");
                busiTaskLog.setErrMsg(ObjectUtil.isNotEmpty((Object)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT ? e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT) : e.getMessage());
            }
            this.apisBusiAnalysisTaskLogService.updateById((Object)busiTaskLog);
        }
    }

    public void uploadMxOrderDataToInsureRisk(ApisBusiAnalysisTaskLog busiAnalysisTaskLog) {
        this.uploadMxOrderDataToInsureRiskCore(busiAnalysisTaskLog, null);
    }

    public void uploadMxOrderDataToInsureRiskCore(ApisBusiAnalysisTaskLog busiAnalysisTaskLog, BiConsumer<UploadRiskData, ApisBusiAnalysisTaskLog> successConsumer) {
        this.commonDoTask(busiAnalysisTaskLog, PUSH_TARGET_URL_NOT_BLANK_PREDICATE.and(PUSH_CONTENT_NOT_BLANK_PREDICATE), taskLog -> {
            ThirdpRequest thirdpRequest = (ThirdpRequest)JSON.parseObject((String)taskLog.getPushContent(), ThirdpRequest.class);
            UploadRiskData uploadRiskData = null;
            if (ObjectUtil.isNotEmpty((Object)thirdpRequest.getData())) {
                uploadRiskData = (UploadRiskData)JSON.parseObject((String)thirdpRequest.getData().toString(), UploadRiskData.class);
            }
            ThirdpResponse response = this.coreThirdpPushUtil.convertAndSend(taskLog.getPushTargetUrl(), thirdpRequest.getAgency(), (Object)uploadRiskData, thirdpRequest.getHead().getServiceName(), UploadRiskResData.class);
            boolean result = true;
            if (ObjectUtils.isEmpty((Object)response) || ObjectUtils.isEmpty((Object)response.getData())) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u9541\u4fe1-\u521b\u5efa\u56e2\u5355\u2014\u4e0a\u4f20\u788e\u7ba1\u672a\u8fd4\u56de\u5185\u5bb9");
                result = false;
            } else {
                if ("0000".equals(((UploadRiskResData)response.getData()).getErrorCode())) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                    result = false;
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
                if (null != successConsumer) {
                    successConsumer.accept(uploadRiskData, taskLog);
                }
            }
            return result;
        });
    }

    public void mxStatusChgcallback(ApisBusiAnalysisTaskLog busiAnalysisTaskLog) {
        this.commonDoTask(busiAnalysisTaskLog, PUSH_TARGET_URL_NOT_BLANK_PREDICATE.and(PUSH_CONTENT_NOT_BLANK_PREDICATE), taskLog -> {
            MxCallbackPolicyStatusRequest request = (MxCallbackPolicyStatusRequest)JSON.parseObject((String)taskLog.getPushContent(), MxCallbackPolicyStatusRequest.class);
            MeiXinResponse response = this.mxHttpPushUtil.convertAndSendYkf(taskLog.getPushTargetUrl(), (Object)request, ApisAutoTaskConstantsEnum.MX_SUB_STATUS_CHG_CALLBACK.getValue());
            boolean result = true;
            if (ObjectUtils.isEmpty((Object)response)) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u7ed3\u679c\u56de\u8c03\u901a\u77e5\u2014\u9541\u4fe1\u7aef\u672a\u8fd4\u56de\u5185\u5bb9");
                result = false;
            } else {
                if (AnalysisErrorCodeEnum.ERR_B000000.getKey().equals(response.getResultCode())) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                    result = false;
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
            }
            return result;
        });
    }

    @Async(value="callbackNotifyExecutor")
    public void asyncMxStatusChgcallback(ApisBusiAnalysisTaskLog busiAnalysisTaskLog) {
        this.mxStatusChgcallback(busiAnalysisTaskLog);
    }
}

