/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.BillCheckDetailInfo;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpBillCheckDetail;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpBillCheckDetailRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpBillCheckTaskInfo;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpBillCheckTaskRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpBillCheckTaskRequestDTO;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.ThirdpBillCheckDetailResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.ThirdpBillCheckTaskResponse;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.AnalysisConstants;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxTransferNoticeOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxTransferNoticeOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MxTransferNoticePushService {
    private static final Logger log = LoggerFactory.getLogger(MxTransferNoticePushService.class);
    @Autowired
    ApisBusiMxTransferNoticeOrderService apisBusiMxTransferNoticeOrderService;
    @Autowired
    HttpRequestService httpRequestService;
    @Value(value="${coreapi.thirdp.jXCreateBillCheckTask.url}")
    String billCheckTaskUrl;
    @Value(value="${coreapi.thirdp.jXBillCheckDetail.url}")
    String billCheckDetailUrl;
    @Autowired
    ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;

    public void billsCheck(Date beginDate, Date endDate) {
        Integer sumCount = this.getOrderCount(beginDate, endDate);
        log.warn("\u5bf9\u8d26\u8ba2\u5355\u6570\u636e\u91cf=={}", (Object)sumCount);
        if (sumCount == 0) {
            return;
        }
        ApisChannelConfigs merchantInfo = this.getMerchantInfo();
        if (ObjectUtil.isEmpty((Object)merchantInfo)) {
            log.warn("\u672a\u914d\u7f6e\u9541\u4fe1\u5546\u6237\u4fe1\u606f");
            return;
        }
        String checkTaskNo = this.getBillCheckTaskNo(beginDate, endDate, sumCount, merchantInfo);
        if (StrUtil.isNotEmpty((CharSequence)checkTaskNo)) {
            Integer sumGroupNum = sumCount / AnalysisConstants.SG_BILLS_CHECK.MAX_GROUP_NUM;
            if (sumCount % AnalysisConstants.SG_BILLS_CHECK.MAX_GROUP_NUM != 0) {
                Integer n = sumGroupNum;
                Integer n2 = sumGroupNum = Integer.valueOf(sumGroupNum + 1);
            }
            for (int i = 0; i < sumGroupNum; ++i) {
                Integer startNum = i * AnalysisConstants.SG_BILLS_CHECK.MAX_GROUP_NUM;
                ThirdpBillCheckDetail billCheckDetailInfo = ThirdpBillCheckDetail.builder().checkTaskNo(checkTaskNo).checkTaskGroupNo(this.getCheckGroupNo(Integer.valueOf(i + 1))).productItemType("BX0050").merchantId(merchantInfo.getConfigValue()).isFinish(i == sumGroupNum - 1 ? "Y" : "N").build();
                this.billCheckDetailUpload(beginDate, endDate, startNum, billCheckDetailInfo, null);
            }
        }
    }

    public ApisChannelConfigs getMerchantInfo() {
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode("mx_merchant_info");
        ApisChannelConfigs config = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
        if (ObjectUtil.isNotEmpty((Object)config)) {
            return config;
        }
        return null;
    }

    public String getBillCheckTaskNo(Date beginDate, Date endDate, Integer sumCount, ApisChannelConfigs channelConfigs) {
        BigDecimal sumPremium = this.apisBusiMxTransferNoticeOrderService.getSumPremium(beginDate, endDate);
        sumPremium = sumPremium.divide(new BigDecimal(100)).setScale(2, 4);
        ThirdpBillCheckTaskInfo thirdpBillCheckTaskInfo = ThirdpBillCheckTaskInfo.builder().businessType("02").productItemType("BX0050").makeCode(channelConfigs.getUserCode()).isCheckPremium("1").checkBeginTime(DateUtil.format((Date)beginDate, (String)"yyyy-MM-dd HH:mm:ss")).checkEndTime(DateUtil.format((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss")).sumCount(sumCount).sumAmount(sumPremium).build();
        ThirdpBillCheckTaskRequest thirdpBillCheckTaskRequest = ThirdpBillCheckTaskRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).requestBody(ThirdpBillCheckTaskRequestDTO.builder().billCheckTaskInfo(thirdpBillCheckTaskInfo).build()).build();
        try {
            ThirdpBillCheckTaskResponse response = (ThirdpBillCheckTaskResponse)this.httpRequestService.convertAndSendForAgent(this.billCheckTaskUrl, (Object)thirdpBillCheckTaskRequest, ThirdpBillCheckTaskResponse.class, "JXCreateBillCheckTask");
            if (ObjectUtil.isNotEmpty((Object)response)) {
                if (AnalysisConstants.SG_BILLS_CHECK.RESPONSE_STATUS.SUCCESS.intValue() == response.getResponseHead().getStatus() && ObjectUtil.isNotEmpty((Object)response.getResponseBody().getCheckTaskNo())) {
                    return response.getResponseBody().getCheckTaskNo();
                }
                log.error("\u83b7\u53d6\u5bf9\u8d26\u4efb\u52a1\u53f7\u5f02\u5e38:{}", (Object)response.getResponseHead().getAppMessage());
            } else {
                log.error("\u8c03\u7528\u83b7\u53d6\u5bf9\u8d26\u4efb\u52a1\u53f7\u63a5\u53e3\u8fd4\u56de\u7a7a");
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u5bf9\u8d26\u4efb\u52a1\u53f7\u5f02\u5e38\uff1a{}", (Throwable)e);
        }
        return null;
    }

    private List<ApisBusiMxTransferNoticeOrder> getOrderList(Date beginDate, Date endDate, Integer startNum) {
        return this.apisBusiMxTransferNoticeOrderService.getOrderListByPeriod(beginDate, endDate, startNum, AnalysisConstants.SG_BILLS_CHECK.MAX_GROUP_NUM);
    }

    private Integer getOrderCount(Date beginDate, Date endDate) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.ge((Object)"create_time", (Object)beginDate);
        queryWrapper.le((Object)"create_time", (Object)endDate);
        queryWrapper.ne((Object)"check_status", (Object)"0");
        queryWrapper.le((Object)"upload_times", (Object)ApisBusiMxTransferNoticeOrder.MAX_UPLOAD_TIMES);
        return this.apisBusiMxTransferNoticeOrderService.count((Wrapper)queryWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void billCheckDetailUpload(Date beginDate, Date endDate, Integer startNum, ThirdpBillCheckDetail thirdpBillCheckDetail, ApisBusiAnalysisTaskLog taskLog) {
        String requestStr = "";
        ThirdpBillCheckDetailRequest thirdpBillCheckDetailRequest = ThirdpBillCheckDetailRequest.builder().requestHead(RequestHeadDTO.initRequestHead()).build();
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            taskLog = new ApisBusiAnalysisTaskLog();
            taskLog.setPushStep(Integer.valueOf(1));
            taskLog.setPushType(ApisAutoTaskConstantsEnum.BILL_CHECK_DETAIL_UPLOAD.getKey());
            taskLog.setBusinessKey(thirdpBillCheckDetail.getCheckTaskNo() + "-" + thirdpBillCheckDetail.getCheckTaskGroupNo());
            taskLog.setRemark(DateUtil.format((Date)beginDate, (String)"yyyyMMddHHmmss") + "-" + DateUtil.format((Date)endDate, (String)"yyyyMMddHHmmss"));
            taskLog.setPushTargetUrl(this.billCheckDetailUrl);
            List orderList = this.getOrderList(beginDate, endDate, startNum);
            if (ObjectUtil.isEmpty((Object)orderList)) {
                if (ObjectUtil.isNotEmpty((Object)taskLog)) {
                    taskLog.setPushStatus("5");
                    taskLog.setErrMsg("\u6ca1\u6709\u53ef\u63a8\u9001\u7684\u8bb0\u5f55");
                    this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
                }
                return;
            }
            ArrayList<BillCheckDetailInfo> billCheckDetailInfos = new ArrayList<BillCheckDetailInfo>();
            for (ApisBusiMxTransferNoticeOrder order : orderList) {
                order.setCheckTaskNo(thirdpBillCheckDetail.getCheckTaskNo());
                order.setUploadTimes(Integer.valueOf(order.getUploadTimes() + 1));
                BigDecimal premium = order.getPremium().divide(new BigDecimal(100)).setScale(2, 4);
                BillCheckDetailInfo billCheckDetailInfo = BillCheckDetailInfo.builder().checkBusinessType("01").checkPk(order.getOrderNo()).checkPremium(premium).build();
                billCheckDetailInfos.add(billCheckDetailInfo);
            }
            thirdpBillCheckDetail.setBillCheckDetailInfos(billCheckDetailInfos);
            thirdpBillCheckDetailRequest.setRequestBody(thirdpBillCheckDetail);
            requestStr = JSON.toJSONString((Object)thirdpBillCheckDetailRequest);
            taskLog.setPushContent(requestStr);
            this.apisBusiMxTransferNoticeOrderService.saveOrUpdateBatch((Collection)orderList);
        } else {
            taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
            requestStr = taskLog.getPushContent();
            thirdpBillCheckDetailRequest = (ThirdpBillCheckDetailRequest)JSON.parseObject((String)requestStr, ThirdpBillCheckDetailRequest.class);
        }
        taskLog.setPushStatus("2");
        taskLog.setLastPushTime(LocalDateTime.now());
        try {
            ThirdpBillCheckDetailResponse response = (ThirdpBillCheckDetailResponse)this.httpRequestService.convertAndSendForAgent(this.billCheckDetailUrl, (Object)thirdpBillCheckDetailRequest, ThirdpBillCheckDetailResponse.class, "JXBillCheckDetail");
            if (ObjectUtil.isEmpty((Object)response) || ObjectUtil.isEmpty((Object)response.getResponseHead()) || ObjectUtil.isEmpty((Object)response.getResponseHead().getStatus())) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u5bf9\u8d26\u660e\u7ec6\u4e0a\u4f20\u672a\u8fd4\u56de\u5185\u5bb9");
            } else {
                if (AnalysisConstants.SG_BILLS_CHECK.RESPONSE_STATUS.SUCCESS.intValue() == response.getResponseHead().getStatus()) {
                    taskLog.setPushStatus("1");
                } else {
                    taskLog.setPushStatus("4");
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
            }
        }
        catch (Exception e) {
            log.error("\u5bf9\u8d26\u660e\u7ec6\u4e0a\u4f20\u5f02\u5e38\uff0c\u5bf9\u8d26\u4efb\u52a1\u53f7\uff1a{},\u5bf9\u8d26\u6279\u6b21\u53f7", (Object)thirdpBillCheckDetail.getCheckTaskNo(), (Object)thirdpBillCheckDetail.getCheckTaskGroupNo());
            taskLog.setPushStatus("4");
            taskLog.setErrMsg(e.getLocalizedMessage());
        }
        finally {
            ApisBusiAnalysisTaskLog analysisTaskLog = this.getAnalysisTaskLog(thirdpBillCheckDetail);
            if (ObjectUtil.isNotEmpty((Object)analysisTaskLog)) {
                this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
            } else {
                this.apisBusiAnalysisTaskLogService.saveTaskInfo(taskLog);
            }
        }
    }

    private ApisBusiAnalysisTaskLog getAnalysisTaskLog(ThirdpBillCheckDetail thirdpBillCheckDetail) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"business_key", (Object)(thirdpBillCheckDetail.getCheckTaskNo() + "-" + thirdpBillCheckDetail.getCheckTaskGroupNo()));
        queryWrapper.eq((Object)"push_type", (Object)ApisAutoTaskConstantsEnum.BILL_CHECK_DETAIL_UPLOAD.getKey());
        return (ApisBusiAnalysisTaskLog)this.apisBusiAnalysisTaskLogService.getOne((Wrapper)queryWrapper, false);
    }

    private String getCheckGroupNo(Integer groupNo) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumIntegerDigits(3);
        numberFormat.setGroupingUsed(false);
        return numberFormat.format(groupNo);
    }
}

