/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.agent.MxClaimEndCasePushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimEndCaseClaim;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimEndCaseRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYqClaimEndCasePaymentInfo;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYqClaimEndCaseRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimRegistBody;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimRegistClaimMain;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimRegistImageData;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimRegistPayee;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimRegistPayeeAml;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimRegistPayeeAmlCom;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpClaimRequestHead;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpCustomerBeneficiaryInfo;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpCustomerCertifyInfo;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.ThirdpClaimResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.ChannelUserConfigUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.ClaimMediaUploadUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.AnalysisConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiAnalysisTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiAnalysisTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMediaService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.constant.ModelConstants;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ThirdpClaimRegistPushService {
    private static final Logger log = LoggerFactory.getLogger(ThirdpClaimRegistPushService.class);
    @Autowired
    ApisBusiAnalysisTaskLogService apisBusiAnalysisTaskLogService;
    @Autowired
    ApisBusiMxAddInsuredVoucherService apisBusiMxAddInsuredVoucherService;
    @Autowired
    ApisBusiMxClaimRegistService apisBusiMxClaimRegistService;
    @Autowired
    ApisBusiMxClaimMediaService apisBusiMxClaimMediaService;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    ClaimMediaUploadUtil claimMediaUploadUtil;
    @Autowired
    MxClaimEndCasePushService mxClaimEndCasePushService;
    @Autowired
    ChannelUserConfigUtil channelUserConfigUtil;
    @Value(value="${coreapi.thirdp.claimRegist.url}")
    String thirdpClaimRegistUrl;
    @Value(value="${analysis.task.max_push_times}")
    private Integer maxPushTimes;
    private static final Integer POINT = 2;

    public void convertYkfAndPush(ApisBusiMxClaimRegist regist, List<ApisBusiMxClaimMedia> mediaList, ApisBusiAnalysisTaskLog taskLog) {
        try {
            mediaList = this.claimMediaUploadUtil.asyncUploadMxClaimMedia(regist, mediaList);
            ThirdpClaimRegistClaimMain main = this.convertMain(regist);
            List payees = this.convertYkfPayee(regist);
            List imageDatas = this.convertImageData(mediaList);
            ThirdpClaimRegistBody body = ThirdpClaimRegistBody.builder().claimMain(main).payees(payees).imageDatas(imageDatas).build();
            ThirdpClaimRequestHead head = ThirdpClaimRequestHead.builder().consumerSeqNo(UUID.randomUUID().toString()).consumerID(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_CONSUMER_ID")).transactionDate(new Date()).build();
            ThirdpClaimRequest thirdpClaimRequest = ThirdpClaimRequest.builder().head(head).body(body).build();
            this.pushThirdpClaimRegist(thirdpClaimRequest, taskLog);
        }
        catch (ApisBusinessException e) {
            log.error("\u836f\u5eb7\u4ed8-\u7406\u8d54\u62a5\u6848\u4fe1\u606f\u4e0a\u4f20\u788e\u7ba1\u5f02\u5e38\uff0cclaimApplyId:{}", (Object)regist.getClaimApplyId(), (Object)e);
            taskLog.setPushStatus("4");
            taskLog.setErrMsg(e.getMessage());
            this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
        }
        catch (Exception e) {
            log.error("\u836f\u5eb7\u4ed8-\u7406\u8d54\u62a5\u6848\u4fe1\u606f\u4e0a\u4f20\u788e\u7ba1\u5f02\u5e38\uff0cclaimApplyId:{}", (Object)regist.getClaimApplyId(), (Object)e);
        }
    }

    public void convertYqAndPush(ApisBusiMxClaimRegist regist, ApisBusiAnalysisTaskLog taskLog) {
        try {
            ThirdpClaimRegistClaimMain main = this.convertMain(regist);
            List payees = this.convertYqPayee(regist);
            ThirdpClaimRegistBody body = ThirdpClaimRegistBody.builder().claimMain(main).payees(payees).imageDatas((List)Lists.newArrayList()).build();
            ThirdpClaimRequestHead head = ThirdpClaimRequestHead.builder().consumerSeqNo(UUID.randomUUID().toString()).consumerID(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_CONSUMER_ID")).transactionDate(new Date()).build();
            ThirdpClaimRequest thirdpClaimRequest = ThirdpClaimRequest.builder().head(head).body(body).build();
            this.pushThirdpClaimRegist(thirdpClaimRequest, taskLog);
        }
        catch (Exception e) {
            log.error("\u836f\u4f01-\u7406\u8d54\u62a5\u6848\u4fe1\u606f\u4e0a\u4f20\u788e\u7ba1\u5f02\u5e38:", (Throwable)e);
        }
    }

    private List<ThirdpClaimRegistImageData> convertImageData(List<ApisBusiMxClaimMedia> mediaList) {
        if (ObjectUtils.isEmpty(mediaList)) {
            return null;
        }
        return mediaList.stream().map(media -> {
            ThirdpClaimRegistImageData imageData = new ThirdpClaimRegistImageData();
            imageData.setDataType(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_DATA_TYPE"));
            imageData.setDataUrl(media.getMediaUrl());
            imageData.setDataName(media.getMediaNo() + "." + media.getFileSuffix());
            return imageData;
        }).collect(Collectors.toList());
    }

    private List<ThirdpClaimRegistPayee> convertYkfPayee(ApisBusiMxClaimRegist regist) {
        ArrayList<ThirdpClaimRegistPayee> payees = new ArrayList<ThirdpClaimRegistPayee>();
        ThirdpClaimRegistPayee payee = new ThirdpClaimRegistPayee();
        payee.setCompensateType(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_COMPENSATE_TYPE"));
        payee.setPayeeName(this.apisChannelConfigsService.getConfigValue("MX_YKF_PAYEE_NAME"));
        payee.setPayeeAccount(this.apisChannelConfigsService.getConfigValue("MX_YKF_PAYEE_ACCOUNT"));
        payee.setPayeeAmlType(this.apisChannelConfigsService.getConfigValue("MX_YKF_PAYEE_AML_TYPE"));
        payee.setBankCode(this.apisChannelConfigsService.getConfigValue("MX_YKF_BANK_CODE"));
        payee.setBankName(this.apisChannelConfigsService.getConfigValue("MX_YKF_BANK_NAME"));
        payee.setPaymentMethod(this.apisChannelConfigsService.getConfigValue("MX_YKF_PAYMENT_METHOD"));
        payee.setPaymentType(this.apisChannelConfigsService.getConfigValue("MX_YKF_PAYMENT_TYPE"));
        payee.setClaimAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        payee.setLossAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        if (ObjectUtils.isNotEmpty((Object)regist.getAppClaimAmount()) && regist.getAppClaimAmount().movePointLeft(POINT).compareTo(AnalysisConstants.THIRPD_NEED_FXQ_MAX) > -1) {
            ThirdpClaimRegistPayeeAml payeeAml = this.fillInsuredFxq(regist);
            ArrayList<ThirdpClaimRegistPayeeAml> payeeAmlList = new ArrayList<ThirdpClaimRegistPayeeAml>();
            payeeAmlList.add(payeeAml);
            payee.setPayeeAmlList(payeeAmlList);
            ThirdpClaimRegistPayeeAmlCom payeeAmlCom = this.fillPayeeComFxq();
            ArrayList<ThirdpClaimRegistPayeeAmlCom> payeeAmlComList = new ArrayList<ThirdpClaimRegistPayeeAmlCom>();
            payeeAmlComList.add(payeeAmlCom);
            payee.setPayeeAmlComList(payeeAmlComList);
        }
        payees.add(payee);
        return payees;
    }

    private List<ThirdpClaimRegistPayee> convertYqPayee(ApisBusiMxClaimRegist regist) {
        if (StringUtils.isNotBlank((CharSequence)regist.getPayeeBankAccountName()) && regist.getPayeeBankAccountName().equals(this.apisChannelConfigsService.getConfigValue("PAYEE_AML_TYPE_COMPANY_NAME"))) {
            return this.convertYkfPayee(regist);
        }
        ArrayList<ThirdpClaimRegistPayee> payees = new ArrayList<ThirdpClaimRegistPayee>();
        ThirdpClaimRegistPayee payee = new ThirdpClaimRegistPayee();
        payee.setBankCode(this.apisChannelCodeService.getValueByCode("PRPDBANK", regist.getPayeeBankName()));
        payee.setBankName(regist.getPayeeBankName());
        payee.setPaymentMethod(this.apisChannelConfigsService.getConfigValue("MX_YKF_PAYMENT_METHOD"));
        payee.setPaymentType(this.apisChannelConfigsService.getConfigValue("MX_YKF_PAYMENT_TYPE"));
        payee.setClaimAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        payee.setLossAmount(regist.getAppClaimAmount().movePointLeft(POINT).toString());
        payee.setCompensateType(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_COMPENSATE_TYPE"));
        payee.setPayeeName(regist.getPayeeBankAccountName());
        payee.setPayeeAccount(regist.getAccountNo());
        payee.setPayeeAmlType("1");
        if (ObjectUtils.isNotEmpty((Object)regist.getAppClaimAmount()) && regist.getAppClaimAmount().movePointLeft(POINT).compareTo(AnalysisConstants.THIRPD_NEED_FXQ_MAX) > -1) {
            ArrayList<ThirdpClaimRegistPayeeAml> payeeAmlList = new ArrayList<ThirdpClaimRegistPayeeAml>();
            ThirdpClaimRegistPayeeAml insuredFxq = this.fillInsuredFxq(regist);
            ThirdpClaimRegistPayeeAml payeeFxq = this.fillPayeeFxq(regist);
            payeeAmlList.add(insuredFxq);
            payeeAmlList.add(payeeFxq);
            payee.setPayeeAmlList(payeeAmlList);
        }
        payees.add(payee);
        return payees;
    }

    private ThirdpClaimRegistPayeeAmlCom fillPayeeComFxq() {
        ThirdpClaimRegistPayeeAmlCom payeeAmlCom = new ThirdpClaimRegistPayeeAmlCom();
        payeeAmlCom.setInsureComName(this.apisChannelConfigsService.getConfigValue("MX_YKF_PAYEE_NAME"));
        payeeAmlCom.setInsureIndustry(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_INSURE_INDUSTRY"));
        payeeAmlCom.setRegistCapitalAmount(new BigDecimal(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_REGIST_CAPITAL_AMOUNT")));
        payeeAmlCom.setRegistCapitalCurrency(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_REGIST_CAPITAL_CURRENCY"));
        payeeAmlCom.setInsureComAddress(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_INSURE_COM_ADDRESS"));
        payeeAmlCom.setInsureComBussScope(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_INSURE_COM_BUSS_SCOPE"));
        payeeAmlCom.setInsureComBusinessCode(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_INSURE_COM_BUSINESS_CODE"));
        ArrayList<ThirdpCustomerCertifyInfo> ccustomerCertifyInfo = new ArrayList<ThirdpCustomerCertifyInfo>();
        String certifyOrPersonFlag = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_PERSON_FLAG");
        String personValidDate = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_PERSON_VALID_DATE");
        String certifyType = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_PERSON_CERTIFY_TYPE");
        String certifName = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_PERSON_CERTIF_NAME");
        String certifyNo = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_PERSON_CERTIFY_NO");
        ThirdpCustomerCertifyInfo personInfoLegal = new ThirdpCustomerCertifyInfo();
        personInfoLegal.setCertifyOrPersonFlag(certifyOrPersonFlag);
        String certifyOrPersonTypeLegal = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_PERSON_TYPE_LEGAL");
        personInfoLegal.setCertifyOrPersonType(certifyOrPersonTypeLegal);
        personInfoLegal.setCertifyType(certifyType);
        personInfoLegal.setCertifName(certifName);
        personInfoLegal.setCertifyNo(certifyNo);
        personInfoLegal.setValidDate((Date)DateUtil.parse((CharSequence)personValidDate, (String)"yyyy-MM-dd"));
        ThirdpCustomerCertifyInfo personInfoPrincipal = new ThirdpCustomerCertifyInfo();
        personInfoPrincipal.setCertifyOrPersonFlag(certifyOrPersonFlag);
        String certifyOrPersonTypePrincipal = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_PERSON_TYPE_PRINCIPAL");
        personInfoPrincipal.setCertifyOrPersonType(certifyOrPersonTypePrincipal);
        personInfoPrincipal.setCertifyType(certifyType);
        personInfoPrincipal.setCertifName(certifName);
        personInfoPrincipal.setCertifyNo(certifyNo);
        personInfoPrincipal.setValidDate((Date)DateUtil.parse((CharSequence)personValidDate, (String)"yyyy-MM-dd"));
        ThirdpCustomerCertifyInfo personInfoBusiness = new ThirdpCustomerCertifyInfo();
        personInfoBusiness.setCertifyOrPersonFlag(certifyOrPersonFlag);
        String certifyOrPersonTypeBusiness = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_PERSON_TYPE_BUSINESS");
        personInfoBusiness.setCertifyOrPersonType(certifyOrPersonTypeBusiness);
        personInfoBusiness.setCertifyType(certifyType);
        personInfoBusiness.setCertifName(certifName);
        personInfoBusiness.setCertifyNo(certifyNo);
        personInfoBusiness.setValidDate((Date)DateUtil.parse((CharSequence)personValidDate, (String)"yyyy-MM-dd"));
        ThirdpCustomerCertifyInfo certifyInfo = new ThirdpCustomerCertifyInfo();
        certifyInfo.setCertifyOrPersonFlag(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_COMPANY_FLAG"));
        certifyInfo.setCertifyOrPersonType(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_COMPANY_TYPE"));
        certifyInfo.setCertifyType(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_COMPANY_CERTIFY_TYPE"));
        certifyInfo.setCertifName(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_COMPANY_CERTIF_NAME"));
        certifyInfo.setCertifyNo(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_COMPANY_CERTIFY_NO"));
        String validDate = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_COMPANY_VALID_DATE");
        certifyInfo.setValidDate((Date)DateUtil.parse((CharSequence)validDate, (String)"yyyy-MM-dd"));
        ccustomerCertifyInfo.add(personInfoLegal);
        ccustomerCertifyInfo.add(personInfoPrincipal);
        ccustomerCertifyInfo.add(personInfoBusiness);
        ccustomerCertifyInfo.add(certifyInfo);
        payeeAmlCom.setCcustomerCertifyInfo(ccustomerCertifyInfo);
        ArrayList<ThirdpCustomerBeneficiaryInfo> ccustomerBeneficiaryInfo = new ArrayList<ThirdpCustomerBeneficiaryInfo>();
        ThirdpCustomerBeneficiaryInfo beneficiaryInfo = new ThirdpCustomerBeneficiaryInfo();
        beneficiaryInfo.setBeneficiaryName(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_BENEFICIARY_NAME"));
        beneficiaryInfo.setBeneficiaryNationality(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_BENEFICIARY_NATIONALITY"));
        beneficiaryInfo.setBeneficiaryOccupation(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_BENEFICIARY_OCCUPATION"));
        beneficiaryInfo.setBeneficiaryAddressType(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_BENEFICIARY_ADDRESS_TYPE"));
        beneficiaryInfo.setBeneficiaryAddress(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_BENEFICIARY_ADDRESS"));
        beneficiaryInfo.setBeneficiaryCertifyType(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_BBENEFICIARY_CERTIFY_TYPE"));
        beneficiaryInfo.setBeneficiaryCertifyNo(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_BENEFICIARY_CERTIFY_NO"));
        String beneficiaryCertifyValidDate = this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_BENEFICIARY_CERTIFY_VALID_DATE");
        beneficiaryInfo.setBeneficiaryCertifyValidDate((Date)DateUtil.parse((CharSequence)beneficiaryCertifyValidDate, (String)"yyyy-MM-dd"));
        beneficiaryInfo.setInsuredRelationCode(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_INSURED_RELATION_CODE"));
        beneficiaryInfo.setInsuredRelationName(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_INSURED_RELATION_NAME"));
        beneficiaryInfo.setInsuredRelationDetail(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_INSURED_RELATION_DETAIL"));
        beneficiaryInfo.setPayeeRelationCode(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_RELATION_CODE"));
        beneficiaryInfo.setPayeeRelationName(this.apisChannelConfigsService.getConfigValue("MX_YKF_COM_PAYEE_RELATION_NAME"));
        ccustomerBeneficiaryInfo.add(beneficiaryInfo);
        payeeAmlCom.setCcustomerBeneficiaryInfo(ccustomerBeneficiaryInfo);
        return payeeAmlCom;
    }

    private ThirdpClaimRegistPayeeAml fillInsuredFxq(ApisBusiMxClaimRegist regist) {
        ThirdpClaimRegistPayeeAml payeeAml = new ThirdpClaimRegistPayeeAml();
        Map insured = null;
        if ("YKF".equals(regist.getProjectCode())) {
            insured = this.apisBusiMxAddInsuredVoucherService.getInsuredInfo(regist.getContractNo(), regist.getMxPolicyNo(), regist.getOrderNo());
        } else if ("YQ".equals(regist.getProjectCode())) {
            insured = this.apisBusiMxAddInsuredVoucherService.getInsuredInfoToYq(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo());
        }
        log.warn("\u53cd\u6d17\u94b1-\u88ab\u4fdd\u4eba\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(insured));
        if (ObjectUtils.isNotEmpty((Object)insured)) {
            payeeAml.setInsuredName((String)insured.get("insured_name"));
            String sex = this.getSexElseDefault((String)insured.get("gender"), (String)insured.get("credential_no"));
            payeeAml.setInsuredSex(sex);
            String insuredCertifyType = this.getCodeValueElseDefault((String)insured.get("credential_type"), "mxClaimThirdpPayeeAmlCertifyType", "THIRDP_INSURED_FXQ_CERTIFY_TYPE");
            payeeAml.setInsuredCertifyType(insuredCertifyType);
            payeeAml.setInsuredCertifyNo((String)insured.get("credential_no"));
            payeeAml.setInsuredMobile(regist.getReportPhone());
        }
        payeeAml.setInsuredNationality(this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_INSURED_NATIONALITY"));
        payeeAml.setInsuredOccupation(this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_INSURED_OCCUPATION"));
        payeeAml.setInsuredAddressType(this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_INSURED_ADDRESS_TYPE"));
        payeeAml.setInsuredAddress(this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_INSURED_ADDRESS"));
        String insuredCertifyValidDate = this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_CERTIFY_VALID_DATE");
        payeeAml.setInsuredCertifyValidDate((Date)DateUtil.parse((CharSequence)insuredCertifyValidDate, (String)"yyyy-MM-dd"));
        payeeAml.setInsuredRelationCode(this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_INSURED_RELATION_CODE"));
        payeeAml.setInsuredRelationName(this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_INSURED_RELATION_NAME"));
        payeeAml.setInsuredRelationDetail(this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_INSURED_RELATION_DETAIL"));
        payeeAml.setPayeeRelationCode(this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_PAYEE_RELATION_CODE"));
        payeeAml.setPayeeRelationName(this.apisChannelConfigsService.getConfigValue("THIRDP_INSURED_FXQ_PAYEE_RELATION_NAME"));
        return payeeAml;
    }

    private ThirdpClaimRegistPayeeAml fillPayeeFxq(ApisBusiMxClaimRegist regist) {
        ThirdpClaimRegistPayeeAml payeeAml = new ThirdpClaimRegistPayeeAml();
        Map insured = null;
        if ("YKF".equals(regist.getProjectCode())) {
            insured = this.apisBusiMxAddInsuredVoucherService.getInsuredInfo(regist.getContractNo(), regist.getMxPolicyNo(), regist.getOrderNo());
        } else if ("YQ".equals(regist.getProjectCode())) {
            insured = this.apisBusiMxAddInsuredVoucherService.getInsuredInfoToYq(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo());
        }
        log.warn("\u53cd\u6d17\u94b1-\u9886\u6b3e\u4eba\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(insured));
        if (ObjectUtils.isNotEmpty((Object)insured)) {
            String sex = this.getSexElseDefault((String)insured.get("gender"), regist.getInsuredIdNo());
            payeeAml.setInsuredSex(sex);
        }
        payeeAml.setInsuredName(regist.getInsuredName());
        payeeAml.setInsuredNationality(this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_NATIONALITY"));
        payeeAml.setInsuredOccupation(this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_OCCUPATION"));
        payeeAml.setInsuredAddressType(this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_ADDRESS_TYPE"));
        payeeAml.setInsuredAddress(this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_ADDRESS"));
        payeeAml.setInsuredMobile(regist.getReportPhone());
        ApisChannelCode channelCode = this.apisChannelCodeService.getByChannelValue("mxClaimThirdpPayeeAmlCertifyType", regist.getInsuredIdType());
        payeeAml.setInsuredCertifyType(ObjectUtils.isNotEmpty((Object)channelCode) ? channelCode.getValue() : "");
        payeeAml.setInsuredCertifyNo(regist.getInsuredIdNo());
        String insuredCertifyValidDate = this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_CERTIFY_VALID_DATE");
        payeeAml.setInsuredCertifyValidDate((Date)DateUtil.parse((CharSequence)insuredCertifyValidDate, (String)"yyyy-MM-dd"));
        payeeAml.setInsuredRelationCode(this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_RELATION_CODE"));
        payeeAml.setInsuredRelationName(this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_RELATION_NAME"));
        payeeAml.setInsuredRelationDetail(this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_RELATION_DETAIL"));
        payeeAml.setPayeeRelationCode(this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_PAYEE_RELATION_CODE"));
        payeeAml.setPayeeRelationName(this.apisChannelConfigsService.getConfigValue("THIRDP_PAYEE_AML_FXQ_PAYEE_RELATION_NAME"));
        return payeeAml;
    }

    private String getSexElseDefault(String sexValue, String insuredIdNo) {
        if (StringUtils.isNotBlank((CharSequence)sexValue)) {
            ApisChannelCode genderCode = this.apisChannelCodeService.getByChannelValue("mxClaimThirdpPayeeAmlSex", sexValue);
            if (ObjectUtils.isNotEmpty((Object)genderCode)) {
                return genderCode.getValue();
            }
            return this.getSexByCardNo(insuredIdNo);
        }
        return this.getSexByCardNo(insuredIdNo);
    }

    private String getSexByCardNo(String cardNo) {
        int baseNum = 2;
        String sex = StringUtils.isNotBlank((CharSequence)cardNo) ? (Integer.parseInt(cardNo.substring(cardNo.length() - baseNum, cardNo.length() - 1)) % baseNum == 0 ? "2" : "1") : "9";
        return sex;
    }

    private String getCodeValueElseDefault(String channelValue, String code, String defaultConfigCode) {
        if (StringUtils.isNotBlank((CharSequence)channelValue)) {
            ApisChannelCode genderCode = this.apisChannelCodeService.getByChannelValue(code, channelValue);
            if (ObjectUtils.isNotEmpty((Object)genderCode)) {
                return genderCode.getValue();
            }
            return this.apisChannelConfigsService.getConfigValue(defaultConfigCode);
        }
        return this.apisChannelConfigsService.getConfigValue(defaultConfigCode);
    }

    private ThirdpClaimRegistClaimMain convertMain(ApisBusiMxClaimRegist regist) throws ApisBusinessException {
        if (ObjectUtils.isEmpty((Object)regist)) {
            throw new ApisBusinessException("\u4e0a\u4f20\u788e\u7ba1\u7406\u8d54\u62a5\u6848\u5bf9\u5e94\u7684\u7acb\u6848\u4fe1\u606f\u4e3a\u7a7a", ErrorBisCodeEnum.ERR_B00002.getKey());
        }
        ThirdpClaimRegistClaimMain main = new ThirdpClaimRegistClaimMain();
        main.setClaimApplyId(regist.getClaimApplyId());
        main.setRequestType(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_REQUEST_TYPE"));
        main.setChannelOrder(regist.getOrderNo());
        main.setChannelPolicyNo(regist.getMxPolicyNo());
        main.setProposalOrder(regist.getPk());
        main.setApplyClaimAmount(regist.getAppClaimAmount().movePointLeft(POINT));
        main.setClaimTime(Date.from(regist.getReportTime().atZone(ZoneId.systemDefault()).toInstant()));
        main.setRegistTime(Date.from(regist.getReportTime().atZone(ZoneId.systemDefault()).toInstant()));
        main.setRegistType(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_REGIST_TYPE"));
        main.setRegistRemark(regist.getContext());
        main.setDamageTime(Date.from(regist.getDamageTime().atZone(ZoneId.systemDefault()).toInstant()));
        main.setDamageAddress(regist.getAccidentAddress());
        main.setLossType(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_LOSS_TYPE"));
        main.setLossAmount(regist.getAppClaimAmount().movePointLeft(POINT));
        main.setCaseDescription(regist.getCaseDetils());
        main.setAuditStatus(this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_AUDIT_STATUS"));
        main.setClaimAmount(regist.getAppClaimAmount().movePointLeft(POINT));
        main.setChannelClaimApplyTime(Date.from(regist.getReportTime().atZone(ZoneId.systemDefault()).toInstant()));
        main.setChannelClaimCreateTime(regist.getCreateTime());
        if ("YKF".equals(regist.getProjectCode())) {
            Map insuredNameAndPhone;
            String mxProductCode = this.apisBusiMxAddInsuredVoucherService.getMxProductCodeByOrderNo(regist.getOrderNo(), "YKF");
            main.setChannelCode(this.channelUserConfigUtil.getChannelCode(mxProductCode));
            LocalDateTime policyEffectiveTime = this.apisBusiMxAddInsuredVoucherService.getPolicyEffectiveTime(regist.getContractNo(), regist.getMxPolicyNo(), regist.getOrderNo());
            if (ObjectUtils.isNotEmpty((Object)policyEffectiveTime)) {
                main.setPolicyEffectiveTime(Date.from(policyEffectiveTime.atZone(ZoneId.systemDefault()).toInstant()));
            }
            main.setRegistName(ObjectUtils.isNotEmpty((Object)(insuredNameAndPhone = this.apisBusiMxAddInsuredVoucherService.getInsuredInfo(regist.getContractNo(), regist.getMxPolicyNo(), regist.getOrderNo()))) ? (String)insuredNameAndPhone.get("insured_name") : "");
            main.setRegistPhone(regist.getReportPhone());
        } else if ("YQ".equals(regist.getProjectCode())) {
            main.setChannelCode(this.channelUserConfigUtil.getYqChannelCode(regist.getContractNo()));
            LocalDateTime policyEffectiveTime = this.apisBusiMxAddInsuredVoucherService.getPolicyEffectiveTimeToYq(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo());
            if (ObjectUtils.isNotEmpty((Object)policyEffectiveTime)) {
                main.setPolicyEffectiveTime(Date.from(policyEffectiveTime.atZone(ZoneId.systemDefault()).toInstant()));
            }
            main.setRegistName(regist.getReportName());
            main.setRegistPhone(regist.getReportPhone());
        }
        return main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ApisBusiAnalysisTaskLog pushThirdpClaimRegist(ThirdpClaimRequest thirdpClaimRequest, ApisBusiAnalysisTaskLog taskLog) {
        try {
            if (StringUtils.isBlank((CharSequence)this.thirdpClaimRegistUrl)) {
                if (ObjectUtil.isNotEmpty((Object)taskLog)) {
                    taskLog.setPushStatus("5");
                    taskLog.setErrMsg("\u672a\u914d\u7f6e\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001url");
                    this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
                }
                ApisBusiAnalysisTaskLog apisBusiAnalysisTaskLog = taskLog;
                return apisBusiAnalysisTaskLog;
            }
            if (ObjectUtil.isEmpty((Object)taskLog)) {
                taskLog = new ApisBusiAnalysisTaskLog();
                taskLog.setPushType(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getValue());
                taskLog.setBusinessKey(thirdpClaimRequest.getBody().getClaimMain().getClaimApplyId());
                taskLog.setPushStep(Integer.valueOf(1));
            } else {
                taskLog.setPushStep(Integer.valueOf(taskLog.getPushStep() + 1));
            }
            taskLog.setPushStatus("2");
            taskLog.setLastPushTime(LocalDateTime.now());
            taskLog.setPushTargetUrl(this.thirdpClaimRegistUrl);
            taskLog.setPushContent(JSON.toJSONString((Object)thirdpClaimRequest));
            log.warn("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001request\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)thirdpClaimRequest));
            ThirdpClaimResponse response = (ThirdpClaimResponse)this.httpRequestService.convertAndSendForAgent(this.thirdpClaimRegistUrl, (Object)thirdpClaimRequest, ThirdpClaimResponse.class, ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getValue());
            log.warn("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001response\u62a5\u6587\uff1a{}", (Object)JSON.toJSONString((Object)response));
            if (ObjectUtils.isEmpty((Object)response) || ObjectUtils.isEmpty((Object)response.getHead()) || ObjectUtils.isEmpty((Object)response.getHead().getStatus())) {
                taskLog.setPushStatus("4");
                taskLog.setErrMsg("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001\u672a\u8fd4\u56de\u5185\u5bb9");
            } else {
                if (AnalysisConstants.THIRDP_CLAIM_RESPONSE_STATUS.SUCCESS.equals(response.getHead().getStatus())) {
                    taskLog.setPushStatus("1");
                } else if (AnalysisConstants.THIRDP_CLAIM_RESPONSE_ERR_TYPE.REJECT.equals(response.getHead().getErrType())) {
                    taskLog.setPushStatus("1");
                    this.pushEndCaaseToMx(thirdpClaimRequest);
                } else {
                    taskLog.setPushStatus("4");
                }
                taskLog.setErrMsg(JSON.toJSONString((Object)response));
            }
        }
        catch (Exception e) {
            log.error("\u788e\u7ba1\u7406\u8d54\u7acb\u6848\u63a8\u9001\u5931\u8d25 error:", (Throwable)e);
            taskLog.setPushStatus("4");
            if (StringUtils.isNotBlank((CharSequence)e.getMessage()) && e.getMessage().length() > ModelConstants.PUSH_ERR_MSG_LIMIT) {
                taskLog.setErrMsg(e.getMessage().substring(0, ModelConstants.PUSH_ERR_MSG_LIMIT));
            } else {
                taskLog.setErrMsg(e.getMessage());
            }
        }
        finally {
            if (ObjectUtils.isEmpty((Object)taskLog.getId())) {
                this.apisBusiAnalysisTaskLogService.saveTaskInfo(taskLog);
            } else {
                this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
            }
        }
        return taskLog;
    }

    public void pushThirdpClaimRegistTask(ApisBusiAnalysisTaskLog taskLog) {
        if (ObjectUtil.isEmpty((Object)taskLog)) {
            log.error("\u63a8\u9001\u4efb\u52a1\u4e3a\u7a7a");
            return;
        }
        if ("0".equals(taskLog.getPushStatus())) {
            if (StringUtils.isBlank((CharSequence)taskLog.getBusinessKey())) {
                log.error("\u63a8\u9001\u4e1a\u52a1\u952ebusinessKey\u4e3a\u7a7a");
                return;
            }
            ApisBusiMxClaimRegist regist = this.apisBusiMxClaimRegistService.getByClaimApplyId(taskLog.getBusinessKey());
            List mediaList = this.apisBusiMxClaimMediaService.getByMxReportNo(regist.getMxReportNo());
            if ("YKF".equals(regist.getProjectCode())) {
                this.convertYkfAndPush(regist, mediaList, taskLog);
            } else if ("YQ".equals(regist.getProjectCode())) {
                this.convertYqAndPush(regist, taskLog);
            }
        } else {
            ThirdpClaimRequest thirdpClaimRequest;
            if (ObjectUtil.isEmpty((Object)taskLog.getPushContent())) {
                log.error("\u4efb\u52a1businessKey={}, \u6ca1\u6709\u8981\u63a8\u9001\u7684\u8bf7\u6c42\u4fe1\u606f", (Object)taskLog.getBusinessKey());
                return;
            }
            try {
                thirdpClaimRequest = (ThirdpClaimRequest)JSON.parseObject((String)taskLog.getPushContent(), ThirdpClaimRequest.class);
            }
            catch (Exception e) {
                log.error("\u63a8\u9001\u65e5\u5fd7\u63a8\u9001\u5185\u5bb9\u5e8f\u5217\u5316\u5931\u8d25,", (Throwable)e);
                return;
            }
            if ("3".equals(taskLog.getRemark())) {
                this.pushEndCaaseToMx(thirdpClaimRequest);
                taskLog.setPushStatus("4");
                this.apisBusiAnalysisTaskLogService.updateById((Object)taskLog);
            } else {
                ApisBusiAnalysisTaskLog apisBusiAnalysisTaskLog = this.pushThirdpClaimRegist(thirdpClaimRequest, taskLog);
            }
        }
    }

    public void pushEndCaaseToMx(ThirdpClaimRequest thirdpClaimRequest) {
        String claimApplyId = thirdpClaimRequest.getBody().getClaimMain().getClaimApplyId();
        ApisBusiMxClaimRegist regist = this.apisBusiMxClaimRegistService.getByClaimApplyId(claimApplyId);
        if ("YKF".equals(regist.getProjectCode())) {
            MxYkfClaimEndCaseRequest endCaseRequest = new MxYkfClaimEndCaseRequest();
            endCaseRequest.setContractNo(regist.getContractNo());
            endCaseRequest.setPaymentAmount(Integer.valueOf(0));
            ArrayList<MxYkfClaimEndCaseClaim> claimList = new ArrayList<MxYkfClaimEndCaseClaim>();
            MxYkfClaimEndCaseClaim claim = (MxYkfClaimEndCaseClaim)BeanUtil.copyProperties((Object)regist, MxYkfClaimEndCaseClaim.class, (String[])new String[0]);
            claim.setClaimType(AnalysisConstants.MX_YKF_CLAIM_TYPE.REJECT);
            claimList.add(claim);
            endCaseRequest.setClaimList(claimList);
            this.mxClaimEndCasePushService.pushYkfClaimEndCase(endCaseRequest, regist.getClaimApplyId(), null);
        } else if ("YQ".equals(regist.getProjectCode())) {
            MxYqClaimEndCaseRequest endCaseRequest = (MxYqClaimEndCaseRequest)BeanUtil.copyProperties((Object)regist, MxYqClaimEndCaseRequest.class, (String[])new String[0]);
            endCaseRequest.setReportNo(regist.getRegistNo());
            endCaseRequest.setClaimStatus(AnalysisConstants.MX_YQ_CLAIM_STATUS.REJECT);
            endCaseRequest.setPaymentInfo(new MxYqClaimEndCasePaymentInfo());
            endCaseRequest.setProjectCode(this.channelUserConfigUtil.getClaimProjectCodeByContractNo(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo()));
            endCaseRequest.setContractNo(regist.getContractNo());
            this.mxClaimEndCasePushService.pushYqClaimEndCase(endCaseRequest, regist.getClaimApplyId(), regist, null);
        }
    }

    public Boolean compensateThirdpClaimRegistTask() {
        List registList = this.apisBusiMxClaimRegistService.listDiffNotPushTrirdp();
        if (ObjectUtils.isEmpty((Object)registList)) {
            log.warn("\u6ca1\u6709\u7acb\u6848\u4fdd\u5b58\u6210\u529f\u4f46\u662f\u6ca1\u6709\u63a8\u9001\u788e\u7ba1\u7684\u6570\u636e");
            return true;
        }
        ArrayList<ApisBusiAnalysisTaskLog> taskLogs = new ArrayList<ApisBusiAnalysisTaskLog>();
        for (ApisBusiMxClaimRegist regist : registList) {
            ApisBusiAnalysisTaskLog taskLog = new ApisBusiAnalysisTaskLog();
            taskLog.setPushType(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getValue());
            taskLog.setBusinessKey(regist.getClaimApplyId());
            taskLog.setPushStatus("0");
            taskLog.setPushStep(Integer.valueOf(0));
            taskLogs.add(taskLog);
        }
        return this.apisBusiAnalysisTaskLogService.saveBatch(taskLogs);
    }
}

