/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxAddInsuredVoucher;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChannelUserConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(ChannelUserConfigUtil.class);
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiMxAddInsuredVoucherService apisBusiMxAddInsuredVoucherService;

    public String getChannelCode(String productCode) {
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode("MX_REQUEST_RISK_AGENCY");
        apisChannelConfigsCondition.setRationCode(productCode);
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            return apisChannelConfigs.getChannelCode();
        }
        log.warn("\u7ec4\u7ec7\u9541\u4fe1\u83b7\u53d6\u4e0d\u5230\u8d26\u53f7\u914d\u7f6e");
        return null;
    }

    public String getChannelName() {
        return this.apisChannelConfigsService.getConfigValue("MX_THIRDP_CLAIM_REGIST_CHANNEL_NAME");
    }

    public String getUserCode(String productCode) {
        ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
        apisChannelConfigsCondition.setConfigCode("MX_REQUEST_RISK_AGENCY");
        apisChannelConfigsCondition.setRationCode(productCode);
        ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            return apisChannelConfigs.getUserCode();
        }
        log.warn("\u7ec4\u7ec7\u9541\u4fe1\u83b7\u53d6\u4e0d\u5230\u8d26\u53f7\u914d\u7f6e");
        return null;
    }

    public ApisChannelConfigs getYqRequestUserByContractNo(String contractNo) {
        QueryWrapper apisChannelConfigsCondition = new QueryWrapper();
        apisChannelConfigsCondition.eq((Object)"config_code", (Object)"MX_YQ_REQUEST_RISK_AGENCY");
        apisChannelConfigsCondition.eq((Object)"config_value", (Object)contractNo);
        List apisChannelConfigList = this.apisChannelConfigsService.list((Wrapper)apisChannelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigList)) {
            return (ApisChannelConfigs)apisChannelConfigList.get(0);
        }
        return null;
    }

    public String getYqChannelCode(String contractNo) {
        ApisChannelConfigs configs = this.getYqRequestUserByContractNo(contractNo);
        if (ObjectUtil.isNotEmpty((Object)configs)) {
            return configs.getChannelCode();
        }
        log.warn("\u7ec4\u7ec7\u9541\u4fe1\u83b7\u53d6\u4e0d\u5230\u836f\u4f01\u6e20\u9053\u53f7\u914d\u7f6e");
        return null;
    }

    public String getYqCallbackUrlByContractNo(String contractNo, String policyNo, String mxPolicyNo) {
        List apisChannelConfigList;
        String mxProductCode = this.getYqProductCodeByInsureInfo(contractNo, policyNo, mxPolicyNo);
        QueryWrapper apisChannelConfigsCondition = new QueryWrapper();
        apisChannelConfigsCondition.eq((Object)"config_code", (Object)"YQ_GET_CALLBACK_URL_BY_CONT_NO");
        apisChannelConfigsCondition.eq((Object)"ration_code", (Object)contractNo);
        apisChannelConfigsCondition.eq((Object)"deleted", (Object)0);
        if (StrUtil.isNotBlank((CharSequence)mxProductCode)) {
            apisChannelConfigsCondition.eq((Object)"value_type", (Object)mxProductCode);
        }
        if (ObjectUtil.isNotEmpty((Object)(apisChannelConfigList = this.apisChannelConfigsService.list((Wrapper)apisChannelConfigsCondition)))) {
            return ((ApisChannelConfigs)apisChannelConfigList.get(0)).getConfigValue();
        }
        return null;
    }

    public String getYqProductCodeByInsureInfo(String contractNo, String policyNo, String mxPolicyNo) {
        ApisBusiMxAddInsuredVoucher apisBusiMxAddInsuredVoucher;
        String mxProductCode = null;
        if (StrUtil.isNotBlank((CharSequence)contractNo) && ObjectUtil.isNotEmpty((Object)(apisBusiMxAddInsuredVoucher = this.apisBusiMxAddInsuredVoucherService.getToCheckClaimRegistYq(contractNo, policyNo, mxPolicyNo)))) {
            mxProductCode = apisBusiMxAddInsuredVoucher.getProductCode();
        }
        return mxProductCode;
    }

    public String getClaimProjectCodeByContractNo(String contractNo, String policyNo, String mxPolicyNo) {
        List apisChannelConfigList;
        String mxProductCode = this.getYqProductCodeByInsureInfo(contractNo, policyNo, mxPolicyNo);
        QueryWrapper apisChannelConfigsCondition = new QueryWrapper();
        apisChannelConfigsCondition.eq((Object)"config_code", (Object)"YQ_GET_CALLBACK_URL_BY_CONT_NO");
        apisChannelConfigsCondition.eq((Object)"ration_code", (Object)contractNo);
        apisChannelConfigsCondition.eq((Object)"deleted", (Object)0);
        if (StrUtil.isNotBlank((CharSequence)mxProductCode)) {
            apisChannelConfigsCondition.eq((Object)"value_type", (Object)mxProductCode);
        }
        if (ObjectUtil.isNotEmpty((Object)(apisChannelConfigList = this.apisChannelConfigsService.list((Wrapper)apisChannelConfigsCondition)))) {
            return ((ApisChannelConfigs)apisChannelConfigList.get(0)).getChannelCode();
        }
        return null;
    }

    public ApisChannelConfigs getNewYkfFlagConfig(String mxProductCode, String valueType) {
        QueryWrapper apisChannelConfigsCondition = new QueryWrapper();
        apisChannelConfigsCondition.eq((Object)"config_code", (Object)"MX_NEW_YKF_FLAG_CONFIG");
        if (StrUtil.isNotBlank((CharSequence)mxProductCode)) {
            apisChannelConfigsCondition.eq((Object)"config_value", (Object)mxProductCode);
        }
        apisChannelConfigsCondition.eq((Object)"value_type", (Object)valueType);
        apisChannelConfigsCondition.eq((Object)"deleted", (Object)0);
        List apisChannelConfigList = this.apisChannelConfigsService.list((Wrapper)apisChannelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigList)) {
            return (ApisChannelConfigs)apisChannelConfigList.get(0);
        }
        return null;
    }

    public boolean isNewYkfOfCategory1(String orderNo) {
        String mxProductCode = this.apisBusiMxAddInsuredVoucherService.getMxProductCodeByOrderNo(orderNo, "YKF");
        ApisChannelConfigs apisChannelConfigs = this.getNewYkfFlagConfig(mxProductCode, "1");
        return ObjectUtil.isNotEmpty((Object)apisChannelConfigs);
    }

    public String getNewYkfFlagConfig() {
        ApisChannelConfigs apisChannelConfigs = this.getNewYkfFlagConfig(null, "1");
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs)) {
            return apisChannelConfigs.getConfigValue();
        }
        return null;
    }

    public String getNewYkfUserCode(String productCode) {
        QueryWrapper apisChannelConfigsCondition = new QueryWrapper();
        apisChannelConfigsCondition.eq((Object)"config_code", (Object)"MX_REQUEST_RISK_AGENCY");
        apisChannelConfigsCondition.eq((Object)"ration_code", (Object)productCode);
        apisChannelConfigsCondition.eq((Object)"deleted", (Object)0);
        List apisChannelConfigsList = this.apisChannelConfigsService.list((Wrapper)apisChannelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigsList)) {
            return ((ApisChannelConfigs)apisChannelConfigsList.get(0)).getUserCode();
        }
        return null;
    }
}

