/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.util;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.ChannelUserConfigUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.OkHttpUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMediaTemp;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMediaService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMediaTempService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ClaimMediaCommitResult;
import com.jdaz.sinosoftgz.apis.commons.model.api.claim.request.ImgNode;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.ImgBatchUploadServiceResponse;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiReqmsgLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiProperties;
import com.jdaz.sinosoftgz.coreapi.common.configs.CoreApiServProperties;
import com.jdaz.sinosoftgz.coreapi.h5img.MediaUploadApi;
import com.sinosoft.image.client.dto.ImgBatchUploadMetaDTO;
import com.sinosoft.image.client.dto.ImgBatchUploadRequestDTO;
import com.sinosoft.image.client.dto.ImgBusiDTO;
import com.sinosoft.image.client.dto.RequestHeadDTO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClaimMediaUploadUtil {
    private static final Logger log = LoggerFactory.getLogger(ClaimMediaUploadUtil.class);
    private static final String SER_PROPERTIES_BATCH_UPLOAD_FILE = "batchUploadFile";
    private static final String API_CODE = "imgBatchUpload";
    private static final String LOG_TYPE = "2";
    @Autowired
    CoreApiProperties coreApiProperties;
    @Autowired
    MediaUploadApi mediaUploadApi;
    @Autowired
    ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Autowired
    ChannelUserConfigUtil channelUserConfigUtil;
    @Autowired
    ApisBusiMxClaimRegistService apisBusiMxClaimRegistService;
    @Autowired
    ApisBusiMxClaimMediaService apisBusiMxClaimMediaService;
    @Autowired
    ApisBusiMxClaimMediaTempService apisBusiMxClaimMediaTempService;
    @Autowired
    ApisBusiMxAddInsuredVoucherService apisBusiMxAddInsuredVoucherService;

    public List<ApisBusiMxClaimMedia> asyncUploadMxClaimMedia(ApisBusiMxClaimRegist regist, List<ApisBusiMxClaimMedia> mediaList) throws ApisBusinessException {
        if (ObjectUtils.isEmpty(mediaList)) {
            return null;
        }
        try {
            for (ApisBusiMxClaimMedia media : mediaList) {
                log.warn("\u9541\u4fe1\u4e0a\u4f20\u5f71\u50cf\u7cfb\u7edf\u5f00\u59cb:{}", (Object)media);
                ImgBatchUploadRequestDTO imgBatchUploadRequestDTO = new ImgBatchUploadRequestDTO();
                RequestHeadDTO requestHeadDTO = new RequestHeadDTO();
                requestHeadDTO.setSeqNo(UUID.randomUUID().toString().replace("-", ""));
                requestHeadDTO.setRequestTime(new Date());
                requestHeadDTO.setOptComCode("apis");
                String mxProductCode = this.apisBusiMxAddInsuredVoucherService.getMxProductCodeByOrderNo(regist.getOrderNo(), "YKF");
                requestHeadDTO.setOptUserCode(this.channelUserConfigUtil.getUserCode(mxProductCode));
                requestHeadDTO.setOptUserName("apis");
                imgBatchUploadRequestDTO.setHeadDto(requestHeadDTO);
                ImgBusiDTO imgBusiDTO = new ImgBusiDTO();
                imgBusiDTO.setAppCode("CL");
                imgBusiDTO.setClassCode("CLA");
                imgBusiDTO.setBusinessNo(regist.getClaimApplyId());
                imgBusiDTO.setBusiComCode("apis");
                imgBatchUploadRequestDTO.setBusiDto(imgBusiDTO);
                String base64Str = OkHttpUtils.getBase64EncodeByUrl((String)media.getMediaUrl());
                log.warn("\u9541\u4fe1\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\uff0c\u6587\u4ef6\u7f16\u53f7: {}", (Object)media.getMediaNo());
                if (StringUtils.isEmpty((CharSequence)base64Str)) {
                    log.error("\u9541\u4fe1\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,\u6587\u4ef6\u7f16\u53f7: {}", (Object)media.getMediaNo());
                    log.error("\u9541\u4fe1\u7406\u8d54\u4e0b\u8f7d\u6587\u4ef6\u5931\u8d25,url: {}", (Object)media.getMediaUrl());
                    continue;
                }
                ImgBatchUploadMetaDTO imgBatchUploadMetaDTO = new ImgBatchUploadMetaDTO();
                imgBatchUploadMetaDTO.setBase64FileContent(base64Str);
                imgBatchUploadMetaDTO.setFileURL(media.getMediaUrl());
                imgBatchUploadMetaDTO.setCovered(false);
                imgBatchUploadMetaDTO.setFileOrgName(media.getMediaNo() + "." + media.getFileSuffix());
                imgBatchUploadMetaDTO.setImgType("|999|");
                imgBatchUploadMetaDTO.setImgTypeName("|\u5176\u4ed6|");
                ArrayList<ImgBatchUploadMetaDTO> uploadMetaDTOList = new ArrayList<ImgBatchUploadMetaDTO>();
                uploadMetaDTOList.add(imgBatchUploadMetaDTO);
                imgBatchUploadRequestDTO.setUploadMetas(uploadMetaDTOList);
                ClaimMediaCommitResult claimMediaCommitResult = this.imgBatchUpload(imgBatchUploadRequestDTO);
                if (!ObjectUtils.isNotEmpty((Object)claimMediaCommitResult.getImgNodes())) continue;
                media.setMediaUrl(((ImgNode)claimMediaCommitResult.getImgNodes().get(0)).getImgUrl());
                media.setImageId(((ImgNode)claimMediaCommitResult.getImgNodes().get(0)).getImgId());
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1\u7406\u8d54\u4e0a\u4f20\u8d44\u6599\u5931\u8d25\uff0c", (Throwable)e);
            throw new ApisBusinessException(AnalysisErrorCodeEnum.ERR_B110002.getValue(), AnalysisErrorCodeEnum.ERR_B110002.getKey());
        }
        return mediaList;
    }

    public ClaimMediaCommitResult imgBatchUpload(ImgBatchUploadRequestDTO dto) throws ApisBusinessException {
        CoreApiServProperties properties = this.coreApiProperties.getServProperties(SER_PROPERTIES_BATCH_UPLOAD_FILE).orElse(null);
        if (ObjectUtils.isEmpty((Object)properties)) {
            throw new ApisBusinessException("\u5f71\u50cf\u4e0a\u4f20\u672a\u914d\u7f6e\u63a5\u53e3\u4fe1\u606f", ErrorBisCodeEnum.ERR_B00002.getKey());
        }
        dto.getHeadDto().setConsumerID(properties.getUser());
        dto.getHeadDto().setConsumerPWD(properties.getUserPwd());
        ClaimMediaCommitResult responseDTO = this.mediaUploadApi.batchUpload(properties.getUrl(), dto, null);
        if (ObjectUtil.isEmpty((Object)responseDTO) || ObjectUtil.isEmpty((Object)responseDTO.getHeadDto())) {
            throw new ApisBusinessException(ErrorBisCodeEnum.ERR_B80002.getValue(), ErrorBisCodeEnum.ERR_B80002.getKey());
        }
        if (responseDTO.getHeadDto().getStatus() < 0) {
            throw new ApisBusinessException("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u5931\u8d25\uff1a" + responseDTO.getHeadDto().getErrorMessage(), responseDTO.getHeadDto().getErrorCode());
        }
        ImgBatchUploadServiceResponse imgBatchUploadResponse = ImgBatchUploadServiceResponse.builder().build();
        imgBatchUploadResponse.setImgNodes(responseDTO.getImgNodes());
        log.warn("\u5f71\u50cf\u7cfb\u7edf\u8c03\u7528\u54cd\u5e94\u62a5\u6587\u6210\u529f\u6570:{}", (Object)(ObjectUtils.isNotEmpty((Object)responseDTO.getImgNodes()) ? responseDTO.getImgNodes().size() : 0));
        this.insertImgBatchUploadLog(dto, responseDTO);
        return responseDTO;
    }

    private void insertImgBatchUploadLog(ImgBatchUploadRequestDTO request, ClaimMediaCommitResult responseDTO) throws ApisBusinessException {
        String businessNo = request.getBusiDto().getBusinessNo();
        try {
            ApisBusiReqmsgLog apisBusiReqmsgLog = new ApisBusiReqmsgLog();
            apisBusiReqmsgLog.setApiCode(API_CODE);
            apisBusiReqmsgLog.setLogContent(JSON.toJSONString((Object)responseDTO));
            apisBusiReqmsgLog.setLogType(LOG_TYPE);
            apisBusiReqmsgLog.setOrderNo(businessNo);
            apisBusiReqmsgLog.setCreator(request.getHeadDto().getOptUserCode());
            this.apisBusiReqmsgLogService.save((Object)apisBusiReqmsgLog);
        }
        catch (Exception e) {
            log.error("\u8bb0\u5f55\u5f71\u50cf\u4e0a\u4f20\u62a5\u6587\u65f6\u51fa\u9519\uff0c\u4e1a\u52a1\u53f7\uff1a{}", (Object)businessNo, (Object)e);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }

    public Boolean uploadMxClaimMediaTask() {
        List medias;
        while (ObjectUtils.isNotEmpty((Object)(medias = this.apisBusiMxClaimMediaService.listNeedUpload()))) {
            ArrayList tempList = new ArrayList();
            medias.forEach(media -> {
                try {
                    ApisBusiMxClaimRegist regist = new ApisBusiMxClaimRegist();
                    regist.setClaimApplyId(media.getClaimApplyId());
                    ArrayList<ApisBusiMxClaimMedia> currentMedias = new ArrayList<ApisBusiMxClaimMedia>();
                    currentMedias.add((ApisBusiMxClaimMedia)media);
                    List mediaList = this.asyncUploadMxClaimMedia(regist, currentMedias);
                    mediaList.forEach(m -> {
                        ApisBusiMxClaimMediaTemp temp = new ApisBusiMxClaimMediaTemp();
                        temp.setClaimApplyId(regist.getClaimApplyId());
                        temp.setMediaName(m.getMediaNo() + "." + m.getFileSuffix());
                        temp.setMediaUrl(m.getMediaUrl());
                        tempList.add(temp);
                    });
                }
                catch (ApisBusinessException e) {
                    log.error("\u9541\u4fe1\u7406\u8d54\u4e34\u65f6\u8868\u4e0a\u4f20\u8d44\u6599\u5931\u8d25\uff0c", (Throwable)e);
                }
            });
            this.apisBusiMxClaimMediaTempService.saveBatch(tempList);
        }
        return true;
    }
}

