/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.util;

import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.hanlder.impl.CoreThirdpAuthHandler;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpAgencyInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.resp.ThirdpResponse;
import com.jdaz.sinosoftgz.coreapi.common.service.HttpRequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CoreThirdpPushUtil {
    private static final Logger log = LoggerFactory.getLogger(CoreThirdpPushUtil.class);
    @Autowired
    HttpRequestService httpRequestService;
    @Autowired
    CoreThirdpAuthHandler coreThirdpAuthHandler;

    public <T> ThirdpResponse<T> convertAndSend(String pushUrl, ThirdpAgencyInfo agencyInfo, Object requestData, String serviceName, Class<T> clazz) throws Exception {
        ThirdpHead head = ThirdpHead.builder().serviceName(serviceName).sendTimestamp(Long.valueOf(System.currentTimeMillis())).uuid(UUID.fastUUID().toString().replaceAll("-", "")).uploadId("upload" + UUID.fastUUID().toString().replaceAll("-", "")).build();
        String sourceBody = JSON.toJSONString((Object)ThirdpRequest.builder().head(head).agency(agencyInfo).data(requestData).build());
        log.warn("\u52a0\u5bc6\u524d\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)sourceBody);
        String encodeBody = this.coreThirdpAuthHandler.addAuthToBody(sourceBody);
        String responseStr = this.httpRequestService.convertAndSendForThirdp(pushUrl, encodeBody, ThirdpResponse.class, serviceName);
        ThirdpResponse response = null;
        if (ObjectUtil.isNotEmpty((Object)responseStr)) {
            responseStr = this.coreThirdpAuthHandler.decryptBody(responseStr);
            log.warn("\u89e3\u5bc6\u540e\u8fd4\u56de\u62a5\u6587\uff1a{}", (Object)responseStr);
            ThirdpResponse resp = (ThirdpResponse)JSON.parseObject((String)responseStr, ThirdpResponse.class);
            response = new ThirdpResponse();
            response.setHead(resp.getHead());
            if (ObjectUtil.isNotEmpty((Object)resp.getData())) {
                Object uploadRiskResData = JSON.parseObject((String)resp.getData().toString(), clazz);
                response.setData(uploadRiskResData);
            }
        }
        return response;
    }
}

