/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiCounter;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiCounterService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MxBusinessNoUtil {
    private static final Logger log = LoggerFactory.getLogger(MxBusinessNoUtil.class);
    private static final String MEDI_TRUST = "JDMX";
    @Autowired
    ApisBusiCounterService apisBusiCounterService;

    public static String getContractNo(String agentContractNo) {
        Assert.notEmpty((CharSequence)agentContractNo, (String)"\u6e20\u9053\u56e2\u5355\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        return MEDI_TRUST + agentContractNo;
    }

    public static String getVoucherNo(String agentVoucherNo) {
        Assert.notEmpty((CharSequence)agentVoucherNo, (String)"\u6e20\u9053\u4e2a\u4eba\u51ed\u8bc1\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        return MEDI_TRUST + agentVoucherNo;
    }

    public String getEndorseNo(String contractNo) {
        ApisBusiCounter counter = this.apisBusiCounterService.getByContractNo(contractNo);
        Integer countValue = 1;
        if (ObjectUtil.isEmpty((Object)counter)) {
            counter = new ApisBusiCounter();
            counter.setContractNo(contractNo);
            counter.setCountValue(countValue);
            if (this.apisBusiCounterService.saveCounter(counter).booleanValue()) {
                return contractNo + "-" + StringUtils.leftPad((String)countValue.toString(), (int)6, (String)"0");
            }
            return null;
        }
        countValue = counter.getCountValue();
        if (this.apisBusiCounterService.updateByContractNoAndCountValue(countValue, contractNo) == 1) {
            return contractNo + "-" + StringUtils.leftPad((String)(countValue + 1 + ""), (int)6, (String)"0");
        }
        return null;
    }

    public static String getRegistNo(String mxReportNo) {
        Assert.notEmpty((CharSequence)mxReportNo, (String)"\u9541\u4fe1\u62a5\u6848\u53f7\u4e3a\u7a7a", (Object[])new Object[0]);
        return MEDI_TRUST + mxReportNo;
    }

    public static String getInsurePk() {
        return UUID.randomUUID((boolean)true).toString().replaceAll("-", "");
    }

    public static String getClaimApplyId() {
        return UUID.randomUUID((boolean)true).toString().replaceAll("-", "");
    }

    public static String getTransactionNo() {
        return UUID.randomUUID((boolean)true).toString().replaceAll("-", "");
    }
}

