/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimRegistMedia;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimRegistMedicine;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimRegistRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYqClaimRegistRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MeiXinResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MxClaimRegistResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MxYqClaimRegistResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.ChannelUserConfigUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.MxBusinessNoUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.AnalysisConstants;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxAddInsuredVoucher;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxAddSuminsuredOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxVoucherMedicine;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddSuminsuredOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxVoucherMedicineService;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MxClaimRegistBusinessUtil {
    @Autowired
    ApisBusiMxClaimRegistService apisBusiMxClaimRegistService;
    @Autowired
    ApisBusiMxAddInsuredVoucherService apisBusiMxAddInsuredVoucherService;
    @Autowired
    ApisBusiMxAddSuminsuredOrderService apisBusiMxAddSuminsuredOrderService;
    @Autowired
    ApisBusiMxVoucherMedicineService apisBusiMxVoucherMedicineService;
    @Autowired
    ChannelUserConfigUtil channelUserConfigUtil;

    public boolean generateAndSave(ApisBusiMxClaimRegist regist, List<ApisBusiMxClaimMedia> mediaList, List<ApisBusiMxVoucherMedicine> medicineList) {
        regist.setRegistNo(MxBusinessNoUtil.getRegistNo((String)regist.getMxReportNo()));
        String pk = null;
        if ("YKF".equals(regist.getProjectCode())) {
            pk = this.apisBusiMxAddInsuredVoucherService.getPk(regist.getContractNo(), regist.getMxPolicyNo(), regist.getOrderNo());
        } else if ("YQ".equals(regist.getProjectCode())) {
            pk = this.apisBusiMxAddInsuredVoucherService.getPkToYq(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo());
        }
        regist.setPk(pk);
        regist.setClaimApplyId(MxBusinessNoUtil.getClaimApplyId());
        boolean success = false;
        if (ObjectUtils.isEmpty(mediaList)) {
            if (ObjectUtils.isEmpty((Object)regist.getReportTime())) {
                regist.setReportTime(LocalDateTime.now());
            }
            if ("YKF".equals(regist.getProjectCode())) {
                success = this.apisBusiMxClaimRegistService.saveAndLog(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getValue(), regist);
            } else if ("YQ".equals(regist.getProjectCode())) {
                success = this.apisBusiMxClaimRegistService.saveAndLog(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP_YQ.getValue(), regist);
            }
        } else if ("YKF".equals(regist.getProjectCode())) {
            success = this.apisBusiMxClaimRegistService.saveWithMediaAndLog(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP.getValue(), regist, mediaList);
        } else if ("YQ".equals(regist.getProjectCode())) {
            success = this.apisBusiMxClaimRegistService.saveWithMediaAndLog(ApisAutoTaskConstantsEnum.CLAIM_REGIST_TO_THIRDP_YQ.getValue(), regist, mediaList);
        }
        if (success && "YKF".equals(regist.getProjectCode()) && this.channelUserConfigUtil.isNewYkfOfCategory1(regist.getOrderNo())) {
            success = this.apisBusiMxVoucherMedicineService.saveBatch(medicineList);
        }
        if (success) {
            regist.setResultCode(AnalysisErrorCodeEnum.ERR_B000000.getKey());
            regist.setResultMsg(AnalysisErrorCodeEnum.ERR_B000000.getValue());
        } else {
            regist.setResultCode(AnalysisErrorCodeEnum.ERR_B110001.getKey());
            regist.setResultMsg(AnalysisErrorCodeEnum.ERR_B110001.getValue());
        }
        return success;
    }

    public MeiXinResponse<MxClaimRegistResponse> checkIdempotent(String requestId, MxYkfClaimRegistRequest requestData) {
        String msg = this.checkNull(requestData);
        if (StringUtils.isNotBlank((CharSequence)msg)) {
            return MeiXinResponse.fail((String)msg);
        }
        ApisBusiMxClaimRegist regist = (ApisBusiMxClaimRegist)BeanUtil.copyProperties((Object)requestData, ApisBusiMxClaimRegist.class, (String[])new String[0]);
        return this.checkIdempotent(requestId, regist);
    }

    private String checkNull(MxYkfClaimRegistRequest requestData) {
        if (this.channelUserConfigUtil.isNewYkfOfCategory1(requestData.getOrderNo())) {
            if (ObjectUtils.isEmpty((Object)requestData.getMedicineList())) {
                return "\u836f\u54c1\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
            for (MxYkfClaimRegistMedicine medicine : requestData.getMedicineList()) {
                if (StringUtils.isBlank((CharSequence)medicine.getStoreCode())) {
                    return "\u836f\u54c1\u5217\u8868-\u836f\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                }
                if (StringUtils.isBlank((CharSequence)medicine.getStoreName())) {
                    return "\u836f\u54c1\u5217\u8868-\u836f\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                }
                if (StringUtils.isBlank((CharSequence)medicine.getMedicineCode())) {
                    return "\u836f\u54c1\u5217\u8868-\u836f\u54c1\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                }
                if (StringUtils.isBlank((CharSequence)medicine.getMedicineName())) {
                    return "\u836f\u54c1\u5217\u8868-\u836f\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                }
                if (ObjectUtils.isEmpty((Object)medicine.getMedicineFee())) {
                    return "\u836f\u54c1\u5217\u8868-\u836f\u54c1\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\uff01";
                }
                if (!ObjectUtils.isEmpty((Object)medicine.getMedicineUnits())) continue;
                return "\u836f\u54c1\u5217\u8868-\u4efd\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01";
            }
        }
        return null;
    }

    public MeiXinResponse<MxYqClaimRegistResponse> checkIdempotent(String requestId, MxYqClaimRegistRequest requestData) {
        ApisBusiMxClaimRegist regist = (ApisBusiMxClaimRegist)BeanUtil.copyProperties((Object)requestData, ApisBusiMxClaimRegist.class, (String[])new String[0]);
        MeiXinResponse response = this.checkIdempotent(requestId, regist);
        if (ObjectUtils.isNotEmpty((Object)response)) {
            MxClaimRegistResponse responseData = (MxClaimRegistResponse)response.getResponseData();
            if (ObjectUtils.isNotEmpty((Object)responseData)) {
                MxYqClaimRegistResponse mxYqClaimRegistResponse = MxYqClaimRegistResponse.builder().mxReportNo(responseData.getMxReportNo()).reportNo(responseData.getRegistNo()).build();
                return MeiXinResponse.success((Object)mxYqClaimRegistResponse);
            }
            return MeiXinResponse.fail((String)response.getResultMsg());
        }
        return null;
    }

    private MeiXinResponse<MxClaimRegistResponse> checkIdempotent(String requestId, ApisBusiMxClaimRegist regist) {
        ApisBusiMxClaimRegist requestIdIdempotent = this.apisBusiMxClaimRegistService.getByRequestId(requestId, regist.getOrderNo());
        if (ObjectUtils.isNotEmpty((Object)requestIdIdempotent)) {
            MxClaimRegistResponse response = MxClaimRegistResponse.builder().mxReportNo(requestIdIdempotent.getMxReportNo()).registNo(requestIdIdempotent.getRegistNo()).build();
            return MeiXinResponse.success((Object)response);
        }
        ApisBusiMxClaimRegist businessIdempotent = this.apisBusiMxClaimRegistService.getByMxReportNo(regist.getMxReportNo());
        if (ObjectUtils.isNotEmpty((Object)businessIdempotent)) {
            return MeiXinResponse.fail((String)("\u9541\u4fe1\u62a5\u6848\u53f7\u3010" + regist.getMxReportNo() + "\u3011\u5df2\u5b58\u5728"));
        }
        ApisBusiMxClaimRegist claimRegist = this.apisBusiMxClaimRegistService.getCheckIdempotent(regist);
        if (ObjectUtils.isNotEmpty((Object)claimRegist)) {
            return MeiXinResponse.fail((String)("\u9541\u4fe1\u4fdd\u5355\u53f7\u3010" + regist.getMxPolicyNo() + "\u3011\u4e0d\u80fd\u91cd\u590d\u62a5\u6848"));
        }
        if (StringUtils.isNotBlank((CharSequence)regist.getOrderNo())) {
            LocalDateTime effectiveTime;
            List voucherIdempotent = this.apisBusiMxAddInsuredVoucherService.getExistAddInsuredByOrderNoAndMxPolicyNo(regist.getOrderNo(), regist.getMxPolicyNo());
            List orderIdempotent = this.apisBusiMxAddSuminsuredOrderService.getExistAddSumInsuredByOrderNoAndMxPolicyNo(regist.getOrderNo(), regist.getMxPolicyNo());
            if (ObjectUtils.isEmpty((Object)voucherIdempotent) && ObjectUtils.isEmpty((Object)orderIdempotent)) {
                String errMsg = "\u4eac\u4e1c\u56e2\u5355\u53f7:\u3010" + regist.getContractNo() + "\u3011\uff0c\u9541\u4fe1\u4fdd\u5355\u53f7\uff1a\u3010" + regist.getMxPolicyNo() + "\u3011\uff0c";
                errMsg = errMsg + "\u8d2d\u836f\u8ba2\u5355\u53f7\uff1a\u3010" + regist.getOrderNo() + "\u3011\uff0c";
                errMsg = errMsg + "\u5bf9\u5e94\u7684\u4fdd\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u6279\u51cf\uff0c\u65e0\u6cd5\u7acb\u6848";
                return MeiXinResponse.fail((String)errMsg);
            }
            LocalDateTime localDateTime = effectiveTime = ObjectUtils.isNotEmpty((Object)voucherIdempotent) ? ((ApisBusiMxAddInsuredVoucher)voucherIdempotent.get(0)).getEndorseEffectiveTime() : ((ApisBusiMxAddSuminsuredOrder)orderIdempotent.get(0)).getEndorseEffectiveTime();
            if (regist.getDamageTime().isBefore(effectiveTime)) {
                return MeiXinResponse.fail((String)("\u51fa\u9669\u65f6\u95f4\u3010" + LocalDateTimeUtil.format((LocalDateTime)regist.getDamageTime(), (String)"yyyy-MM-dd HH:mm:ss") + "\u3011\u9700\u8981\u665a\u4e8e\u6279\u6539\u751f\u6548\u65f6\u95f4\u3010" + LocalDateTimeUtil.format((LocalDateTime)effectiveTime, (String)"yyyy-MM-dd HH:mm:ss") + "\u3011"));
            }
        } else {
            ApisBusiMxAddInsuredVoucher voucherIdempotent = this.apisBusiMxAddInsuredVoucherService.getToCheckClaimRegistYq(regist.getContractNo(), regist.getPolicyNo(), regist.getMxPolicyNo());
            if (ObjectUtils.isEmpty((Object)voucherIdempotent)) {
                String errMsg = "\u4eac\u4e1c\u56e2\u5355\u53f7:\u3010" + regist.getContractNo() + "\u3011\uff0c\u9541\u4fe1\u4fdd\u5355\u53f7\uff1a\u3010" + regist.getMxPolicyNo() + "\u3011\uff0c";
                errMsg = errMsg + "\u5bf9\u5e94\u7684\u4fdd\u5355\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u7acb\u6848";
                return MeiXinResponse.fail((String)errMsg);
            }
            LocalDateTime effectiveTime = voucherIdempotent.getEndorseEffectiveTime();
            if (regist.getDamageTime().isBefore(effectiveTime)) {
                return MeiXinResponse.fail((String)("\u51fa\u9669\u65f6\u95f4\u3010" + LocalDateTimeUtil.format((LocalDateTime)regist.getDamageTime(), (String)"yyyy-MM-dd HH:mm:ss") + "\u3011\u9700\u8981\u665a\u4e8e\u6279\u6539\u751f\u6548\u65f6\u95f4\u3010" + LocalDateTimeUtil.format((LocalDateTime)effectiveTime, (String)"yyyy-MM-dd HH:mm:ss") + "\u3011"));
            }
        }
        return null;
    }

    public MeiXinResponse<MxClaimRegistResponse> checkMediaSize(List<MxYkfClaimRegistMedia> mediaList) {
        for (MxYkfClaimRegistMedia media : mediaList) {
            if (media.getMediaSize() <= AnalysisConstants.MEDIA_SIZE_LIMIT) continue;
            return MeiXinResponse.fail((String)("\u591a\u5a92\u4f53\u6587\u4ef6\u3010" + media.getMediaNo() + "\u3011\u592a\u5927\uff0c\u65e0\u6cd5\u7acb\u6848"));
        }
        return null;
    }
}

