/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.util;

import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.MxInsureBusinessUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.AnalysisConstants;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxAddInsuredOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxAddInsuredVoucher;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxAddSuminsuredOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxNewOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxNewOrderVoucher;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxSubInsuredOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxSubInsuredVoucher;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxSubSuminsuredOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxVoucherMedicine;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxAddInsuredVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxNewOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxNewOrderVoucherService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxVoucherMedicineService;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.InsureInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.Medicine;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpAgencyInfo;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.ThirdpRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.analysis.request.UploadRiskData;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelUser;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MxUploadInsureDataUtil {
    private static final Logger log = LoggerFactory.getLogger(MxUploadInsureDataUtil.class);
    @Autowired
    private ApisBusiMxNewOrderService apisBusiMxNewOrderService;
    @Autowired
    private ApisBusiMxNewOrderVoucherService apisBusiMxNewOrderVoucherService;
    @Autowired
    private ApisBusiMxAddInsuredOrderService apisBusiMxAddInsuredOrderService;
    @Autowired
    private ApisBusiMxAddInsuredVoucherService apisBusiMxAddInsuredVoucherService;
    @Autowired
    private ApisBusiMxVoucherMedicineService apisBusiMxVoucherMedicineService;
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private ApisChannelUserService apisChannelUserService;
    @Autowired
    private MxInsureBusinessUtil mxInsureBusinessUtil;
    private static final String ENDORSE_NO_SUFFIX = "-000000";

    public ThirdpRequest<UploadRiskData> generateUploadNewOrderRiskRequest(Long id, String projectCode) {
        if (ObjectUtil.isEmpty((Object)id)) {
            return null;
        }
        ThirdpRequest request = new ThirdpRequest();
        ThirdpHead headInfo = ThirdpHead.builder().uuid(UUID.fastUUID().toString()).sendTimestamp(Long.valueOf(System.currentTimeMillis())).serviceName("upload.insure.risk.info").build();
        request.setHead(headInfo);
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.eq((Object)"id", (Object)id);
        orderQueryWrapper.eq((Object)"project_code", (Object)projectCode);
        orderQueryWrapper.eq((Object)"deleted", (Object)0);
        ApisBusiMxNewOrder order = (ApisBusiMxNewOrder)this.apisBusiMxNewOrderService.getOne((Wrapper)orderQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)order)) {
            request.setAgency(this.generateThirdpAgencyInfo(order.getCreator()));
            headInfo.setUploadId(order.getRequestId());
            QueryWrapper voucherQueryWrapper = new QueryWrapper();
            voucherQueryWrapper.eq((Object)"mx_contract_no", (Object)order.getMxContractNo());
            voucherQueryWrapper.eq((Object)"project_code", (Object)projectCode);
            voucherQueryWrapper.eq((Object)"deleted", (Object)0);
            List voucherList = this.apisBusiMxNewOrderVoucherService.list((Wrapper)voucherQueryWrapper);
            UploadRiskData data = UploadRiskData.builder().facilitator(order.getOrgName()).certNo(order.getOrgId()).installmentFlag("0").build();
            BigDecimal totalPremium = BigDecimal.ZERO;
            BigDecimal totalInsuredAmount = BigDecimal.ZERO;
            int recordCount = 0;
            if (ObjectUtil.isNotEmpty((Object)voucherList)) {
                ArrayList<InsureInfo> insureInfos = new ArrayList<InsureInfo>();
                LocalDateTime now = LocalDateTime.now();
                Duration duration = Duration.between(order.getEffectiveTime(), order.getExpiredTime());
                long second = duration.getSeconds();
                long insPeriodDay = duration.toDays();
                if (second % 86400L != 0L) {
                    ++insPeriodDay;
                }
                for (ApisBusiMxNewOrderVoucher voucher : voucherList) {
                    InsureInfo insure = InsureInfo.builder().build();
                    insure.setTaskState("N");
                    insure.setPk(voucher.getPk());
                    insure.setMainGsOrderId(voucher.getMxPolicyNo());
                    insure.setServiceGsOrderId(voucher.getMxPolicyNo());
                    insure.setMainGsSku(voucher.getMxContractNo());
                    StringBuilder sb = new StringBuilder();
                    sb.append(voucher.getMxContractNo());
                    sb.append(ENDORSE_NO_SUFFIX);
                    insure.setServiceGsSku(sb.toString());
                    insure.setCategory(voucher.getPolicyNo());
                    insure.setBrand(order.getContractNo());
                    if (ObjectUtil.isNotEmpty((Object)voucher.getFaceAmount())) {
                        BigDecimal amount = voucher.getFaceAmount().divide(new BigDecimal(100));
                        insure.setInsuredAmount(amount);
                        insure.setServiceGsPrice(amount);
                        totalInsuredAmount = totalInsuredAmount.add(insure.getInsuredAmount());
                    }
                    if (ObjectUtil.isNotEmpty((Object)voucher.getPremium())) {
                        insure.setPremium(voucher.getPremium().divide(new BigDecimal(100)));
                        totalPremium = totalPremium.add(insure.getPremium());
                    }
                    insure.setPlanCode(voucher.getPlanCode());
                    insure.setPlanName(voucher.getPlanName());
                    insure.setOrderDate(voucher.getCreateTime());
                    insure.setInsPeriodDay(Long.valueOf(insPeriodDay));
                    insure.setEffeStartDate(order.getEffectiveTime());
                    insure.setEffeEndDate(order.getExpiredTime());
                    insure.setHolderName(order.getOrgName());
                    insure.setHolderCertNo(order.getOrgId());
                    insure.setInsuredName(voucher.getInsuredName());
                    insure.setInsuredCertNo(voucher.getCredentialNo());
                    insure.setIdentifyType(this.getRiskIdentityTypeByMxValue(voucher.getCredentialType()));
                    insure.setGender(this.getRiskSexValueByMxValue(voucher.getGender()));
                    insure.setBirthday(LocalDateTimeUtil.format((LocalDate)voucher.getBirthday(), (String)"yyyy-MM-dd"));
                    insure.setSocialSecurityType(voucher.getSocialSecurityType());
                    insure.setInsuredTime(voucher.getPayTime());
                    insure.setRelaType(this.getRiskRelaTypeByMxValue(voucher.getRelaType()));
                    insure.setServiceCompleteDate(now);
                    insure.setServiceGsReturnDate(now);
                    ++recordCount;
                    insureInfos.add(insure);
                }
                data.setInsureInfos(insureInfos);
            }
            data.setTotalPremium(totalPremium);
            data.setTotalInsuredAmount(totalInsuredAmount);
            data.setTotalNumRecords(Integer.valueOf(recordCount));
            request.setData((Object)data);
        }
        return request;
    }

    public ThirdpRequest<UploadRiskData> generateUploadAddInsuredOrderRiskRequest(ApisBusiMxAddInsuredOrder order, List<ApisBusiMxAddInsuredVoucher> voucherList, List<ApisBusiMxVoucherMedicine> medicineList, String projectCode) {
        ThirdpRequest request = new ThirdpRequest();
        ThirdpHead headInfo = ThirdpHead.builder().uuid(UUID.fastUUID().toString()).sendTimestamp(Long.valueOf(System.currentTimeMillis())).serviceName("upload.insure.risk.info").build();
        request.setHead(headInfo);
        ApisBusiMxNewOrder newOrder = null;
        if ("YKF".equals(projectCode)) {
            QueryWrapper orderQueryWrapper = new QueryWrapper();
            orderQueryWrapper.eq((Object)"mx_contract_no", (Object)order.getMxContractNo());
            orderQueryWrapper.eq((Object)"contract_no", (Object)order.getContractNo());
            orderQueryWrapper.eq((Object)"project_code", (Object)projectCode);
            orderQueryWrapper.eq((Object)"deleted", (Object)0);
            newOrder = (ApisBusiMxNewOrder)this.apisBusiMxNewOrderService.getOne((Wrapper)orderQueryWrapper);
        }
        if (ObjectUtil.isEmpty(newOrder)) {
            newOrder = new ApisBusiMxNewOrder();
            ApisChannelConfigs apisChannelConfig = this.getConfigOrgInfo();
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfig)) {
                newOrder.setOrgName(apisChannelConfig.getConfigValue());
                newOrder.setOrgId(apisChannelConfig.getRationCode());
            }
        }
        if (ObjectUtil.isNotEmpty(newOrder)) {
            request.setAgency(this.generateThirdpAgencyInfo(order.getCreator()));
            headInfo.setUploadId(order.getRequestId());
            UploadRiskData data = UploadRiskData.builder().facilitator(newOrder.getOrgName()).certNo(newOrder.getOrgId()).installmentFlag("0").build();
            BigDecimal totalPremium = BigDecimal.ZERO;
            BigDecimal totalInsuredAmount = BigDecimal.ZERO;
            int recordCount = 0;
            if (ObjectUtil.isNotEmpty(voucherList)) {
                ArrayList<InsureInfo> insureInfos = new ArrayList<InsureInfo>();
                LocalDateTime now = LocalDateTime.now();
                for (ApisBusiMxAddInsuredVoucher voucher : voucherList) {
                    InsureInfo insure = this.generateAddInsuredVoucher(now, newOrder, voucher, order, medicineList, projectCode);
                    if (ObjectUtil.isNotEmpty((Object)insure.getPremium())) {
                        totalPremium = totalPremium.add(insure.getPremium());
                    }
                    if (ObjectUtil.isNotEmpty((Object)insure.getInsuredAmount())) {
                        totalInsuredAmount = totalInsuredAmount.add(insure.getInsuredAmount());
                    }
                    ++recordCount;
                    insureInfos.add(insure);
                }
                data.setInsureInfos(insureInfos);
            }
            data.setTotalPremium(totalPremium);
            data.setTotalInsuredAmount(totalInsuredAmount);
            data.setTotalNumRecords(Integer.valueOf(recordCount));
            request.setData((Object)data);
        }
        return request;
    }

    public ThirdpRequest<UploadRiskData> generateUploadAddSumInsuredOrderRiskRequest(ApisBusiMxAddSuminsuredOrder order, List<ApisBusiMxVoucherMedicine> medicineList, String projectCode) {
        ThirdpRequest request = new ThirdpRequest();
        ThirdpHead headInfo = ThirdpHead.builder().uuid(UUID.fastUUID().toString()).sendTimestamp(Long.valueOf(System.currentTimeMillis())).serviceName("upload.insure.risk.info").build();
        request.setHead(headInfo);
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.eq((Object)"mx_contract_no", (Object)order.getMxContractNo());
        orderQueryWrapper.eq((Object)"contract_no", (Object)order.getContractNo());
        orderQueryWrapper.eq((Object)"project_code", (Object)projectCode);
        orderQueryWrapper.eq((Object)"deleted", (Object)0);
        ApisBusiMxNewOrder newOrder = (ApisBusiMxNewOrder)this.apisBusiMxNewOrderService.getOne((Wrapper)orderQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)newOrder)) {
            request.setAgency(this.generateThirdpAgencyInfo(order.getCreator()));
            headInfo.setUploadId(order.getRequestId());
            UploadRiskData data = UploadRiskData.builder().facilitator(newOrder.getOrgName()).certNo(newOrder.getOrgId()).installmentFlag("0").build();
            BigDecimal totalPremium = BigDecimal.ZERO;
            BigDecimal totalInsuredAmount = BigDecimal.ZERO;
            int recordCount = 0;
            List addInsuredVoucherList = this.apisBusiMxAddInsuredVoucherService.queryListByNos(order.getMxContractNo(), order.getPolicyNo(), order.getMxPolicyNo(), projectCode);
            if (ObjectUtil.isNotEmpty((Object)addInsuredVoucherList)) {
                ArrayList<InsureInfo> insureInfos = new ArrayList<InsureInfo>();
                LocalDateTime now = LocalDateTime.now();
                for (ApisBusiMxAddInsuredVoucher voucher : addInsuredVoucherList) {
                    InsureInfo insure = this.generateAddSumInsuredVoucher(now, order, newOrder, (Object)voucher, medicineList);
                    if (ObjectUtil.isNotEmpty((Object)insure.getPremium())) {
                        totalPremium = totalPremium.add(insure.getPremium());
                    }
                    if (ObjectUtil.isNotEmpty((Object)insure.getInsuredAmount())) {
                        totalInsuredAmount = totalInsuredAmount.add(insure.getInsuredAmount());
                    }
                    ++recordCount;
                    insureInfos.add(insure);
                }
                data.setInsureInfos(insureInfos);
            } else {
                List newOrderVoucherList = this.apisBusiMxNewOrderVoucherService.queryListByNos(order.getMxContractNo(), order.getPolicyNo(), order.getMxPolicyNo(), projectCode);
                if (ObjectUtil.isNotEmpty((Object)newOrderVoucherList)) {
                    ArrayList<InsureInfo> insureInfos = new ArrayList<InsureInfo>();
                    LocalDateTime now = LocalDateTime.now();
                    for (ApisBusiMxNewOrderVoucher voucher : newOrderVoucherList) {
                        InsureInfo insure = this.generateAddSumInsuredVoucher(now, order, newOrder, (Object)voucher, medicineList);
                        if (ObjectUtil.isNotEmpty((Object)insure.getPremium())) {
                            totalPremium = totalPremium.add(insure.getPremium());
                        }
                        if (ObjectUtil.isNotEmpty((Object)insure.getInsuredAmount())) {
                            totalInsuredAmount = totalInsuredAmount.add(insure.getInsuredAmount());
                        }
                        ++recordCount;
                        insureInfos.add(insure);
                    }
                    data.setInsureInfos(insureInfos);
                }
            }
            data.setTotalPremium(totalPremium);
            data.setTotalInsuredAmount(totalInsuredAmount);
            data.setTotalNumRecords(Integer.valueOf(recordCount));
            request.setData((Object)data);
        }
        return request;
    }

    public ThirdpRequest<UploadRiskData> generateUploadSubInsuredOrderRiskRequest(ApisBusiMxSubInsuredOrder order, List<ApisBusiMxSubInsuredVoucher> voucherList, List<Object> addVoucherList, String projectCode) {
        ThirdpRequest request = new ThirdpRequest();
        ThirdpHead headInfo = ThirdpHead.builder().uuid(UUID.fastUUID().toString()).sendTimestamp(Long.valueOf(System.currentTimeMillis())).serviceName("upload.insure.risk.info").build();
        request.setHead(headInfo);
        ApisBusiMxNewOrder newOrder = null;
        if ("YKF".equals(projectCode)) {
            QueryWrapper orderQueryWrapper = new QueryWrapper();
            orderQueryWrapper.eq((Object)"mx_contract_no", (Object)order.getMxContractNo());
            orderQueryWrapper.eq((Object)"contract_no", (Object)order.getContractNo());
            orderQueryWrapper.eq((Object)"project_code", (Object)projectCode);
            orderQueryWrapper.eq((Object)"deleted", (Object)0);
            newOrder = (ApisBusiMxNewOrder)this.apisBusiMxNewOrderService.getOne((Wrapper)orderQueryWrapper);
        }
        if (ObjectUtil.isEmpty(newOrder)) {
            newOrder = new ApisBusiMxNewOrder();
            ApisChannelConfigs apisChannelConfig = this.getConfigOrgInfo();
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfig)) {
                newOrder.setOrgName(apisChannelConfig.getConfigValue());
                newOrder.setOrgId(apisChannelConfig.getRationCode());
            }
        }
        if (ObjectUtil.isNotEmpty(newOrder)) {
            request.setAgency(this.generateThirdpAgencyInfo(order.getCreator()));
            headInfo.setUploadId(order.getRequestId());
            UploadRiskData data = UploadRiskData.builder().facilitator(newOrder.getOrgName()).certNo(newOrder.getOrgId()).installmentFlag("0").build();
            BigDecimal totalPremium = BigDecimal.ZERO;
            BigDecimal totalInsuredAmount = BigDecimal.ZERO;
            int recordCount = 0;
            if (ObjectUtil.isNotEmpty(voucherList)) {
                ArrayList<InsureInfo> insureInfos = new ArrayList<InsureInfo>();
                LocalDateTime now = LocalDateTime.now();
                int voucherInd = 0;
                for (ApisBusiMxSubInsuredVoucher voucher : voucherList) {
                    InsureInfo insure;
                    ApisBusiMxNewOrderVoucher addVoucher;
                    Object obj = addVoucherList.get(voucherInd);
                    if (obj instanceof ApisBusiMxNewOrderVoucher) {
                        addVoucher = (ApisBusiMxNewOrderVoucher)obj;
                        insure = this.generateSubInsuredVoucher(now, newOrder, voucher, addVoucher, order);
                    } else if (obj instanceof ApisBusiMxAddInsuredVoucher) {
                        addVoucher = (ApisBusiMxAddInsuredVoucher)obj;
                        insure = this.generateSubInsuredVoucher(now, newOrder, voucher, (ApisBusiMxAddInsuredVoucher)addVoucher, order);
                    } else {
                        insure = new InsureInfo();
                    }
                    ++voucherInd;
                    if (ObjectUtil.isNotEmpty((Object)insure.getPremium())) {
                        totalPremium = totalPremium.add(insure.getPremium());
                    }
                    if (ObjectUtil.isNotEmpty((Object)insure.getInsuredAmount())) {
                        totalInsuredAmount = totalInsuredAmount.add(insure.getInsuredAmount());
                    }
                    ++recordCount;
                    insureInfos.add(insure);
                }
                data.setInsureInfos(insureInfos);
            }
            data.setTotalPremium(totalPremium);
            data.setTotalInsuredAmount(totalInsuredAmount);
            data.setTotalNumRecords(Integer.valueOf(recordCount));
            request.setData((Object)data);
        }
        return request;
    }

    public ThirdpRequest<UploadRiskData> generateUploadSubSumInsuredOrderRiskRequest(ApisBusiMxSubSuminsuredOrder order, Object addInsuredObj, String projectCode) {
        ThirdpRequest request = new ThirdpRequest();
        ThirdpHead headInfo = ThirdpHead.builder().uuid(UUID.fastUUID().toString()).sendTimestamp(Long.valueOf(System.currentTimeMillis())).serviceName("upload.insure.risk.info").build();
        request.setHead(headInfo);
        QueryWrapper orderQueryWrapper = new QueryWrapper();
        orderQueryWrapper.eq((Object)"mx_contract_no", (Object)order.getMxContractNo());
        orderQueryWrapper.eq((Object)"contract_no", (Object)order.getContractNo());
        orderQueryWrapper.eq((Object)"project_code", (Object)projectCode);
        orderQueryWrapper.eq((Object)"deleted", (Object)0);
        ApisBusiMxNewOrder newOrder = (ApisBusiMxNewOrder)this.apisBusiMxNewOrderService.getOne((Wrapper)orderQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)newOrder)) {
            request.setAgency(this.generateThirdpAgencyInfo(order.getCreator()));
            headInfo.setUploadId(order.getRequestId());
            UploadRiskData data = UploadRiskData.builder().facilitator(newOrder.getOrgName()).certNo(newOrder.getOrgId()).installmentFlag("0").build();
            BigDecimal totalPremium = BigDecimal.ZERO;
            BigDecimal totalInsuredAmount = BigDecimal.ZERO;
            int recordCount = 0;
            if (addInsuredObj instanceof ApisBusiMxAddInsuredVoucher) {
                ApisBusiMxAddInsuredVoucher voucher = (ApisBusiMxAddInsuredVoucher)addInsuredObj;
                ArrayList<InsureInfo> insureInfos = new ArrayList<InsureInfo>();
                LocalDateTime now = LocalDateTime.now();
                InsureInfo insure = this.generateSubSumInsuredVoucher(now, order, newOrder, (Object)voucher);
                if (ObjectUtil.isNotEmpty((Object)insure.getPremium())) {
                    totalPremium = totalPremium.add(insure.getPremium());
                }
                if (ObjectUtil.isNotEmpty((Object)insure.getInsuredAmount())) {
                    totalInsuredAmount = totalInsuredAmount.add(insure.getInsuredAmount());
                }
                ++recordCount;
                insureInfos.add(insure);
                data.setInsureInfos(insureInfos);
            } else if (addInsuredObj instanceof ApisBusiMxAddSuminsuredOrder) {
                ApisBusiMxAddSuminsuredOrder voucher = (ApisBusiMxAddSuminsuredOrder)addInsuredObj;
                ArrayList<InsureInfo> insureInfos = new ArrayList<InsureInfo>();
                LocalDateTime now = LocalDateTime.now();
                InsureInfo insure = this.generateSubSumInsuredVoucher(now, order, newOrder, (Object)voucher);
                if (ObjectUtil.isNotEmpty((Object)insure.getPremium())) {
                    totalPremium = totalPremium.add(insure.getPremium());
                }
                if (ObjectUtil.isNotEmpty((Object)insure.getInsuredAmount())) {
                    totalInsuredAmount = totalInsuredAmount.add(insure.getInsuredAmount());
                }
                ++recordCount;
                insureInfos.add(insure);
                data.setInsureInfos(insureInfos);
            }
            data.setTotalPremium(totalPremium);
            data.setTotalInsuredAmount(totalInsuredAmount);
            data.setTotalNumRecords(Integer.valueOf(recordCount));
            request.setData((Object)data);
        }
        return request;
    }

    private ThirdpAgencyInfo generateThirdpAgencyInfo(String userCode) {
        ThirdpAgencyInfo thirdpAgencyInfo = ThirdpAgencyInfo.builder().build();
        QueryWrapper apisChannelUserQueryWrapper = new QueryWrapper();
        apisChannelUserQueryWrapper.eq((Object)"user_code", (Object)userCode);
        apisChannelUserQueryWrapper.eq((Object)"deleted", (Object)0);
        List userList = this.apisChannelUserService.list((Wrapper)apisChannelUserQueryWrapper);
        if (ObjectUtil.isNotEmpty((Object)userList)) {
            thirdpAgencyInfo.setAgencyCode(((ApisChannelUser)userList.get(0)).getChannelCode());
            thirdpAgencyInfo.setUserCode(((ApisChannelUser)userList.get(0)).getUserCode());
            thirdpAgencyInfo.setPassword(((ApisChannelUser)userList.get(0)).getPwd());
        } else {
            log.warn("\u7ec4\u7ec7\u9541\u4fe1\u8bf7\u6c42\u62a5\u6587\uff0c\u67e5\u8be2\u4e0d\u5230\u8d26\u53f7{}", (Object)userCode);
        }
        return thirdpAgencyInfo;
    }

    private InsureInfo generateAddInsuredVoucher(LocalDateTime now, ApisBusiMxNewOrder newOrder, ApisBusiMxAddInsuredVoucher voucher, ApisBusiMxAddInsuredOrder addInsuredOrder, List<ApisBusiMxVoucherMedicine> medicineList, String projectCode) {
        InsureInfo insure = InsureInfo.builder().build();
        insure.setTaskState("N");
        insure.setPk(voucher.getPk());
        insure.setMainGsOrderId(voucher.getMxPolicyNo());
        insure.setServiceGsOrderId(voucher.getOrderNo());
        insure.setMainGsSku(voucher.getMxContractNo());
        insure.setServiceGsSku(addInsuredOrder.getEndorseNo());
        insure.setCategory(voucher.getPolicyNo());
        insure.setBrand(addInsuredOrder.getContractNo());
        if (ObjectUtil.isNotEmpty((Object)voucher.getFaceAmount())) {
            BigDecimal amount = voucher.getFaceAmount().divide(new BigDecimal(100));
            insure.setInsuredAmount(amount);
            insure.setServiceGsPrice(amount);
        }
        if (ObjectUtil.isNotEmpty((Object)voucher.getPremium())) {
            insure.setPremium(voucher.getPremium().divide(new BigDecimal(100)));
        }
        insure.setInsuredTime(voucher.getPayTime());
        insure.setPlanCode(voucher.getPlanCode());
        insure.setPlanName(voucher.getPlanName());
        if (ObjectUtil.isNotEmpty((Object)voucher.getEndorseEffectiveTime())) {
            insure.setOrderDate(Date.from(ZonedDateTime.of(voucher.getEndorseEffectiveTime(), ZoneId.systemDefault()).toInstant()));
        }
        insure.setEffeStartDate(voucher.getEndorseEffectiveTime());
        if ("YQ".equals(projectCode)) {
            insure.setEffeEndDate(this.mxInsureBusinessUtil.getPolicyExpireDateConfig(addInsuredOrder.getContractNo()));
        } else {
            insure.setEffeEndDate(voucher.getEndorseEffectiveTime().plusYears(1L).minusSeconds(1L));
        }
        if (ObjectUtil.isNotEmpty((Object)insure.getEffeEndDate())) {
            Duration duration = Duration.between(insure.getEffeStartDate(), insure.getEffeEndDate());
            long second = duration.getSeconds();
            long insPeriodDay = duration.toDays();
            if (second % 86400L != 0L) {
                ++insPeriodDay;
            }
            insure.setInsPeriodDay(Long.valueOf(insPeriodDay));
        }
        insure.setHolderName(newOrder.getOrgName());
        insure.setHolderCertNo(newOrder.getOrgId());
        insure.setInsuredName(voucher.getInsuredName());
        insure.setInsuredCertNo(voucher.getCredentialNo());
        insure.setIdentifyType(this.getRiskIdentityTypeByMxValue(voucher.getCredentialType()));
        insure.setGender(this.getRiskSexValueByMxValue(voucher.getGender()));
        insure.setBirthday(LocalDateTimeUtil.format((LocalDate)voucher.getBirthday(), (String)"yyyy-MM-dd"));
        insure.setSocialSecurityType(voucher.getSocialSecurityType());
        insure.setRelaType(this.getRiskRelaTypeByMxValue(voucher.getRelaType()));
        insure.setServiceCompleteDate(now);
        insure.setServiceGsReturnDate(now);
        insure.setMedicineList(this.generateAddInsuredVoucherMedicineList((Object)voucher, medicineList, "ADD_INSURED"));
        return insure;
    }

    private InsureInfo generateSubInsuredVoucher(LocalDateTime now, ApisBusiMxNewOrder newOrder, ApisBusiMxSubInsuredVoucher subVoucher, ApisBusiMxAddInsuredVoucher voucher, ApisBusiMxSubInsuredOrder subInsuredOrder) {
        InsureInfo insure = InsureInfo.builder().build();
        insure.setTaskState("C");
        insure.setPk(subVoucher.getPk());
        insure.setMainGsOrderId(subVoucher.getMxPolicyNo());
        insure.setServiceGsOrderId(voucher.getOrderNo());
        insure.setMainGsSku(subVoucher.getMxContractNo());
        insure.setServiceGsSku(subInsuredOrder.getEndorseNo());
        insure.setCategory(subVoucher.getPolicyNo());
        insure.setBrand(subInsuredOrder.getContractNo());
        if (ObjectUtil.isNotEmpty((Object)voucher.getFaceAmount())) {
            BigDecimal amount = voucher.getFaceAmount().divide(new BigDecimal(100));
            insure.setInsuredAmount(amount);
            insure.setServiceGsPrice(amount);
        }
        if (ObjectUtil.isNotEmpty((Object)voucher.getPremium())) {
            insure.setPremium(voucher.getPremium().divide(new BigDecimal(100)));
        }
        insure.setPlanCode(voucher.getPlanCode());
        insure.setPlanName(voucher.getPlanName());
        if (ObjectUtil.isNotEmpty((Object)subVoucher.getEffectiveDate())) {
            insure.setOrderDate(Date.from(ZonedDateTime.of(subVoucher.getEffectiveDate(), ZoneId.systemDefault()).toInstant()));
        }
        insure.setEffeStartDate(subVoucher.getEffectiveDate());
        insure.setEffeEndDate(subVoucher.getEffectiveDate().plusYears(1L).minusSeconds(1L));
        if (ObjectUtil.isNotEmpty((Object)insure.getEffeEndDate())) {
            Duration duration = Duration.between(insure.getEffeStartDate(), insure.getEffeEndDate());
            long second = duration.getSeconds();
            long insPeriodDay = duration.toDays();
            if (second % 86400L != 0L) {
                ++insPeriodDay;
            }
            insure.setInsPeriodDay(Long.valueOf(insPeriodDay));
        }
        insure.setHolderName(newOrder.getOrgName());
        insure.setHolderCertNo(newOrder.getOrgId());
        insure.setInsuredName(voucher.getInsuredName());
        insure.setInsuredCertNo(voucher.getCredentialNo());
        insure.setIdentifyType(this.getRiskIdentityTypeByMxValue(voucher.getCredentialType()));
        insure.setGender(this.getRiskSexValueByMxValue(voucher.getGender()));
        insure.setBirthday(LocalDateTimeUtil.format((LocalDate)voucher.getBirthday(), (String)"yyyy-MM-dd"));
        insure.setSocialSecurityType(voucher.getSocialSecurityType());
        insure.setRelaType(this.getRiskRelaTypeByMxValue(voucher.getRelaType()));
        insure.setServiceCompleteDate(now);
        insure.setServiceGsReturnDate(now);
        return insure;
    }

    private InsureInfo generateSubInsuredVoucher(LocalDateTime now, ApisBusiMxNewOrder newOrder, ApisBusiMxSubInsuredVoucher subVoucher, ApisBusiMxNewOrderVoucher voucher, ApisBusiMxSubInsuredOrder subInsuredOrder) {
        InsureInfo insure = InsureInfo.builder().build();
        insure.setTaskState("C");
        insure.setPk(subVoucher.getPk());
        insure.setMainGsOrderId(subVoucher.getMxPolicyNo());
        insure.setServiceGsOrderId(subVoucher.getMxPolicyNo());
        insure.setMainGsSku(subVoucher.getMxContractNo());
        insure.setServiceGsSku(subInsuredOrder.getEndorseNo());
        insure.setCategory(subVoucher.getPolicyNo());
        insure.setBrand(subInsuredOrder.getContractNo());
        if (ObjectUtil.isNotEmpty((Object)voucher.getFaceAmount())) {
            BigDecimal amount = voucher.getFaceAmount().divide(new BigDecimal(100));
            insure.setInsuredAmount(amount);
            insure.setServiceGsPrice(amount);
        }
        if (ObjectUtil.isNotEmpty((Object)voucher.getPremium())) {
            insure.setPremium(voucher.getPremium().divide(new BigDecimal(100)));
        }
        insure.setPlanCode(voucher.getPlanCode());
        insure.setPlanName(voucher.getPlanName());
        if (ObjectUtil.isNotEmpty((Object)subVoucher.getEffectiveDate())) {
            insure.setOrderDate(Date.from(ZonedDateTime.of(subVoucher.getEffectiveDate(), ZoneId.systemDefault()).toInstant()));
        }
        insure.setEffeStartDate(subVoucher.getEffectiveDate());
        insure.setEffeEndDate(subVoucher.getEffectiveDate().plusYears(1L).minusSeconds(1L));
        if (ObjectUtil.isNotEmpty((Object)insure.getEffeEndDate())) {
            Duration duration = Duration.between(insure.getEffeStartDate(), insure.getEffeEndDate());
            long second = duration.getSeconds();
            long insPeriodDay = duration.toDays();
            if (second % 86400L != 0L) {
                ++insPeriodDay;
            }
            insure.setInsPeriodDay(Long.valueOf(insPeriodDay));
        }
        insure.setHolderName(newOrder.getOrgName());
        insure.setHolderCertNo(newOrder.getOrgId());
        insure.setInsuredName(voucher.getInsuredName());
        insure.setInsuredCertNo(voucher.getCredentialNo());
        insure.setIdentifyType(this.getRiskIdentityTypeByMxValue(voucher.getCredentialType()));
        insure.setGender(this.getRiskSexValueByMxValue(voucher.getGender()));
        insure.setBirthday(LocalDateTimeUtil.format((LocalDate)voucher.getBirthday(), (String)"yyyy-MM-dd"));
        insure.setSocialSecurityType(voucher.getSocialSecurityType());
        insure.setRelaType(this.getRiskRelaTypeByMxValue(voucher.getRelaType()));
        insure.setServiceCompleteDate(now);
        insure.setServiceGsReturnDate(now);
        return insure;
    }

    private InsureInfo generateAddSumInsuredVoucher(LocalDateTime now, ApisBusiMxAddSuminsuredOrder order, ApisBusiMxNewOrder newOrder, Object obj, List<ApisBusiMxVoucherMedicine> medicineList) {
        InsureInfo insure = InsureInfo.builder().build();
        insure.setTaskState("N");
        insure.setPk(order.getPk());
        insure.setMainGsOrderId(order.getMxPolicyNo());
        insure.setServiceGsOrderId(order.getOrderNo());
        insure.setMainGsSku(order.getMxContractNo());
        insure.setServiceGsSku(order.getEndorseNo());
        insure.setCategory(order.getPolicyNo());
        insure.setBrand(order.getContractNo());
        if (ObjectUtil.isNotEmpty((Object)order.getEndorseFaceAmount())) {
            BigDecimal amount = order.getEndorseFaceAmount().divide(new BigDecimal(100));
            insure.setInsuredAmount(amount);
            insure.setServiceGsPrice(amount);
        }
        insure.setInsuredTime(order.getPayTime());
        if (ObjectUtil.isNotEmpty((Object)order.getEndorsePremium())) {
            insure.setPremium(order.getEndorsePremium().divide(new BigDecimal(100)));
        }
        insure.setPlanCode(order.getPlanCode());
        insure.setPlanName(order.getPlanName());
        if (ObjectUtil.isNotEmpty((Object)order.getEndorseEffectiveTime())) {
            insure.setOrderDate(Date.from(ZonedDateTime.of(order.getEndorseEffectiveTime(), ZoneId.systemDefault()).toInstant()));
        }
        insure.setEffeStartDate(order.getEndorseEffectiveTime());
        insure.setEffeEndDate(order.getEndorseEffectiveTime().plusYears(1L).minusSeconds(1L));
        Duration duration = Duration.between(insure.getEffeStartDate(), insure.getEffeEndDate());
        long second = duration.getSeconds();
        long insPeriodDay = duration.toDays();
        if (second % 86400L != 0L) {
            ++insPeriodDay;
        }
        insure.setInsPeriodDay(Long.valueOf(insPeriodDay));
        insure.setHolderName(newOrder.getOrgName());
        insure.setHolderCertNo(newOrder.getOrgId());
        if (obj instanceof ApisBusiMxAddInsuredVoucher) {
            ApisBusiMxAddInsuredVoucher voucher = (ApisBusiMxAddInsuredVoucher)obj;
            insure.setInsuredName(voucher.getInsuredName());
            insure.setInsuredCertNo(voucher.getCredentialNo());
            insure.setIdentifyType(this.getRiskIdentityTypeByMxValue(voucher.getCredentialType()));
            insure.setGender(this.getRiskSexValueByMxValue(voucher.getGender()));
            insure.setBirthday(LocalDateTimeUtil.format((LocalDate)voucher.getBirthday(), (String)"yyyy-MM-dd"));
            insure.setSocialSecurityType(voucher.getSocialSecurityType());
            insure.setRelaType(this.getRiskRelaTypeByMxValue(voucher.getRelaType()));
            insure.setMedicineList(this.generateAddInsuredVoucherMedicineList((Object)voucher, medicineList, "ADD_SUMINSURED"));
        } else if (obj instanceof ApisBusiMxNewOrderVoucher) {
            ApisBusiMxNewOrderVoucher voucher = (ApisBusiMxNewOrderVoucher)obj;
            insure.setInsuredName(voucher.getInsuredName());
            insure.setInsuredCertNo(voucher.getCredentialNo());
            insure.setIdentifyType(this.getRiskIdentityTypeByMxValue(voucher.getCredentialType()));
            insure.setGender(this.getRiskSexValueByMxValue(voucher.getGender()));
            insure.setBirthday(LocalDateTimeUtil.format((LocalDate)voucher.getBirthday(), (String)"yyyy-MM-dd"));
            insure.setSocialSecurityType(voucher.getSocialSecurityType());
            insure.setRelaType(this.getRiskRelaTypeByMxValue(voucher.getRelaType()));
            insure.setMedicineList(this.generateAddInsuredVoucherMedicineList((Object)voucher, medicineList, "ADD_SUMINSURED"));
        }
        insure.setServiceCompleteDate(now);
        insure.setServiceGsReturnDate(now);
        return insure;
    }

    private InsureInfo generateSubSumInsuredVoucher(LocalDateTime now, ApisBusiMxSubSuminsuredOrder order, ApisBusiMxNewOrder newOrder, Object obj) {
        InsureInfo insure = InsureInfo.builder().build();
        insure.setTaskState("C");
        insure.setPk(order.getPk());
        insure.setMainGsOrderId(order.getMxPolicyNo());
        insure.setServiceGsOrderId(order.getOrderNo());
        insure.setMainGsSku(order.getMxContractNo());
        insure.setServiceGsSku(order.getEndorseNo());
        insure.setCategory(order.getPolicyNo());
        insure.setBrand(order.getContractNo());
        if (ObjectUtil.isNotEmpty((Object)order.getEndorseFaceAmount())) {
            BigDecimal amount = order.getEndorseFaceAmount().divide(new BigDecimal(100));
            insure.setInsuredAmount(amount);
            insure.setServiceGsPrice(amount);
        }
        if (ObjectUtil.isNotEmpty((Object)order.getEndorsePremium())) {
            insure.setPremium(order.getEndorsePremium().divide(new BigDecimal(100)));
        }
        if (ObjectUtil.isNotEmpty((Object)order.getEndorseEffectiveTime())) {
            insure.setOrderDate(Date.from(ZonedDateTime.of(order.getEndorseEffectiveTime(), ZoneId.systemDefault()).toInstant()));
        }
        insure.setEffeStartDate(order.getEndorseEffectiveTime());
        insure.setEffeEndDate(order.getEndorseEffectiveTime().plusYears(1L).minusSeconds(1L));
        Duration duration = Duration.between(insure.getEffeStartDate(), insure.getEffeEndDate());
        long second = duration.getSeconds();
        long insPeriodDay = duration.toDays();
        if (second % 86400L != 0L) {
            ++insPeriodDay;
        }
        insure.setInsPeriodDay(Long.valueOf(insPeriodDay));
        insure.setHolderName(newOrder.getOrgName());
        insure.setHolderCertNo(newOrder.getOrgId());
        if (obj instanceof ApisBusiMxAddInsuredVoucher) {
            ApisBusiMxAddInsuredVoucher voucher = (ApisBusiMxAddInsuredVoucher)obj;
            insure.setPlanCode(voucher.getPlanCode());
            insure.setPlanName(voucher.getPlanName());
            insure.setInsuredName(voucher.getInsuredName());
            insure.setInsuredCertNo(voucher.getCredentialNo());
            insure.setIdentifyType(this.getRiskIdentityTypeByMxValue(voucher.getCredentialType()));
            insure.setGender(this.getRiskSexValueByMxValue(voucher.getGender()));
            insure.setBirthday(LocalDateTimeUtil.format((LocalDate)voucher.getBirthday(), (String)"yyyy-MM-dd"));
            insure.setSocialSecurityType(voucher.getSocialSecurityType());
            insure.setRelaType(this.getRiskRelaTypeByMxValue(voucher.getRelaType()));
        } else if (obj instanceof ApisBusiMxAddSuminsuredOrder) {
            ApisBusiMxAddSuminsuredOrder voucher = (ApisBusiMxAddSuminsuredOrder)obj;
            List addInsuredVoucherList = this.apisBusiMxAddInsuredVoucherService.queryListByNos(voucher.getMxContractNo(), voucher.getPolicyNo(), voucher.getMxPolicyNo(), "YKF");
            insure.setPlanCode(voucher.getPlanCode());
            insure.setPlanName(voucher.getPlanName());
            if (ObjectUtil.isNotEmpty((Object)addInsuredVoucherList)) {
                insure.setInsuredName(((ApisBusiMxAddInsuredVoucher)addInsuredVoucherList.get(0)).getInsuredName());
                insure.setInsuredCertNo(((ApisBusiMxAddInsuredVoucher)addInsuredVoucherList.get(0)).getCredentialNo());
                insure.setIdentifyType(this.getRiskIdentityTypeByMxValue(((ApisBusiMxAddInsuredVoucher)addInsuredVoucherList.get(0)).getCredentialType()));
                insure.setGender(this.getRiskSexValueByMxValue(((ApisBusiMxAddInsuredVoucher)addInsuredVoucherList.get(0)).getGender()));
                insure.setBirthday(LocalDateTimeUtil.format((LocalDate)((ApisBusiMxAddInsuredVoucher)addInsuredVoucherList.get(0)).getBirthday(), (String)"yyyy-MM-dd"));
                insure.setSocialSecurityType(((ApisBusiMxAddInsuredVoucher)addInsuredVoucherList.get(0)).getSocialSecurityType());
                insure.setRelaType(this.getRiskRelaTypeByMxValue(((ApisBusiMxAddInsuredVoucher)addInsuredVoucherList.get(0)).getRelaType()));
            }
        }
        insure.setServiceCompleteDate(now);
        insure.setServiceGsReturnDate(now);
        return insure;
    }

    private List<Medicine> generateAddInsuredVoucherMedicineList(Object obj, List<ApisBusiMxVoucherMedicine> medicineList, String source) {
        ArrayList<Medicine> mediList = null;
        if (ObjectUtil.isNotEmpty(medicineList)) {
            ApisBusiMxNewOrderVoucher voucher;
            List voucherMedicineList = null;
            if (obj instanceof ApisBusiMxNewOrderVoucher) {
                voucher = (ApisBusiMxNewOrderVoucher)obj;
                voucherMedicineList = medicineList.stream().filter(m -> m.getMxContractNo().equals(voucher.getMxContractNo()) && m.getMxPolicyNo().equals(voucher.getMxPolicyNo()) & source.equals(m.getSource())).collect(Collectors.toList());
            } else if (obj instanceof ApisBusiMxAddInsuredVoucher) {
                voucher = (ApisBusiMxAddInsuredVoucher)obj;
                voucherMedicineList = medicineList.stream().filter(arg_0 -> MxUploadInsureDataUtil.lambda$generateAddInsuredVoucherMedicineList$1((ApisBusiMxAddInsuredVoucher)voucher, source, arg_0)).collect(Collectors.toList());
            }
            if (ObjectUtil.isNotEmpty(voucherMedicineList)) {
                mediList = new ArrayList<Medicine>();
                for (ApisBusiMxVoucherMedicine medicine : voucherMedicineList) {
                    Medicine medi = new Medicine();
                    BeanUtils.copyProperties((Object)medicine, (Object)medi);
                    if (ObjectUtil.isNotEmpty((Object)medicine.getMedicineFee())) {
                        medi.setMedicineFee(medicine.getMedicineFee().divide(BigDecimal.valueOf(100L)));
                    }
                    mediList.add(medi);
                }
            }
        }
        return mediList;
    }

    private ApisChannelConfigs getConfigOrgInfo() {
        ApisChannelConfigs apisChannelConfigsQueryWrapper = new ApisChannelConfigs();
        apisChannelConfigsQueryWrapper.setConfigCode("MX_YQ_ORGANIZATION_INFO");
        ApisChannelConfigs apisChannelConfig = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsQueryWrapper);
        return apisChannelConfig;
    }

    private String getRiskSexValueByMxValue(String mxSex) {
        String riskSex = (String)AnalysisConstants.MX_SEX_TO_RISK_MAP.get(mxSex);
        return riskSex;
    }

    private String getRiskIdentityTypeByMxValue(String mxIdentityType) {
        String riskIdentityType = (String)AnalysisConstants.MX_IDENTITY_TYPE_TO_RISK_MAP.get(mxIdentityType);
        return riskIdentityType;
    }

    private String getRiskRelaTypeByMxValue(String mxRelaType) {
        String riskRelaType = (String)AnalysisConstants.MX_RELA_TYPE_TO_RISK_MAP.get(mxRelaType);
        return riskRelaType;
    }

    private static /* synthetic */ boolean lambda$generateAddInsuredVoucherMedicineList$1(ApisBusiMxAddInsuredVoucher voucher, String source, ApisBusiMxVoucherMedicine m) {
        return m.getMxContractNo().equals(voucher.getMxContractNo()) && m.getMxPolicyNo().equals(voucher.getMxPolicyNo()) & source.equals(m.getSource());
    }
}

