/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.hanlder.WarnConvertHandler;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.vo.WarnConvertVo;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.SpringContextUtil;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiEmailSendLog;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiWarnData;
import com.jdaz.sinosoftgz.apis.commons.model.busi.entity.ApisBusiWarnRule;
import com.jdaz.sinosoftgz.apis.commons.model.busi.mapper.ApisBusiEmailSendLogMapper;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiWarnDataService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiWarnRuleService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component
public class WarnSendUtil {
    private static final Logger log = LoggerFactory.getLogger(WarnSendUtil.class);
    private static final String CODE_SPLIT = ",";
    private static final String EMAIL_SPLIT = ";";
    private static final String CONFIGS_EMAIL_ADDRESS_APIS_TEAM = "EMAIL_ADDRESS_APIS_TEAM";
    @Autowired
    ApisBusiEmailSendLogMapper emailSendLogMapper;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiWarnDataService apisBusiWarnDataService;
    @Autowired
    ApisBusiWarnRuleService apisBusiWarnRuleService;
    @Resource
    SpringContextUtil springContextUtil;

    @Async(value="warnDataExecutor")
    @Transactional(rollbackFor={Exception.class})
    public void claimConvertSendEmail(WarnConvertVo warnConvertVo) {
        Class warnConvertHandler = warnConvertVo.getWarnConvertHandler();
        WarnConvertHandler convertHandler = (WarnConvertHandler)this.springContextUtil.getBean(warnConvertHandler);
        ApisBusiWarnData warnData = convertHandler.warnDataConvert(warnConvertVo.getData(), warnConvertVo.getErrCode(), warnConvertVo.getErrMessage());
        if (!this.idempotentCheck(warnData)) {
            this.saveWarnSendEmail(warnConvertVo.getRequestUrl(), warnData);
        }
    }

    private boolean idempotentCheck(ApisBusiWarnData warnData) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"user_code", (Object)warnData.getUserCode())).eq((Object)"channel_code", (Object)warnData.getChannelCode())).eq((Object)"error_code", (Object)warnData.getErrorCode())).eq((Object)"agency_policy_ref", (Object)warnData.getAgencyPolicyRef())).eq((Object)"policy_no", (Object)warnData.getPolicyNo());
        int count = this.apisBusiWarnDataService.count((Wrapper)queryWrapper);
        return count > 0;
    }

    private void saveWarnSendEmail(String requestUrl, ApisBusiWarnData warnData) {
        List matchRules = this.saveWarn(requestUrl, warnData);
        if (!CollectionUtils.isEmpty((Collection)matchRules)) {
            this.emailSend(warnData, matchRules);
        }
    }

    private List<ApisBusiWarnRule> saveWarn(String requestUrl, ApisBusiWarnData warnData) {
        log.warn("\u544a\u8b66\u4fdd\u5b58\uff0c{}", (Object)JSON.toJSONString((Object)warnData));
        this.apisBusiWarnDataService.save((Object)warnData);
        String productCode = warnData.getProductCode();
        String userCode = warnData.getUserCode();
        String ruleCode = this.getRuleCodeFromRequest(requestUrl);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"rule_code", (Object)ruleCode);
        List rules = this.apisBusiWarnRuleService.list((Wrapper)queryWrapper);
        List<Object> matchRules = new ArrayList<ApisBusiWarnRule>();
        if (!CollectionUtils.isEmpty((Collection)rules)) {
            Predicate<ApisBusiWarnRule> productCodeContain = rule -> {
                if (StringUtils.isBlank((CharSequence)rule.getProductCodeList())) {
                    return true;
                }
                List productCodes = Arrays.stream(StringUtils.split((String)rule.getProductCodeList(), (String)CODE_SPLIT)).collect(Collectors.toList());
                return productCodes.contains(productCode);
            };
            Predicate<ApisBusiWarnRule> userCodeContain = rule -> {
                if (StringUtils.isBlank((CharSequence)rule.getUserCodeList())) {
                    return true;
                }
                List userCodes = Arrays.stream(StringUtils.split((String)rule.getUserCodeList(), (String)CODE_SPLIT)).collect(Collectors.toList());
                return userCodes.contains(userCode);
            };
            matchRules = rules.stream().filter(productCodeContain.and(userCodeContain)).collect(Collectors.toList());
            log.warn("\u5339\u914d\u5230\u7684\u8b66\u544a\u89c4\u5219\uff0c{}", matchRules);
        }
        return matchRules;
    }

    private String getRuleCodeFromRequest(String requestUrl) {
        Object ruleCode = "";
        Object[] urls = StringUtils.split((String)requestUrl, (String)"/");
        if (ArrayUtils.isNotEmpty((Object[])urls)) {
            ruleCode = urls[urls.length - 1];
        }
        return ruleCode;
    }

    private void emailSend(ApisBusiWarnData warnData, List<ApisBusiWarnRule> matchRules) {
        if (!CollectionUtils.isEmpty(matchRules)) {
            String productCode = warnData.getProductCode();
            String userCode = warnData.getUserCode();
            QueryWrapper queryWrapper = new QueryWrapper();
            String now = DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"product_code", (Object)productCode)).eq((Object)"user_code", (Object)userCode)).apply("DATE_FORMAT(create_time,'%Y-%m-%d') = {0}", new Object[]{now});
            int count = this.apisBusiWarnDataService.count((Wrapper)queryWrapper);
            ApisChannelConfigs config = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)new QueryWrapper().eq((Object)"config_code", (Object)CONFIGS_EMAIL_ADDRESS_APIS_TEAM));
            String apisEmails = "";
            if (config != null) {
                apisEmails = config.getConfigValue();
            }
            Object[] toArr = new String[]{};
            Object[] ccArr = new String[]{};
            for (ApisBusiWarnRule matchRule : matchRules) {
                toArr = (String[])ArrayUtils.addAll((Object[])StringUtils.split((String)matchRule.getEmailToList(), (String)EMAIL_SPLIT), (Object[])toArr);
                ccArr = (String[])ArrayUtils.addAll((Object[])StringUtils.split((String)matchRule.getEmailCcList(), (String)EMAIL_SPLIT), (Object[])ccArr);
            }
            ApisBusiWarnRule rule = matchRules.get(0);
            JSONObject warnDataMap = JSONObject.parseObject((String)JSON.toJSONString((Object)warnData));
            warnDataMap.put("n", (Object)count);
            String subjectTpl = rule.getEmailSubjectTpl();
            subjectTpl = this.templateReplace(subjectTpl, (Map)warnDataMap);
            String contentTpl = rule.getEmailContentTpl();
            contentTpl = this.templateReplace(contentTpl, (Map)warnDataMap);
            String emailTo = StringUtils.join((Object[])toArr, (String)CODE_SPLIT);
            String emailCc = StringUtils.join((Object[])ccArr, (String)CODE_SPLIT);
            ApisBusiEmailSendLog sendLog = new ApisBusiEmailSendLog(subjectTpl, contentTpl, emailTo, emailCc);
            log.warn("\u544a\u8b66\u53d1\u9001\u90ae\u4ef6\uff0c{}", (Object)JSON.toJSONString((Object)sendLog));
            this.emailSendLogMapper.insert((Object)sendLog);
        }
    }

    private String templateReplace(String template, Map<String, Object> map) {
        String regEx = "((?<=\\{)(\\w+)(?=\\}))";
        Matcher matcher = Pattern.compile(regEx).matcher(template);
        while (matcher.find()) {
            String key = matcher.group();
            String value = map.get(key) != null ? map.get(key) + "" : "\u65e0";
            template = template.replaceAll("\\{" + key + "\\}", value);
        }
        return template;
    }
}

