/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.web;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.annotation.RequiredAuth;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.expection.NeedWarnException;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.hanlder.impl.ClaimWarnConvertHandler;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.hanlder.impl.MeiXinAuthHandler;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.hanlder.impl.MeiXinYqAuthHandler;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MeiXinRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxClaimSupplementRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimRegistMedia;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYkfClaimRegistRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYqClaimRegistRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MeiXinResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MxClaimRegistResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MxYqClaimRegistResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.ChannelUserConfigUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.MxClaimRegistBusinessUtil;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMaterial;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimMedia;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxClaimRegist;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxVoucherMedicine;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimMaterialService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxClaimRegistService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxNewOrderService;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/TGW"})
public class MxClaimController {
    private static final Logger log = LoggerFactory.getLogger(MxClaimController.class);
    @Autowired
    ApisBusiMxClaimRegistService apisBusiMxClaimRegistService;
    @Autowired
    MxClaimRegistBusinessUtil mxClaimRegistBusinessUtil;
    @Autowired
    ApisBusiMxClaimMaterialService apisBusiMxClaimMaterialService;
    @Autowired
    ApisBusiMxNewOrderService apisBusiMxNewOrderService;
    @Autowired
    ChannelUserConfigUtil channelUserConfigUtil;

    @PostMapping(value={"/MX-YkfClaimRegist"})
    @RequiredAuth(authHandler=MeiXinAuthHandler.class)
    public MeiXinResponse<MxClaimRegistResponse> claimRegist(@Validated @RequestBody MeiXinRequest<MxYkfClaimRegistRequest> request) throws NeedWarnException {
        MxClaimRegistResponse response;
        ApisBusiMxClaimRegist regist = new ApisBusiMxClaimRegist();
        boolean success = false;
        try {
            MeiXinResponse mediaResponse;
            MeiXinResponse meiXinResponse = this.mxClaimRegistBusinessUtil.checkIdempotent(request.getRequestId(), (MxYkfClaimRegistRequest)request.getRequestData());
            if (ObjectUtils.isNotEmpty((Object)meiXinResponse)) {
                MeiXinResponse meiXinResponse2 = meiXinResponse;
                return meiXinResponse2;
            }
            if (ObjectUtils.isNotEmpty((Object)request.getRequestData()) && ObjectUtils.isNotEmpty((Object)((MxYkfClaimRegistRequest)request.getRequestData()).getMediaList()) && ObjectUtils.isNotEmpty((Object)(mediaResponse = this.mxClaimRegistBusinessUtil.checkMediaSize(((MxYkfClaimRegistRequest)request.getRequestData()).getMediaList())))) {
                MeiXinResponse meiXinResponse3 = mediaResponse;
                return meiXinResponse3;
            }
            MxYkfClaimRegistRequest requestData = (MxYkfClaimRegistRequest)request.getRequestData();
            BeanUtil.copyProperties(request, (Object)regist, (String[])new String[0]);
            BeanUtil.copyProperties((Object)requestData, (Object)regist, (String[])new String[0]);
            regist.setAppClaimAmount(new BigDecimal(requestData.getAppClaimAmount()));
            regist.setPremium(new BigDecimal(requestData.getPremium()));
            regist.setProjectCode("YKF");
            regist.setReportPhone(requestData.getPhoneNo());
            List mediaList = requestData.getMediaList().stream().map(e -> {
                ApisBusiMxClaimMedia media = new ApisBusiMxClaimMedia();
                BeanUtil.copyProperties((Object)e, (Object)media, (String[])new String[0]);
                media.setRequestId(request.getRequestId());
                media.setSource("REGIST");
                media.setMxReportNo(requestData.getMxReportNo());
                return media;
            }).collect(Collectors.toList());
            List medicineList = null;
            String mxContractNo = this.apisBusiMxNewOrderService.getMxContractNo(requestData.getContractNo());
            if (this.channelUserConfigUtil.isNewYkfOfCategory1(requestData.getOrderNo())) {
                medicineList = requestData.getMedicineList().stream().map(m -> {
                    ApisBusiMxVoucherMedicine medicine = new ApisBusiMxVoucherMedicine();
                    medicine.setRequestId(request.getRequestId());
                    medicine.setMxContractNo(mxContractNo);
                    medicine.setMxPolicyNo(requestData.getMxPolicyNo());
                    medicine.setMxReportNo(requestData.getMxReportNo());
                    medicine.setSource("REGIST");
                    medicine.setStoreCode(m.getStoreCode());
                    medicine.setStoreName(m.getStoreName());
                    medicine.setMedicineCode(m.getMedicineCode());
                    medicine.setMedicineName(m.getMedicineName());
                    medicine.setMedicineFee(BigDecimal.valueOf(m.getMedicineFee().intValue()));
                    medicine.setMedicineUnits(m.getMedicineUnits());
                    medicine.setProjectCode("YKF");
                    return medicine;
                }).collect(Collectors.toList());
            }
            success = this.mxClaimRegistBusinessUtil.generateAndSave(regist, mediaList, medicineList);
        }
        catch (Exception e2) {
            log.error("\u9541\u4fe1-\u836f\u5eb7\u4ed8-\u7406\u8d54\u7acb\u6848\u5f02\u5e38: ", (Throwable)e2);
            regist.setResultCode(AnalysisErrorCodeEnum.ERR_B110001.getKey());
            regist.setResultMsg(AnalysisErrorCodeEnum.ERR_B110001.getValue());
            throw new NeedWarnException(request.getRequestData(), ClaimWarnConvertHandler.class, (ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        finally {
            this.apisBusiMxClaimRegistService.updateResult(regist);
            MxClaimRegistResponse response2 = MxClaimRegistResponse.builder().mxReportNo(regist.getMxReportNo()).registNo(regist.getRegistNo()).build();
        }
        return success ? MeiXinResponse.success((Object)response) : MeiXinResponse.fail();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/MX-ClaimSupplement"})
    @RequiredAuth(authHandler=MeiXinYqAuthHandler.class)
    public MeiXinResponse<?> claimSupplement(@Validated @RequestBody MeiXinRequest<MxClaimSupplementRequest> request) {
        ApisBusiMxClaimMaterial busiMxClaimMaterial = this.apisBusiMxClaimMaterialService.getMxClaimMaterial(request.getRequestId());
        if (ObjectUtil.isNotEmpty((Object)busiMxClaimMaterial)) {
            return MeiXinResponse.success(null);
        }
        MeiXinResponse meiXinResponse = MeiXinResponse.fail();
        ApisBusiMxClaimMaterial apisBusiMxClaimMaterial = new ApisBusiMxClaimMaterial();
        try {
            BeanUtil.copyProperties((Object)request.getRequestData(), (Object)apisBusiMxClaimMaterial, (String[])new String[0]);
            apisBusiMxClaimMaterial.setRegistNo(((MxClaimSupplementRequest)request.getRequestData()).getReportNo());
            apisBusiMxClaimMaterial.setResponseTime(LocalDateTime.now());
            apisBusiMxClaimMaterial.setRequestType(request.getRequestType());
            apisBusiMxClaimMaterial.setRequestId(request.getRequestId());
            apisBusiMxClaimMaterial.setRequestTime(DateUtil.parseLocalDateTime((CharSequence)request.getRequestTime(), (String)"yyyyMMddHHmmss"));
            apisBusiMxClaimMaterial.setCompanyId(request.getCompanyId());
            ArrayList<ApisBusiMxClaimMedia> mediaList = new ArrayList<ApisBusiMxClaimMedia>();
            for (MxYkfClaimRegistMedia media : ((MxClaimSupplementRequest)request.getRequestData()).getMediaList()) {
                ApisBusiMxClaimMedia apisBusiMxClaimMedia = new ApisBusiMxClaimMedia();
                BeanUtil.copyProperties((Object)media, (Object)apisBusiMxClaimMedia, (String[])new String[0]);
                apisBusiMxClaimMedia.setSource("UPLOAD");
                mediaList.add(apisBusiMxClaimMedia);
            }
            boolean success = this.apisBusiMxClaimMaterialService.saveClaimSupplement(apisBusiMxClaimMaterial, mediaList);
            if (success) {
                meiXinResponse = MeiXinResponse.success(null);
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1\u7406\u8d54\u8d44\u6599\u8865\u5145\u51fa\u9519", (Throwable)e);
        }
        finally {
            apisBusiMxClaimMaterial.setResultCode(meiXinResponse.getResultCode());
            apisBusiMxClaimMaterial.setResultMsg(meiXinResponse.getResultMsg());
            this.apisBusiMxClaimMaterialService.updateResult(apisBusiMxClaimMaterial);
        }
        return meiXinResponse;
    }

    @PostMapping(value={"/MX-YQClaimRegist"})
    @RequiredAuth(authHandler=MeiXinYqAuthHandler.class)
    public MeiXinResponse<MxYqClaimRegistResponse> yqClaimRegist(@Validated @RequestBody MeiXinRequest<MxYqClaimRegistRequest> request) throws NeedWarnException {
        MxYqClaimRegistResponse response;
        ApisBusiMxClaimRegist regist = new ApisBusiMxClaimRegist();
        boolean success = false;
        try {
            MeiXinResponse meiXinResponse = this.mxClaimRegistBusinessUtil.checkIdempotent(request.getRequestId(), (MxYqClaimRegistRequest)request.getRequestData());
            if (ObjectUtils.isNotEmpty((Object)meiXinResponse)) {
                MeiXinResponse meiXinResponse2 = meiXinResponse;
                return meiXinResponse2;
            }
            MxYqClaimRegistRequest requestData = (MxYqClaimRegistRequest)request.getRequestData();
            BeanUtil.copyProperties(request, (Object)regist, (String[])new String[0]);
            BeanUtil.copyProperties((Object)requestData, (Object)regist, (String[])new String[0]);
            BeanUtil.copyProperties((Object)requestData.getPayeeInfo(), (Object)regist, (String[])new String[0]);
            regist.setAppClaimAmount(new BigDecimal(requestData.getAppClaimAmount()));
            regist.setProjectCode("YQ");
            regist.setReportPhone(requestData.getPhoneNo());
            regist.setCaseDetils(requestData.getCaseDetails());
            regist.setReportTime(DateUtil.parseLocalDateTime((CharSequence)requestData.getAppClaimTime(), (String)"yyyyMMddHHmmss"));
            success = this.mxClaimRegistBusinessUtil.generateAndSave(regist, null, null);
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1-\u836f\u4f01-\u7406\u8d54\u7acb\u6848\u5f02\u5e38: ", (Throwable)e);
            regist.setResultCode(AnalysisErrorCodeEnum.ERR_B110001.getKey());
            regist.setResultMsg(AnalysisErrorCodeEnum.ERR_B110001.getValue());
            throw new NeedWarnException(request.getRequestData(), ClaimWarnConvertHandler.class, (ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        finally {
            this.apisBusiMxClaimRegistService.updateResult(regist);
            MxYqClaimRegistResponse response2 = MxYqClaimRegistResponse.builder().mxReportNo(regist.getMxReportNo()).reportNo(regist.getRegistNo()).build();
        }
        return success ? MeiXinResponse.success((Object)response) : MeiXinResponse.fail();
    }
}

