/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.web;

import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.annotation.RequiredAuth;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.hanlder.impl.MeiXinAuthHandler;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.hanlder.impl.MeiXinYqAuthHandler;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MXSubInsuredOrderRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MeiXinRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxAddInsuredAmountRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxAddInsuredOrderRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxCreateGroupOrderRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxSubInsuredAmountRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxYqAddInsuredOrderRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MeiXinResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MxAddSumInsuredResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MxCommonInsureResponse;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.util.MxInsureBusinessUtil;
import com.jdaz.sinosoftgz.apis.constants.AnalysisErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/TGW"})
public class MxInsureController {
    private static final Logger log = LoggerFactory.getLogger(MxInsureController.class);
    @Autowired
    private MxInsureBusinessUtil mxInsureBusinessUtil;

    @PostMapping(value={"/MX-CreateGroupOrder"})
    @RequiredAuth(authHandler=MeiXinAuthHandler.class)
    public MeiXinResponse<MxCommonInsureResponse> createGroupOrder(@Validated @RequestBody MeiXinRequest<MxCreateGroupOrderRequest> request) {
        MeiXinResponse resp = null;
        try {
            TimeInterval timeInterval = new TimeInterval();
            MxCommonInsureResponse mxCommonInsureResponse = this.mxInsureBusinessUtil.judgeIsRepeatRequest(request);
            log.warn("\u9541\u4fe1\u521b\u5efa\u56e2\u5355\u5e42\u7b49\u6027\u6821\u9a8c\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
            if (ObjectUtil.isNotEmpty((Object)mxCommonInsureResponse)) {
                resp = MeiXinResponse.success((Object)mxCommonInsureResponse);
            } else {
                resp = this.mxInsureBusinessUtil.verifyCreateGroupOrderRequest(request);
                log.warn("\u9541\u4fe1\u521b\u5efa\u56e2\u5355\u6821\u9a8c\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                if (ObjectUtil.isEmpty((Object)resp)) {
                    mxCommonInsureResponse = this.mxInsureBusinessUtil.executeCreateGroupOrder(request);
                    if (ObjectUtil.isNotEmpty((Object)mxCommonInsureResponse)) {
                        resp = MeiXinResponse.success((Object)mxCommonInsureResponse);
                        LocalDateTime responseTime = LocalDateTime.now();
                        timeInterval.intervalRestart();
                        this.mxInsureBusinessUtil.saveMxCreateGroupOrder(request, resp, responseTime);
                        log.warn("\u9541\u4fe1\u521b\u5efa\u56e2\u5355\u4fdd\u5b58\u6570\u636e\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                    } else {
                        resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1\u8c03\u7528\u521b\u5efa\u56e2\u5355\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        return resp;
    }

    @PostMapping(value={"/MX-AddInsuredOrder"})
    @RequiredAuth(authHandler=MeiXinAuthHandler.class)
    public MeiXinResponse<MxCommonInsureResponse> addInsuredOrder(@Validated @RequestBody MeiXinRequest<MxAddInsuredOrderRequest> request) {
        MeiXinResponse resp = null;
        try {
            TimeInterval timeInterval = new TimeInterval();
            MxCommonInsureResponse mxCommonInsureResponse = this.mxInsureBusinessUtil.judgeAddInsuredOrderIsRepeatRequest(request);
            log.warn("\u9541\u4fe1\u6279\u589e\u88ab\u4fdd\u4eba\u5e42\u7b49\u6027\u6821\u9a8c\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
            if (ObjectUtil.isNotEmpty((Object)mxCommonInsureResponse)) {
                resp = MeiXinResponse.success((Object)mxCommonInsureResponse);
            } else {
                resp = this.mxInsureBusinessUtil.verifyAddInsuredOrderRequest(request);
                log.warn("\u9541\u4fe1\u6279\u589e\u88ab\u4fdd\u4eba\u6821\u9a8c\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                if (ObjectUtil.isEmpty((Object)resp)) {
                    mxCommonInsureResponse = this.mxInsureBusinessUtil.executeAddInsuredOrder(request);
                    if (ObjectUtil.isNotEmpty((Object)mxCommonInsureResponse)) {
                        resp = MeiXinResponse.success((Object)mxCommonInsureResponse);
                        LocalDateTime responseTime = LocalDateTime.now();
                        timeInterval.intervalRestart();
                        this.mxInsureBusinessUtil.saveMxAddInsuredOrder(request, resp, responseTime);
                        log.warn("\u9541\u4fe1\u6279\u589e\u88ab\u4fdd\u4eba\u4fdd\u5b58\u6570\u636e\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                    } else {
                        resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1\u8c03\u7528\u6279\u589e\u88ab\u4fdd\u4eba\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        return resp;
    }

    @PostMapping(value={"/MX-AddSumInsuredOrder"})
    @RequiredAuth(authHandler=MeiXinAuthHandler.class)
    public MeiXinResponse<MxAddSumInsuredResponse> addSumInsuredOrder(@Validated @RequestBody MeiXinRequest<MxAddInsuredAmountRequest> request) {
        MeiXinResponse resp = null;
        try {
            TimeInterval timeInterval = new TimeInterval();
            MxAddSumInsuredResponse mxAddSumInsuredResponse = this.mxInsureBusinessUtil.judgeAddSumInsuredOrderIsRepeatRequest(request);
            log.warn("\u9541\u4fe1\u6279\u589e\u4fdd\u989d\u5e42\u7b49\u6027\u6821\u9a8c\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
            if (ObjectUtil.isNotEmpty((Object)mxAddSumInsuredResponse)) {
                resp = MeiXinResponse.success((Object)mxAddSumInsuredResponse);
            } else {
                resp = this.mxInsureBusinessUtil.verifyAddSumInsuredOrderRequest(request);
                log.warn("\u9541\u4fe1\u6279\u589e\u4fdd\u989d\u6821\u9a8c\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                if (ObjectUtil.isEmpty((Object)resp)) {
                    mxAddSumInsuredResponse = this.mxInsureBusinessUtil.executeAddSumInsuredOrder(request);
                    if (ObjectUtil.isNotEmpty((Object)mxAddSumInsuredResponse)) {
                        resp = MeiXinResponse.success((Object)mxAddSumInsuredResponse);
                        LocalDateTime responseTime = LocalDateTime.now();
                        timeInterval.intervalRestart();
                        this.mxInsureBusinessUtil.saveMxAddSumInsuredOrder(request, resp, responseTime);
                        log.warn("\u9541\u4fe1\u6279\u589e\u4fdd\u989d\u4fdd\u5b58\u6570\u636e\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                    } else {
                        resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1\u8c03\u7528\u6279\u589e\u4fdd\u989d\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        return resp;
    }

    @PostMapping(value={"/MX-YQAddInsuredOrder"})
    @RequiredAuth(authHandler=MeiXinYqAuthHandler.class)
    public MeiXinResponse<MxCommonInsureResponse> yqAddInsuredOrder(@Validated @RequestBody MeiXinRequest<MxYqAddInsuredOrderRequest> request) {
        MeiXinResponse resp = null;
        try {
            TimeInterval timeInterval = new TimeInterval();
            MxCommonInsureResponse mxCommonInsureResponse = this.mxInsureBusinessUtil.judgeYqAddInsuredOrderIsRepeatRequest(request);
            log.warn("\u836f\u4f01\u6279\u589e\u88ab\u4fdd\u4eba\u5e42\u7b49\u6027\u6821\u9a8c\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
            if (ObjectUtil.isNotEmpty((Object)mxCommonInsureResponse)) {
                resp = MeiXinResponse.success((Object)mxCommonInsureResponse);
            } else {
                resp = this.mxInsureBusinessUtil.verifyYqAddInsuredOrderRequest(request);
                log.warn("\u836f\u4f01\u6279\u589e\u88ab\u4fdd\u4eba\u6821\u9a8c\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                if (ObjectUtil.isEmpty((Object)resp)) {
                    mxCommonInsureResponse = this.mxInsureBusinessUtil.executeYqAddInsuredOrder(request);
                    if (ObjectUtil.isNotEmpty((Object)mxCommonInsureResponse)) {
                        resp = MeiXinResponse.success((Object)mxCommonInsureResponse);
                        LocalDateTime responseTime = LocalDateTime.now();
                        timeInterval.intervalRestart();
                        this.mxInsureBusinessUtil.saveMxYqAddInsuredOrder(request, resp, responseTime);
                        log.warn("\u836f\u4f01\u6279\u589e\u88ab\u4fdd\u4eba\u4fdd\u5b58\u6570\u636e\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                    } else {
                        resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1\u836f\u4f01\u8c03\u7528\u521b\u5efa\u56e2\u5355\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        return resp;
    }

    @PostMapping(value={"/MX-SubInsuredOrder"})
    @RequiredAuth(authHandler=MeiXinAuthHandler.class)
    public MeiXinResponse<Object> mxSubInsuredOrder(@Validated @RequestBody MeiXinRequest<MXSubInsuredOrderRequest> request) {
        MeiXinResponse resp = null;
        try {
            TimeInterval timeInterval = new TimeInterval();
            Object mxSubInsuredResponse = this.mxInsureBusinessUtil.judgeSubInsuredOrderIsRepeatRequest(request);
            log.warn("\u9541\u4fe1\u836f\u5eb7\u4ed8\u6279\u51cf\u88ab\u4fdd\u4eba\u5e42\u7b49\u6027\u6821\u9a8c\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
            if (ObjectUtil.isNotEmpty((Object)mxSubInsuredResponse)) {
                resp = MeiXinResponse.success((Object)mxSubInsuredResponse);
            } else {
                resp = this.mxInsureBusinessUtil.verifyMxSubInsuredOrderRequest(request);
                log.warn("\u9541\u4fe1\u836f\u5eb7\u4ed8\u6279\u51cf\u88ab\u4fdd\u4eba\u6821\u9a8c\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                if (ObjectUtil.isEmpty((Object)resp)) {
                    resp = MeiXinResponse.success((Object)new Object());
                    LocalDateTime responseTime = LocalDateTime.now();
                    timeInterval.intervalRestart();
                    this.mxInsureBusinessUtil.saveMxSubInsuredOrder(request, resp, responseTime);
                    log.warn("\u9541\u4fe1\u836f\u5eb7\u4ed8\u6279\u51cf\u88ab\u4fdd\u4eba\u4fdd\u5b58\u6570\u636e\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                }
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1\u836f\u5eb7\u4ed8\u8c03\u7528\u6279\u51cf\u88ab\u4fdd\u4eba\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        return resp;
    }

    @PostMapping(value={"/MX-SubSumInsuredOrder"})
    @RequiredAuth(authHandler=MeiXinAuthHandler.class)
    public MeiXinResponse<Object> subSumInsuredOrder(@Validated @RequestBody MeiXinRequest<MxSubInsuredAmountRequest> request) {
        MeiXinResponse resp = null;
        try {
            TimeInterval timeInterval = new TimeInterval();
            Object mxSubSumInsuredResponse = this.mxInsureBusinessUtil.judgeSubSumInsuredOrderIsRepeatRequest(request);
            log.warn("\u9541\u4fe1\u836f\u5eb7\u4ed8\u6279\u51cf\u4fdd\u989d\u5e42\u7b49\u6027\u6821\u9a8c\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
            if (ObjectUtil.isNotEmpty((Object)mxSubSumInsuredResponse)) {
                resp = MeiXinResponse.success((Object)mxSubSumInsuredResponse);
            } else {
                resp = this.mxInsureBusinessUtil.verifyMxSubSumInsuredOrderRequest(request);
                log.warn("\u9541\u4fe1\u836f\u5eb7\u4ed8\u6279\u51cf\u4fdd\u989d\u6821\u9a8c\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                if (ObjectUtil.isEmpty((Object)resp)) {
                    resp = MeiXinResponse.success((Object)new Object());
                    LocalDateTime responseTime = LocalDateTime.now();
                    timeInterval.intervalRestart();
                    this.mxInsureBusinessUtil.saveMxSubSumInsuredOrder(request, resp, responseTime);
                    log.warn("\u9541\u4fe1\u836f\u5eb7\u4ed8\u6279\u51cf\u4fdd\u989d\u4fdd\u5b58\u6570\u636e\u603b\u7528\u65f6\uff1a{}", (Object)timeInterval.intervalRestart());
                }
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1\u836f\u5eb7\u4ed8\u8c03\u7528\u6279\u51cf\u4fdd\u989d\u63a5\u53e3\u51fa\u9519,", (Throwable)e);
            resp = MeiXinResponse.fail((ErrorCode)AnalysisErrorCodeEnum.ERR_B110001);
        }
        return resp;
    }
}

