/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.analysisapp.web;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.StrUtil;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.annotation.RequiredAuth;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.hanlder.impl.MeiXinAuthHandler;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.push.core.MxTransferNoticePushService;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MeiXinRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxTransferNoticeOrder;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.MxTransferNoticeRequest;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.req.ThirdpBillCheckTaskInfo;
import com.jdaz.sinosoftgz.apis.business.app.analysisapp.rest.resp.MeiXinResponse;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxTransferNotice;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.entity.ApisBusiMxTransferNoticeOrder;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxTransferNoticeOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.analysis.service.ApisBusiMxTransferNoticeService;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/TGW"})
@RestController
public class MxTransferNoticeController {
    private static final Logger log = LoggerFactory.getLogger(MxTransferNoticeController.class);
    @Autowired
    private ApisBusiMxTransferNoticeService apisBusiMxTransferNoticeService;
    @Autowired
    private ApisBusiMxTransferNoticeOrderService apisBusiMxTransferNoticeOrderService;
    @Autowired
    MxTransferNoticePushService mxTransferNoticePushService;
    @Autowired
    RedisTemplate redisTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/MX-TransferNotice"})
    @RequiredAuth(authHandler=MeiXinAuthHandler.class)
    public MeiXinResponse<?> transferNotice(@Validated @RequestBody MeiXinRequest<MxTransferNoticeRequest> request) {
        TimeInterval timer = DateUtil.timer();
        MeiXinResponse meiXinResponse = MeiXinResponse.fail();
        if (!this.lock(((MxTransferNoticeRequest)request.getRequestData()).getTransactionNo()) || !this.lock(request.getRequestId())) {
            return MeiXinResponse.fail((String)"\u7cfb\u7edf\u5fd9\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        int notice = this.apisBusiMxTransferNoticeService.checkIdempotent(((MxTransferNoticeRequest)request.getRequestData()).getTransactionNo(), request.getRequestId());
        log.warn("\u63a5\u53e3 TransferNotice \u5e42\u7b49\u6027\u6821\u9a8c\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
        if (notice > 0) {
            this.redisTemplate.delete((Object)((MxTransferNoticeRequest)request.getRequestData()).getTransactionNo());
            this.redisTemplate.delete((Object)request.getRequestId());
            return MeiXinResponse.success(null);
        }
        ApisBusiMxTransferNotice apisBusiMxTransferNotice = new ApisBusiMxTransferNotice();
        BeanUtil.copyProperties((Object)request.getRequestData(), (Object)apisBusiMxTransferNotice, (String[])new String[0]);
        apisBusiMxTransferNotice.setResponseTime(LocalDateTime.now());
        apisBusiMxTransferNotice.setRequestType(request.getRequestType());
        apisBusiMxTransferNotice.setRequestId(request.getRequestId());
        apisBusiMxTransferNotice.setRequestTime(DateUtil.parseLocalDateTime((CharSequence)request.getRequestTime(), (String)"yyyyMMddHHmmss"));
        apisBusiMxTransferNotice.setCompanyId(request.getCompanyId());
        ArrayList<ApisBusiMxTransferNoticeOrder> orderList = new ArrayList<ApisBusiMxTransferNoticeOrder>();
        for (MxTransferNoticeOrder order : ((MxTransferNoticeRequest)request.getRequestData()).getOrderList()) {
            ApisBusiMxTransferNoticeOrder apisBusiMxTransferNoticeOrder = new ApisBusiMxTransferNoticeOrder();
            BeanUtil.copyProperties((Object)order, (Object)apisBusiMxTransferNoticeOrder, (String[])new String[0]);
            orderList.add(apisBusiMxTransferNoticeOrder);
        }
        String orderNo = this.apisBusiMxTransferNoticeOrderService.judgeIsHasOrder(orderList);
        log.warn("\u63a5\u53e3 TransferNotice \u5224\u65ad\u8ba2\u5355\u662f\u5426\u5df2\u7ecf\u5b58\u5728\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
        if (StrUtil.isNotEmpty((CharSequence)orderNo)) {
            this.redisTemplate.delete((Object)((MxTransferNoticeRequest)request.getRequestData()).getTransactionNo());
            this.redisTemplate.delete((Object)request.getRequestId());
            return MeiXinResponse.fail((String)("\u8ba2\u5355\u53f7\u3010" + orderNo + "\u3011\u5df2\u5b58\u5728"));
        }
        String[] insuredOrderResult = this.apisBusiMxTransferNoticeService.judgeIsHasInsured(orderList);
        log.warn("\u63a5\u53e3 TransferNotice \u5224\u65ad\u8ba2\u5355\u88ab\u4fdd\u9669\u4eba\u662f\u5426\u5b58\u5728\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
        if ("0".equals(insuredOrderResult[0])) {
            this.redisTemplate.delete((Object)((MxTransferNoticeRequest)request.getRequestData()).getTransactionNo());
            this.redisTemplate.delete((Object)request.getRequestId());
            return MeiXinResponse.fail((String)("\u8ba2\u5355\u53f7\u3010" + insuredOrderResult[1] + "\u3011\u6ca1\u6709\u5bf9\u5e94\u7684\u88ab\u4fdd\u9669\u4eba\u8bb0\u5f55"));
        }
        try {
            boolean success = this.apisBusiMxTransferNoticeService.saveTransferNotice(apisBusiMxTransferNotice, orderList);
            log.warn("\u63a5\u53e3 TransferNotice \u4fdd\u5b58\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
            if (success) {
                meiXinResponse = MeiXinResponse.success(null);
            }
        }
        catch (Exception e) {
            log.error("\u9541\u4fe1\u4fdd\u5b58\u8f6c\u8d26\u7ed3\u679c\u901a\u77e5\u51fa\u9519\uff1a{}", (Throwable)e);
        }
        finally {
            apisBusiMxTransferNotice.setResultCode(meiXinResponse.getResultCode());
            apisBusiMxTransferNotice.setResultMsg(meiXinResponse.getResultMsg());
            this.apisBusiMxTransferNoticeService.updateResult(apisBusiMxTransferNotice);
            log.warn("\u63a5\u53e3 TransferNotice \u66f4\u65b0\u7ed3\u679c\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
            this.redisTemplate.delete((Object)((MxTransferNoticeRequest)request.getRequestData()).getTransactionNo());
            this.redisTemplate.delete((Object)request.getRequestId());
        }
        return meiXinResponse;
    }

    @RequestMapping(value={"/MX-BillsCheck"})
    public MeiXinResponse<?> billsCheck(@RequestBody ThirdpBillCheckTaskInfo thirdpBillCheckTaskInfo) {
        MeiXinResponse meiXinResponse = MeiXinResponse.success(null);
        try {
            this.mxTransferNoticePushService.billsCheck((Date)DateUtil.parse((CharSequence)thirdpBillCheckTaskInfo.getCheckBeginTime()), (Date)DateUtil.parse((CharSequence)thirdpBillCheckTaskInfo.getCheckEndTime()));
        }
        catch (Exception e) {
            meiXinResponse = MeiXinResponse.fail((String)e.getLocalizedMessage());
        }
        return meiXinResponse;
    }

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 1L, TimeUnit.MINUTES);
    }
}

