/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.aop;

import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.AuthException;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.BaseCodeConvertUtils;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.JDAZAesUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderPacket;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorCode;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class JDAZAesAspect {
    private static final Logger log = LoggerFactory.getLogger(JDAZAesAspect.class);
    @Autowired
    private HttpServletRequest request;
    @Autowired
    BaseCodeConvertUtils baseCodeConvertUtils;

    @Pointcut(value="@annotation(com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.aop.JDAZAesAnnotation)")
    public void controllerAspect() {
    }

    @Around(value="controllerAspect()")
    public Object doAround(ProceedingJoinPoint joinPoint) throws Throwable {
        log.warn("=====JDAZAesAspect AOP \u5f00\u59cb=====");
        StanderPacket standerPacketInput = (StanderPacket)JSON.parseObject((String)IoUtil.read((InputStream)this.request.getInputStream(), (String)"UTF-8"), StanderPacket.class);
        if (ObjectUtil.isEmpty((Object)standerPacketInput)) {
            throw new AuthException((ErrorCode)ChannelErrorCodeEnum.ERR_C10738);
        }
        String userCode = standerPacketInput.getUserCode();
        if (ObjectUtil.isEmpty((Object)userCode)) {
            throw new AuthException((ErrorCode)ChannelErrorCodeEnum.ERR_C10739);
        }
        Map userMap = this.baseCodeConvertUtils.getCodeData("channel:user:" + userCode);
        if (ObjectUtil.isEmpty(userMap.get("pwd"))) {
            throw new AuthException((ErrorCode)ChannelErrorCodeEnum.ERR_C10740);
        }
        String publicKey = userMap.get("pwd").toString();
        String seed = JDAZAesUtils.des3EncodeCbc((String)userCode, (String)publicKey);
        String inputContent = null;
        try {
            inputContent = JDAZAesUtils.decryptBase64((String)seed, (String)standerPacketInput.getContent());
        }
        catch (Exception e) {
            throw new AuthException((ErrorCode)ChannelErrorCodeEnum.ERR_C10738);
        }
        StanderPacket standerPacketReq = (StanderPacket)JSON.parseObject((String)inputContent, StanderPacket.class);
        if (ObjectUtil.isEmpty((Object)standerPacketReq)) {
            throw new AuthException((ErrorCode)ChannelErrorCodeEnum.ERR_C10738);
        }
        if (ObjectUtil.isEmpty((Object)standerPacketReq.getHead()) || !userCode.equals(standerPacketReq.getHead().getUserCode())) {
            throw new AuthException((ErrorCode)ChannelErrorCodeEnum.ERR_C10739);
        }
        Object obj = joinPoint.proceed(new Object[]{standerPacketReq});
        StanderPacket standerPacketRes = null;
        if (obj instanceof StanderPacket) {
            standerPacketRes = (StanderPacket)obj;
        }
        StanderPacket standerPacketOutput = StanderPacket.builder().userCode(userCode).content(JDAZAesUtils.encryptBase64((String)seed, (String)JSON.toJSONString((Object)standerPacketRes))).build();
        log.warn("=====JDAZAesAspect AOP \u7ed3\u675f=====");
        return standerPacketOutput;
    }

    private StanderPacket returnError(String userCode, String seed, ErrorCode errorCode, String requestId, String requestType) {
        StanderHead standerHead = StanderHead.builder().requestId(requestId).requestType(requestType).responseCode("0").errorCode(errorCode.getKey()).errorMessage(errorCode.getValue()).build();
        StanderPacket standerPacket = StanderPacket.builder().head(standerHead).build();
        StanderPacket standerPacketOutput = StanderPacket.builder().userCode(userCode).content(JDAZAesUtils.encryptBase64((String)seed, (String)JSON.toJSONString((Object)standerPacket))).build();
        return standerPacketOutput;
    }
}

