/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.handler;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.HexUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.BusinessNoUtil;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.CalculateUtil;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.DataConversionUtil;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.asynInsure.request.Insured;
import com.jdaz.sinosoftgz.apis.commons.model.api.asynInsure.request.Policy;
import com.jdaz.sinosoftgz.apis.commons.model.api.asynInsure.request.PolicyHolder;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderBody;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderPacket;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredPremiumDTO;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.entity.ApisBusiAsyncChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.entity.ApisBusiAsyncChannelOrderIns;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.entity.ApisBusiAsyncChannelOrderPh;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.entity.ApisBusiAsyncTaskLog;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncChannelOrderInsService;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncChannelOrderPhService;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncTaskLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiReqmsgLogService;
import com.jdaz.sinosoftgz.apis.constants.ApisAutoTaskConstantsEnum;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class StanderDdQuotePriceHandler {
    private static final Logger log = LoggerFactory.getLogger(StanderDdQuotePriceHandler.class);
    @Autowired
    DataConversionUtil dataConversionUtil;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    CalculateUtil calculateUtil;
    @Autowired
    QuotePriceValidate quotePriceValidate;
    @Autowired
    ApisBusiAsyncChannelOrderService apisBusiAsyncChannelOrderService;
    @Autowired
    ApisBusiAsyncChannelOrderPhService apisBusiAsyncChannelOrderPhService;
    @Autowired
    ApisBusiAsyncChannelOrderInsService apisBusiAsyncChannelOrderInsService;
    @Autowired
    ApisBusiAsyncTaskLogService apisBusiAsyncTaskLogService;
    @Autowired
    BusinessNoUtil businessNoUtil;
    @Autowired
    ApisBusiReqmsgLogService apisBusiReqmsgLogService;
    @Value(value="${apis.coreapi.serv.accidentHealthIssueService.url}")
    private String accidentHealthIssueServiceUrl;
    @Value(value="${ePolicy.interface.downPolicyByPolicyNo}")
    private String executeUrl;

    public StanderPacket policyConfirm(StanderPacket standerPacket) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        StanderPacket packet = this.quotePriceValidate.checkIdempotent(standerPacket);
        log.warn("\u8fbe\u8fbe\u4e0b\u5355\u5e42\u7b49\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        if (ObjectUtil.isNotEmpty((Object)packet)) {
            return packet;
        }
        this.quotePriceValidate.verifyRepeatRequest(standerPacket);
        StanderRequest request = this.dataConversionUtil.dataConversion(standerPacket);
        log.warn("\u8fbe\u8fbe\u4e0b\u5355\u6570\u636e\u8f6c\u6362\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionUtil.dataCompletion(request);
        log.warn("\u8fbe\u8fbe\u4e0b\u5355\u6570\u636e\u8865\u5168\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.quotePriceValidate.validateRequest(request);
        log.warn("\u8fbe\u8fbe\u4e0b\u5355\u6570\u636e\u6821\u9a8c\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.calculateUtil.calculateTotalPremium(request);
        log.warn("\u8fbe\u8fbe\u4e0b\u5355\u4fdd\u8d39\u8ba1\u7b97\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        standerPacket = this.buildResponse(standerPacket, request);
        log.warn("\u8fbe\u8fbe\u4e0b\u5355\u5c01\u88c5\u8fd4\u56de\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.saveBusinessData(standerPacket, request);
        log.warn("\u8fbe\u8fbe\u4e0b\u5355\u4fdd\u5b58\u4e1a\u52a1\u6570\u636e\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.quotePriceValidate.unLock(standerPacket);
        return standerPacket;
    }

    private StanderPacket buildResponse(StanderPacket standerPacket, StanderRequest request) throws ApisBusinessException {
        StanderBody body = standerPacket.getBody();
        MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
        String comCode = mainDTO.getComCode();
        String riskCode = mainDTO.getRiskCode();
        String policyNo = this.businessNoUtil.getDdPolicyNo(comCode, riskCode);
        body.setPolicyRef(policyNo);
        body.setAgencyPolicyRef(body.getPolicy().getAgencyPolicyRef());
        body.setEffectiveDate(body.getPolicy().getEffectiveDate());
        body.setExpireDate(body.getPolicy().getExpireDate());
        body.setIssueDate(body.getPolicy().getIssueDate());
        body.setPolicyStatus("70");
        String ePolicyUrl = this.getPolicyDownUrl(policyNo);
        body.setEPolicyUrl(ePolicyUrl);
        body.setTotalPremium(new BigDecimal(mainDTO.getSumPremium()).setScale(2, 4));
        ArrayList<InsuredPremiumDTO> insuredPremiumList = new ArrayList<InsuredPremiumDTO>();
        List insuredDTOList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInsuredList();
        for (InsuredDTO insuredDTO : insuredDTOList) {
            InsuredPremiumDTO insuredPremiumDTO = InsuredPremiumDTO.builder().insuredId(insuredDTO.getInsuredId()).insuredName(insuredDTO.getInsuredName()).premium(insuredDTO.getPremium()).build();
            insuredPremiumList.add(insuredPremiumDTO);
        }
        body.setInsuredPremiumList(insuredPremiumList);
        standerPacket.getHead().setResponseCode("1");
        standerPacket.getHead().setErrorCode(ChannelErrorCodeEnum.ERR_C10002.getKey());
        standerPacket.getHead().setErrorMessage(ChannelErrorCodeEnum.ERR_C10002.getValue());
        return standerPacket;
    }

    private String getPolicyDownUrl(String policyNo) {
        String encryptHex = HexUtil.encodeHexStr((String)policyNo);
        String url = this.executeUrl + "/" + encryptHex;
        return url;
    }

    private void saveBusinessData(StanderPacket standerPacket, StanderRequest request) throws ApisBusinessException {
        try {
            ApisBusiAsyncChannelOrder apisBusiAsyncChannelOrder = new ApisBusiAsyncChannelOrder();
            Policy policy = standerPacket.getBody().getPolicy();
            BeanUtil.copyProperties((Object)policy, (Object)apisBusiAsyncChannelOrder, (String[])new String[0]);
            apisBusiAsyncChannelOrder.setStatus(standerPacket.getBody().getPolicyStatus());
            apisBusiAsyncChannelOrder.setEpolicyUrl(standerPacket.getBody().getEPolicyUrl());
            apisBusiAsyncChannelOrder.setConsumerSeqNo(request.getQuotePriceServiceRequest().getRequestHead().getConsumerSeqNo());
            this.apisBusiAsyncChannelOrderService.save((Object)apisBusiAsyncChannelOrder);
            PolicyHolder policyHolder = standerPacket.getBody().getPolicyHolder();
            ApisBusiAsyncChannelOrderPh apisBusiAsyncChannelOrderPh = new ApisBusiAsyncChannelOrderPh();
            BeanUtil.copyProperties((Object)policyHolder, (Object)apisBusiAsyncChannelOrderPh, (String[])new String[0]);
            apisBusiAsyncChannelOrderPh.setAgencyPolicyRef(policy.getAgencyPolicyRef());
            this.apisBusiAsyncChannelOrderPhService.save((Object)apisBusiAsyncChannelOrderPh);
            List insureds = standerPacket.getBody().getInsuredList();
            ArrayList<ApisBusiAsyncChannelOrderIns> apisBusiAsyncChannelOrderInsList = new ArrayList<ApisBusiAsyncChannelOrderIns>();
            for (Insured insured : insureds) {
                ApisBusiAsyncChannelOrderIns apisBusiAsyncChannelOrderIns = new ApisBusiAsyncChannelOrderIns();
                BeanUtil.copyProperties((Object)insured, (Object)apisBusiAsyncChannelOrderIns, (String[])new String[0]);
                apisBusiAsyncChannelOrderIns.setAgencyPolicyRef(policy.getAgencyPolicyRef());
                apisBusiAsyncChannelOrderInsList.add(apisBusiAsyncChannelOrderIns);
            }
            this.apisBusiAsyncChannelOrderInsService.saveBatch(apisBusiAsyncChannelOrderInsList);
            ApisBusiAsyncTaskLog asyncTaskLog = new ApisBusiAsyncTaskLog();
            asyncTaskLog.setPushStatus("0");
            asyncTaskLog.setPushStep(Integer.valueOf(0));
            asyncTaskLog.setBusinessKey(standerPacket.getBody().getPolicyRef());
            asyncTaskLog.setPushContent(JSON.toJSONString((Object)request.getQuotePriceServiceRequest()));
            asyncTaskLog.setPushType(ApisAutoTaskConstantsEnum.DD_POLICY_CONFIRM.getKey());
            asyncTaskLog.setPushTargetUrl(this.accidentHealthIssueServiceUrl);
            this.apisBusiAsyncTaskLogService.save((Object)asyncTaskLog);
        }
        catch (Exception e) {
            log.error("\u8fbe\u8fbe\u4e0b\u5355\u4fdd\u5b58\u6570\u636e\u51fa\u9519\uff0c{}", (Throwable)e);
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10006.getValue(), ChannelErrorCodeEnum.ERR_C10006.getKey());
        }
    }
}

