/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.DataCompletionUtil;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.resp.StanderResponse;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CalculateObjectDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyCalculateServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.PolicyCalculateServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.CalculateResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredPremiumDTO;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationClauseKindFactoryService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.RiskCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CalculateUtil {
    private static Logger log = LoggerFactory.getLogger(CalculateUtil.class);
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    DataCompletionUtil dataCompletionUtil;
    @Autowired
    private QuotePriceValidate quotePriceValidate;
    @Autowired
    ApisPfpRationClauseKindFactoryService apisPfpRationClauseKindFactoryService;

    public void calculateTotalPremium(StanderRequest request) throws ApisBusinessException {
        try {
            TimeInterval timer = DateUtil.timer();
            PolicyCalculateServiceRequest policyCalculateServiceRequest = PolicyCalculateServiceRequest.builder().build();
            policyCalculateServiceRequest.setRequestHead(RequestHeadDTO.initRequestHead());
            PolicyCalculateServiceRequestDTO policyCalculateServiceRequestDTO = PolicyCalculateServiceRequestDTO.builder().build();
            QuotePriceDTO quotePriceDTO = QuotePriceDTO.builder().build();
            BeanUtils.copyProperties((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice(), (Object)quotePriceDTO);
            quotePriceDTO.setPlanCode(((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getGoodsCode());
            policyCalculateServiceRequestDTO.setQuotePrice(quotePriceDTO);
            policyCalculateServiceRequest.setRequestBody(policyCalculateServiceRequestDTO);
            request.setPolicyCalculateServiceRequest(policyCalculateServiceRequest);
            StanderResponse standerResponse = this.calculate(request);
            timer.intervalRestart();
            TimeInterval timer1 = DateUtil.timer();
            if (ObjectUtil.isEmpty((Object)standerResponse)) {
                throw new ApisBusinessException(ErrorNullValueCodeEnum.ERR_N00002.getValue(), ErrorNullValueCodeEnum.ERR_N00002.getKey());
            }
            CalculateResponseDTO calculateResponseDTO = standerResponse.getCalculateResponse().getResponseBody();
            MainDTO mainDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain();
            if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getMain().getSumPremium())) {
                if (!new BigDecimal(quotePriceDTO.getMain().getSumPremium()).setScale(2, 4).equals(calculateResponseDTO.getTotalPremium())) {
                    log.error("\u4f20\u5165\u4fdd\u8d39\u4e0e\u8ba1\u7b97\u51fa\u7684\u4fdd\u8d39\u4e0d\u4e00\u81f4,\u8ba1\u7b97\u51fa\u7684\u4fdd\u8d39\uff1a{}", (Object)calculateResponseDTO.getTotalPremium());
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10199.getValue(), ChannelErrorCodeEnum.ERR_C10199.getKey());
                }
                quotePriceDTO.getMain().setSumPremium(calculateResponseDTO.getTotalPremium());
            } else {
                quotePriceDTO.getMain().setSumPremium(calculateResponseDTO.getTotalPremium());
            }
            if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getInsuredList())) {
                for (InsuredDTO insuredDTO : quotePriceDTO.getInsuredList()) {
                    for (InsuredPremiumDTO idvDTO : calculateResponseDTO.getInsuredPremiumList()) {
                        if (!insuredDTO.getInsuredId().equals(idvDTO.getSerialNo())) continue;
                        insuredDTO.setPremium(idvDTO.getPremium());
                        break;
                    }
                    insuredDTO.setInsuredType("1");
                }
            }
            timer1.intervalRestart();
            if (StringUtils.isNotEmpty((CharSequence)mainDTO.getCalcType())) {
                if ("9".equals(mainDTO.getCalcType())) {
                    mainDTO.setCalcType("1");
                } else {
                    mainDTO.setCalcType("2");
                }
            }
            log.warn("\u4fdd\u8d39\u8ba1\u7b97execute\u4e4b\u540e\u7528\u65f6\uff1a{}", (Object)timer.intervalRestart());
        }
        catch (ApisBusinessException e) {
            throw new ApisBusinessException(e.getMessage(), e.getErrorCode());
        }
    }

    public StanderResponse calculate(StanderRequest request) throws ApisBusinessException {
        long start = System.currentTimeMillis();
        List calList = this.assembleObjectBySingle(request);
        log.warn("\u4fdd\u8d39\u8ba1\u7b97-\u53c2\u6570\u7ec4\u88c5\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        StanderResponse standerResponse = this.coreInsureApi.policyCalculate(calList);
        log.warn("\u4fdd\u8d39\u8ba1\u7b97-\u603b\u7528\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - start));
        return standerResponse;
    }

    private List<CalculateObjectDTO> assembleObjectBySingle(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePrice = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice();
        RequestHeadDTO requestHead = request.getPolicyCalculateServiceRequest().getRequestHead();
        List insuredListReq = quotePrice.getInsuredList();
        this.quotePriceValidate.checkInsuredInfo(request);
        InsuredDTO insuredDTO = null;
        ArrayList<CalculateObjectDTO> calList = new ArrayList<CalculateObjectDTO>();
        Date startDate = quotePrice.getMain().getStartDate();
        Date endDate = quotePrice.getMain().getEndDate();
        int days = CalculateUtil.betweenDays((Date)startDate, (Date)endDate, (boolean)true);
        int index = 0;
        for (int i = 0; i < insuredListReq.size(); ++i) {
            int akIndex = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().size() > 1 ? index : 0;
            String goodsCode = ((ItemMainDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(akIndex)).getGoodsCode();
            String methodType = this.apisPfpRationClauseKindFactoryService.getCalculateMethod(goodsCode);
            insuredDTO = (InsuredDTO)insuredListReq.get(i);
            CalculateObjectDTO calculateObjectDTO = CalculateObjectDTO.builder().build();
            calculateObjectDTO.setConsumerSeqNo(requestHead.getConsumerSeqNo());
            calculateObjectDTO.setAgencyPolicyRef(quotePrice.getMain().getOrderNo());
            calculateObjectDTO.setInsuredIDCache(insuredDTO.getInsuredIDCache());
            calculateObjectDTO.setInsuredName(insuredDTO.getInsuredName());
            calculateObjectDTO.setCalMethod(methodType);
            calculateObjectDTO.setPlanCode(goodsCode);
            if (!(methodType.equals("97") || methodType.equals("96") || methodType.equals("99") || methodType.equals("9") || RiskCodeEnum.getType((String)quotePrice.getMain().getRiskCode()) == 2)) {
                calculateObjectDTO.setInsuredType(insuredDTO.getInsuredType());
            }
            if (methodType.equals("1") || methodType.equals("12")) {
                calculateObjectDTO.setDay(Integer.valueOf(days));
            }
            if (methodType.equals("10")) {
                calculateObjectDTO.setGdIsInsuranceFlag(ObjectUtil.isEmpty((Object)insuredDTO) ? "" : insuredDTO.getSocialSecurityFlag());
            }
            if (methodType.equals("11") || methodType.equals("12")) {
                calculateObjectDTO.setPhdTotal(Integer.valueOf(insuredListReq.size()));
            }
            if (methodType.equals("5") || methodType.equals("2")) {
                boolean flag = DataCompletionUtil.judgeDate((Date)quotePrice.getMain().getStartDate(), (Date)quotePrice.getMain().getEndDate());
                calculateObjectDTO.setYearDays((flag ? new Integer("366") : new Integer("365")).intValue());
                calculateObjectDTO.setUwDays(Integer.valueOf(days));
            }
            if (methodType.equals("6") || methodType.equals("7")) {
                calculateObjectDTO.setNumber(Integer.valueOf(days));
            }
            if (methodType.equals("3")) {
                int months = this.betweenMonth(startDate, endDate);
                calculateObjectDTO.setMonth(Integer.valueOf(months));
            }
            calList.add(calculateObjectDTO);
            ++index;
        }
        return calList;
    }

    public static int betweenDays(Date startDate, Date endDate, boolean isCeil) {
        double days = (double)(endDate.getTime() - startDate.getTime()) / (double)DateUnit.DAY.getMillis();
        if (isCeil) {
            days = Math.ceil(days);
        }
        return (int)days;
    }

    public int betweenMonth(Date startDate, Date endDate) {
        int startDay;
        Long betweenMonth = DateUtil.betweenMonth((Date)startDate, (Date)endDate, (boolean)true);
        DateTime endDateNew = DateUtil.offsetSecond((Date)endDate, (int)1);
        int endDay = DateUtil.dayOfMonth((Date)endDateNew);
        if (endDay > (startDay = DateUtil.dayOfMonth((Date)startDate))) {
            Long l = betweenMonth;
            Long l2 = betweenMonth = Long.valueOf(betweenMonth + 1L);
        }
        return betweenMonth.intValue() < 1 ? 1 : betweenMonth.intValue();
    }
}

