/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.TimeInterval;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.CalculateUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.BaseCodeConvertUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.CommissionDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemTrafficDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.SalesDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredIdvDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.sale.request.resp.SaleResponseDTO;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiAccessLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiAsyncOrderMqLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelInstallmentOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiCorrectReqMsgLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiGuaranteeUnderwriteResultLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiPayLogService;
import com.jdaz.sinosoftgz.apis.commons.model.busi.service.ApisBusiThyroidResultLogService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelCode;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelInterfaceRouterService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelProductService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelUserService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfsInsuredType;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationClauseKindFactoryMapper;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationClauseMapper;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationKindMapper;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfsInsuredTypeMapper;
import com.jdaz.sinosoftgz.apis.commons.service.constants.CommonConstant;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.impl.ApisBusiRenewalServiceImpl;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreCorrectApi;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import sinosoftgz.utils.data.DateUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class DataCompletionUtil {
    private static Logger log = LoggerFactory.getLogger(DataCompletionUtil.class);
    @Autowired
    ApisChannelUserService apisChannelUserService;
    @Autowired
    ApisBusiChannelOrderService apisBusiChannelOrderService;
    @Autowired
    ApisBusiAccessLogService apisBusiAccessLogService;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    CoreCorrectApi coreCorrectApi;
    @Autowired
    ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    ApisPfpRationClauseMapper apisPfpRationClauseMapper;
    @Autowired
    ApisPfpRationKindMapper apisPfpRationKindMapper;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisChannelProductService apisChannelProductService;
    @Autowired
    ApisPfpRationClauseKindFactoryMapper apisPfpRationClauseKindFactoryMapper;
    @Autowired
    ApisBusiChannelInstallmentOrderService apisBusiChannelInstallmentOrderService;
    @Autowired
    BaseCodeConvertUtils baseCodeConvertUtils;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    ApisBusiCorrectReqMsgLogService apisBusiCorrectReqMsgLogService;
    @Autowired
    ApisBusiPayLogService apisBusiPayLogService;
    @Autowired
    ApisPfsInsuredTypeMapper apisPfsInsuredTypeMapper;
    @Autowired
    ApisBusiThyroidResultLogService apisBusiThyroidResultLogService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ApisChannelInterfaceRouterService apisChannelInterfaceRouterService;
    @Autowired
    ApisBusiRenewalServiceImpl apisBusiRenewalService;
    @Autowired
    ApisBusiAsyncOrderMqLogService apisBusiAsyncOrderMqLogService;
    @Autowired
    ApisBusiGuaranteeUnderwriteResultLogService apisBusiGuaranteeUnderwriteResultLogService;
    @Autowired
    CalculateUtil calculateUtil;

    public void dataCompletion(StanderRequest request) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        TimeInterval timer = DateUtil.timer();
        String planCode = ((ItemMainDTO)quotePriceDTO.getItemMainList().get(0)).getGoodsCode();
        ApisPfpRationMain apisPfpRationMain = this.getApisPfpRationMainInfo(planCode, "2");
        log.warn("\u83b7\u53d6\u5546\u54c1\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionMainDTO(quotePriceDTO, request, apisPfpRationMain);
        log.warn("\u8865\u5168\u6295\u4fdd\u516c\u5171\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionAppliClientDTO(quotePriceDTO);
        log.warn("\u8865\u5168\u6295\u4fdd\u4eba\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getInsuredList())) {
            this.dataCompletionInsuredDTO(quotePriceDTO);
            log.warn("\u8865\u5168\u88ab\u4fdd\u4eba\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        }
        this.dataCompletionCoverageDTO(request, apisPfpRationMain);
        log.warn("\u8865\u5168\u4fdd\u5355\u4fdd\u969c\u4fe1\u606f\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
        this.dataCompletionInsuredType(request, apisPfpRationMain);
        this.settleInsuredFlag(request);
    }

    private void dataCompletionInsuredType(StanderRequest request, ApisPfpRationMain apisPfpRationMain) throws ApisDataCompletionException {
        if (("quotePrice".equals(request.getHeader().getBussinessType()) || "underwrit".equals(request.getHeader().getBussinessType()) || "riskUnderwrit".equals(request.getHeader().getBussinessType())) && ("07".equals(apisPfpRationMain.getClassCode()) || "09".equals(apisPfpRationMain.getClassCode()))) {
            List insuredDTOList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getInsuredList();
            boolean isAnyInsuredTypeNull = false;
            if (ObjectUtil.isNotEmpty((Object)insuredDTOList)) {
                boolean isInit = true;
                List insuredTypeConfigs = null;
                int age = 0;
                String planCode = ((ItemMainDTO)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(0)).getGoodsCode();
                Date startDate = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getStartDate();
                for (InsuredDTO insuredIdvDTO : insuredDTOList) {
                    if (!StrUtil.isBlank((CharSequence)insuredIdvDTO.getInsuredType())) continue;
                    isAnyInsuredTypeNull = true;
                    if (isInit) {
                        List insuredTypeList = this.apisPfpRationClauseKindFactoryMapper.queryInsuredTypeByRationCode(planCode);
                        insuredTypeConfigs = this.apisPfsInsuredTypeMapper.queryInsuredTypeList(insuredTypeList);
                        isInit = false;
                    }
                    if (!ObjectUtil.isNotEmpty(insuredTypeConfigs)) continue;
                    boolean flag = false;
                    age = this.calculateAge(startDate, insuredIdvDTO.getBirthday());
                    for (int j = 0; j < insuredTypeConfigs.size(); ++j) {
                        if (age < ((ApisPfsInsuredType)insuredTypeConfigs.get(j)).getAgeFrom() || age > ((ApisPfsInsuredType)insuredTypeConfigs.get(j)).getAgeTo()) continue;
                        if (flag && !StrUtil.equals((CharSequence)insuredIdvDTO.getInsuredType(), (CharSequence)((ApisPfsInsuredType)insuredTypeConfigs.get(j)).getInsuredType())) {
                            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10714.getValue(), ChannelErrorCodeEnum.ERR_C10714.getKey());
                        }
                        if (flag) continue;
                        insuredIdvDTO.setInsuredType(((ApisPfsInsuredType)insuredTypeConfigs.get(j)).getInsuredType());
                        flag = true;
                    }
                    if (flag) continue;
                    log.error("\n\u88ab\u4fdd\u9669\u4eba\u3010{}\u3011\u65e0\u6cd5\u5339\u914d\u5bf9\u5e94\u7684\u88ab\u4fdd\u9669\u4eba\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4!", (Object)insuredIdvDTO.getInsuredName());
                    throw new ApisDataCompletionException("\u88ab\u4fdd\u9669\u4eba\u3010" + insuredIdvDTO.getInsuredName() + "\u3011\u65e0\u6cd5\u5339\u914d\u5bf9\u5e94\u7684\u88ab\u4fdd\u9669\u4eba\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4!", "1194");
                }
                if (isAnyInsuredTypeNull && ObjectUtil.isEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getSumPremium())) {
                    throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10008.getValue().replaceFirst("##", "TotalPremium"), ChannelErrorCodeEnum.ERR_C10008.getKey());
                }
            }
        }
    }

    public void settleInsuredFlag(StanderRequest request) {
        block7: {
            QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
            AppliClientDTO appliClientDTO = (AppliClientDTO)quotePriceDTO.getAppliClient().get(0);
            boolean flag = false;
            Integer mainSerialNo = null;
            if (!ObjectUtil.isNotEmpty((Object)quotePriceDTO.getInsuredList())) break block7;
            for (InsuredDTO insuredIdvDTO : quotePriceDTO.getInsuredList()) {
                if (!appliClientDTO.getIdentifyNumber().equals(insuredIdvDTO.getIdentifyNumber())) continue;
                mainSerialNo = insuredIdvDTO.getSerialNo();
                flag = true;
                break;
            }
            if (flag) {
                for (InsuredDTO insuredIdvDTO : quotePriceDTO.getCoverage().getInsuredIdvList()) {
                    if (appliClientDTO.getIdentifyNumber().equals(insuredIdvDTO.getIdentifyNumber())) {
                        insuredIdvDTO.setInsuredFlag("1");
                        continue;
                    }
                    insuredIdvDTO.setMainSerialNo(mainSerialNo);
                    insuredIdvDTO.setInsuredFlag("2");
                }
            } else {
                for (int i = 0; i < quotePriceDTO.getCoverage().getInsuredIdvList().size(); ++i) {
                    InsuredDTO insuredIdvDTO;
                    insuredIdvDTO = (InsuredIdvDTO)quotePriceDTO.getCoverage().getInsuredIdvList().get(i);
                    if (i == 0) {
                        mainSerialNo = insuredIdvDTO.getSerialNo();
                        insuredIdvDTO.setInsuredFlag("1");
                        continue;
                    }
                    insuredIdvDTO.setMainSerialNo(mainSerialNo);
                    insuredIdvDTO.setInsuredFlag("2");
                }
            }
        }
    }

    public void dataCompletionMainDTO(QuotePriceDTO quotePriceDTO, StanderRequest request, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        MainDTO mainDTO = quotePriceDTO.getMain();
        String planCode = ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).getGoodsCode();
        if (ObjectUtils.isNotEmpty((Object)apisPfpRationMain)) {
            ((ItemMainDTO)quotePriceDTO.getCoverage().getItemList().get(0)).setGoodsName(apisPfpRationMain.getRationName());
            if (StringUtils.isEmpty((CharSequence)mainDTO.getRiskCode())) {
                mainDTO.setRiskCode(apisPfpRationMain.getProductCode());
                mainDTO.setRiskName(apisPfpRationMain.getProductName());
            }
            request.getQuotePriceServiceRequest().getRequestHead().setClassCode(apisPfpRationMain.getClassCode());
            request.getQuotePriceServiceRequest().getRequestHead().setRiskCode(mainDTO.getRiskCode());
            if (ObjectUtil.isNotEmpty((Object)apisPfpRationMain.getCustomerType()) && apisPfpRationMain.getCustomerType() == CommonConstant.CustomerTypeCode.GROUP) {
                mainDTO.setPolicyType("02");
            } else {
                mainDTO.setPolicyType("01");
            }
        } else {
            log.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5546\u54c1\u4fe1\u606f\uff0c\u5546\u54c1\u4ee3\u7801:{}", (Object)planCode);
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10024.getKey()).message(ChannelErrorCodeEnum.ERR_C10024.getValue()).build();
        }
        if (ObjectUtils.isNotEmpty((Object)quotePriceDTO.getCoverage().getInsuredIdvList()) && quotePriceDTO.getCoverage().getInsuredIdvList().size() > 0) {
            if (ObjectUtil.isEmpty((Object)mainDTO.getSumQuantity())) {
                mainDTO.setSumQuantity(Integer.valueOf(quotePriceDTO.getCoverage().getInsuredIdvList().size()));
            }
        } else if (ObjectUtils.isNotEmpty((Object)quotePriceDTO.getInsuredList()) && quotePriceDTO.getInsuredList().size() > 0) {
            if (ObjectUtil.isEmpty((Object)mainDTO.getSumQuantity())) {
                mainDTO.setSumQuantity(Integer.valueOf(quotePriceDTO.getInsuredList().size()));
            }
        } else if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getCoverage().getItemTrafficList()) && ObjectUtil.isEmpty((Object)mainDTO.getSumQuantity())) {
            int sumQuantity = 0;
            for (ItemTrafficDTO itemTrafficDTO : quotePriceDTO.getCoverage().getItemTrafficList()) {
                if (!ObjectUtil.isNotEmpty((Object)itemTrafficDTO.getSeatNo())) continue;
                sumQuantity += itemTrafficDTO.getSeatNo().intValue();
            }
            mainDTO.setSumQuantity(Integer.valueOf(sumQuantity));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getBusinessAttrubute())) {
            mainDTO.setBusinessAttribute("Apis");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getNationFlag())) {
            mainDTO.setNationFlag("0");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getArgueSolution())) {
            mainDTO.setArgueSolution("1");
        }
        Map userMap = this.getChannelUserInfo(request);
        if (StringUtils.isEmpty((CharSequence)mainDTO.getCalcType())) {
            mainDTO.setCalcType("1");
        }
        if ("3".equals(mainDTO.getCalcType()) && "01".equals(mainDTO.getPolicyType()) && Arrays.asList(BusinessConstants.ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
            mainDTO.setIsSupportFamily("Y");
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getInputDate())) {
            mainDTO.setInputDate(new Date());
        } else {
            int regInputDate = Integer.parseInt(DateUtil.format((Date)DateUtil.offsetDay((Date)new Date(), (int)-1), (String)"yyyyMMdd"));
            int inputDate = Integer.parseInt(DateUtil.format((Date)mainDTO.getInputDate(), (String)"yyyyMMdd"));
            if (!this.issueDateControl(request) && inputDate < regInputDate) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10637.getValue(), ChannelErrorCodeEnum.ERR_C10637.getKey());
            }
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getRenewalFlag())) {
            if (StringUtils.isEmpty((CharSequence)mainDTO.getRenewalPolicyNo())) {
                mainDTO.setRenewalFlag("0");
            } else if (!"underwriting".equals(request.getHeader().getBussinessType())) {
                mainDTO.setRenewalFlag("1");
            } else {
                mainDTO.setRenewalFlag("0");
            }
        }
        if (ObjectUtils.isEmpty((Object)mainDTO.getStartHour())) {
            mainDTO.setStartHour(Integer.valueOf(0));
        }
        if (ObjectUtils.isEmpty((Object)mainDTO.getEndHour())) {
            mainDTO.setEndHour(Integer.valueOf(24));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getJudicalScope())) {
            mainDTO.setJudicalScope("1");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getCurrency())) {
            mainDTO.setCurrency("RMB");
        }
        if (ObjectUtils.isEmpty((Object)mainDTO.getTotalDiscount())) {
            mainDTO.setTotalDiscount(Double.valueOf(100.0));
        }
        if (ObjectUtils.isEmpty((Object)mainDTO.getSumDisCount())) {
            mainDTO.setSumDisCount(Double.valueOf(0.0));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getOperateCode())) {
            mainDTO.setOperateCode((String)DataCompletionUtil.castToClass(String.class, userMap.get("operate_code")));
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getOperateName())) {
            mainDTO.setOperateName((String)DataCompletionUtil.castToClass(String.class, userMap.get("user_name")));
        }
        String comCode = (String)DataCompletionUtil.castToClass(String.class, userMap.get("com_code"));
        if (StringUtils.isEmpty((CharSequence)mainDTO.getComCode())) {
            mainDTO.setComCode(comCode);
        } else if (!comCode.equals(mainDTO.getComCode())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10711.getValue(), ChannelErrorCodeEnum.ERR_C10711.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getMakeCom())) {
            mainDTO.setMakeCom(mainDTO.getComCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)mainDTO.getSystemSource()) && "1".equals(mainDTO.getSystemSource())) {
            mainDTO.setBusinessNature2("PP");
        }
        Date startDate = new Date();
        if (ObjectUtil.isNotEmpty((Object)mainDTO.getRenewalFlag()) && "1".equals(mainDTO.getRenewalFlag()) && ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform()) && request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
            mainDTO.setJFeeFlag("1");
            mainDTO.setStepFlag("1");
        } else {
            ApisChannelConfigs channelConfigs = this.getConfig(request, "channel_jfeeFlag");
            log.warn("\u83b7\u53d6\u89c1\u8d39\u6807\u8bc6\uff0c\u7528\u65f6 :{}", (Object)(System.currentTimeMillis() - startDate.getTime()));
            if (ObjectUtil.isNotEmpty((Object)channelConfigs)) {
                mainDTO.setJFeeFlag(channelConfigs.getConfigValue());
                mainDTO.setStepFlag(channelConfigs.getValueType());
            }
        }
        String giftType = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getGiftType();
        if (StringUtils.isNotEmpty((CharSequence)giftType) && giftType.equals("2")) {
            log.warn("======\u4eac\u4e1c\u5b89\u8054\u8d60\u9669\u51fa\u5355\uff0c\u8bbe\u7f6e\u4e3a\u975e\u89c1\u8d39");
            mainDTO.setJFeeFlag("0");
            mainDTO.setStepFlag("1");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getMarineType()) && "06".equals(apisPfpRationMain.getClassCode())) {
            mainDTO.setMarineType("13");
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getClassCode())) {
            mainDTO.setClassCode(apisPfpRationMain.getClassCode());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getPaymentType()) && "1".equals(mainDTO.getJFeeFlag()) && ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPayPlanList()) && quotePriceDTO.getPayPlanList().size() > 1) {
            mainDTO.setPlanPayType("01");
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getLargeBusiRisk())) {
            mainDTO.setLargeBusiRisk("0");
        }
    }

    private boolean issueDateControl(StanderRequest request) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)request.getHeader().getUserCode());
        queryWrapper.eq((Object)"config_code", (Object)"issueDate_control");
        ApisChannelConfigs channelConfigs = (ApisChannelConfigs)this.apisChannelConfigsService.getOne((Wrapper)queryWrapper);
        return ObjectUtil.isNotEmpty((Object)channelConfigs);
    }

    public void dataCompletionAppliClientDTO(QuotePriceDTO quotePriceDTO) throws ApisDataCompletionException {
        List appliClientDTOList = quotePriceDTO.getAppliClient();
        Integer serialNo = 1;
        for (AppliClientDTO appliClientDTO : appliClientDTOList) {
            String occupationCode;
            if (ObjectUtils.isEmpty((Object)appliClientDTO.getSerialNo())) {
                appliClientDTO.setSerialNo(serialNo);
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredFlag())) {
                appliClientDTO.setInsuredFlag("1");
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredType())) {
                appliClientDTO.setInsuredType("1");
            }
            if (ObjectUtil.isNotEmpty((Object)quotePriceDTO.getPlanList())) {
                if ("2".equals(appliClientDTO.getInsuredType())) {
                    appliClientDTO.setTaxPayerType("05");
                } else {
                    if (StringUtils.isEmpty((CharSequence)appliClientDTO.getTaxPayerType())) {
                        appliClientDTO.setTaxPayerType("04");
                    }
                    if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceType())) {
                        if ("1".equals(appliClientDTO.getReqElecFaPiao())) {
                            appliClientDTO.setInvoiceType("026");
                        } else {
                            appliClientDTO.setInvoiceType("007");
                        }
                    }
                }
            } else if ("2".equals(appliClientDTO.getInsuredType())) {
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getTaxPayerType())) {
                    appliClientDTO.setTaxPayerType("05");
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceType())) {
                    if ("1".equals(appliClientDTO.getReqElecFaPiao())) {
                        appliClientDTO.setInvoiceType("026");
                    } else {
                        appliClientDTO.setInvoiceType("007");
                    }
                }
            } else {
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getTaxPayerType())) {
                    appliClientDTO.setTaxPayerType("04");
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceType())) {
                    if ("1".equals(appliClientDTO.getReqElecFaPiao())) {
                        appliClientDTO.setInvoiceType("026");
                    } else {
                        appliClientDTO.setInvoiceType("007");
                    }
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getOccupationCode()) && StringUtils.isNotEmpty((CharSequence)(occupationCode = this.convertCode("SmallClassProfession", appliClientDTO.getOccupationCode())))) {
                appliClientDTO.setOccupationCode(occupationCode);
                appliClientDTO.setOccupationGrade(occupationCode.substring(0, 1));
                appliClientDTO.setOccupationType(occupationCode.substring(0, 3));
                appliClientDTO.setOccupationLevel(this.convertCode("occupationLevel", appliClientDTO.getOccupationCode()));
            }
            if (ObjectUtil.isEmpty((Object)appliClientDTO.getInsuredId())) {
                appliClientDTO.setInsuredId(String.valueOf(System.currentTimeMillis()));
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyType())) {
                appliClientDTO.setIdentifyType("99");
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyNumber())) {
                appliClientDTO.setIdentifyNumber(appliClientDTO.getInsuredName());
            }
            Integer n = serialNo;
            Integer n2 = serialNo = Integer.valueOf(serialNo + 1);
        }
    }

    public void dataCompletionInsuredDTO(QuotePriceDTO quotePriceDTO) throws ApisDataCompletionException {
        List insuredDTOList = quotePriceDTO.getInsuredList();
        AppliClientDTO appliClientDTO = (AppliClientDTO)quotePriceDTO.getAppliClient().get(0);
        Integer serialNo = 1;
        for (InsuredDTO insuredDTO : insuredDTOList) {
            if (ObjectUtils.isEmpty((Object)insuredDTO.getSerialNo())) {
                insuredDTO.setSerialNo(serialNo);
            }
            if (ObjectUtils.isEmpty((Object)insuredDTO.getBenefitModeCode())) {
                insuredDTO.setBenefitModeCode("1");
            }
            if (StringUtils.isEmpty((CharSequence)insuredDTO.getInsuredFlag())) {
                insuredDTO.setInsuredFlag("2");
            }
            if (StringUtils.isEmpty((CharSequence)insuredDTO.getTaxPayerType())) {
                if ("1".equals(insuredDTO.getInsuredType())) {
                    insuredDTO.setTaxPayerType("04");
                } else {
                    insuredDTO.setTaxPayerType("05");
                }
            }
            if ("1".equals(appliClientDTO.getReqElecFaPiao())) {
                insuredDTO.setInvoiceType("026");
            } else {
                insuredDTO.setInvoiceType("026");
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getOccupationCode())) {
                String occupationCode = this.convertCode("SmallClassProfession", insuredDTO.getOccupationCode());
                if (StringUtils.isNotEmpty((CharSequence)occupationCode)) {
                    insuredDTO.setOccupationCode(occupationCode);
                }
                if (insuredDTO.getOccupationCode().trim().length() > 3) {
                    insuredDTO.setOccupationGrade(insuredDTO.getOccupationCode().substring(0, 1));
                    insuredDTO.setOccupationType(insuredDTO.getOccupationCode().substring(0, 3));
                }
                insuredDTO.setOccupationLevel(this.convertCode("occupationLevel", insuredDTO.getOccupationCode()));
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredIDCache())) {
                insuredDTO.setInsuredId(insuredDTO.getInsuredIDCache());
            }
            if (ObjectUtil.isEmpty((Object)insuredDTO.getInsuredId())) {
                insuredDTO.setInsuredId(String.valueOf(System.currentTimeMillis()));
            }
            Integer n = serialNo;
            Integer n2 = serialNo = Integer.valueOf(serialNo + 1);
        }
    }

    public void dataCompletionSalesDTO(StanderRequest request, List<SaleResponseDTO> saleResponseDTOList) {
        QuotePriceDTO quotePriceDTO = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        SalesDTO salesDTO = quotePriceDTO.getSales();
        SaleResponseDTO saleResponseDTO = saleResponseDTOList.get(0);
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgentName()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgentName(saleResponseDTO.getAgentName());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgreementNo()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgreementNo(saleResponseDTO.getAgreementCode());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgreementName()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgreementName(saleResponseDTO.getAgreementName());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgentType()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgentType(saleResponseDTO.getAgentType());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getAgentDetailType()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setAgentDetailType(saleResponseDTO.getSubAgentType());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getHandlerCode()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setHandlerCode(saleResponseDTO.getBdInfo().getBdCode());
        }
        if (StringUtils.isEmpty((CharSequence)salesDTO.getHandlerName()) && ObjectUtils.isNotEmpty((Object)saleResponseDTO)) {
            salesDTO.setHandlerName(saleResponseDTO.getBdInfo().getBdName());
        }
        salesDTO.setHandlerTeamCode(saleResponseDTO.getBdInfo().getBdTeamCode());
        salesDTO.setHandlerTeamName(saleResponseDTO.getBdInfo().getBdTeamName());
        ArrayList<CommissionDTO> list = new ArrayList<CommissionDTO>();
        CommissionDTO commissionDTO = null;
        for (SaleResponseDTO dto : saleResponseDTOList) {
            commissionDTO = CommissionDTO.builder().build();
            commissionDTO.setRoleAgentCode(dto.getAgentCode());
            commissionDTO.setAgentFlag(dto.getAgentFlag());
            commissionDTO.setCostType(dto.getFeeType());
            commissionDTO.setCostRateUpper(Double.valueOf(dto.getAgreementLimitRate()));
            commissionDTO.setCostRate(Double.valueOf(dto.getCommRate()));
            list.add(commissionDTO);
        }
        salesDTO.setCommissionList(list);
        if ("1".equals(quotePriceDTO.getMain().getRenewalFlag())) {
            if (ObjectUtil.isNotEmpty((Object)request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform()) && request.getQuotePriceServiceRequest().getRequestBody().getSelfHelpPlatform().booleanValue()) {
                salesDTO.setRenewalType("2");
            } else {
                salesDTO.setRenewalType("1");
            }
        }
    }

    public void dataCompletionCoverageDTO(StanderRequest request, ApisPfpRationMain apisPfpRationMainGood) throws ApisBusinessException {
        TimeInterval timer = DateUtil.timer();
        List itemMainList = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getItemMainList();
        if (ObjectUtils.isNotEmpty((Object)itemMainList)) {
            int itemNo = 1;
            for (ItemMainDTO itemMainDTO : itemMainList) {
                if (ObjectUtils.isEmpty((Object)itemMainDTO.getItemNo())) {
                    itemMainDTO.setItemNo(Integer.valueOf(itemNo));
                }
                itemMainDTO.setGoodsName(apisPfpRationMainGood.getRationName());
                ApisPfpRationMain apisPfpRationMain = this.getApisPfpRationMainInfo(itemMainDTO.getGoodsCode(), "1");
                log.warn("\u83b7\u53d6\u4fdd\u969c\u65b9\u6848\u4ee3\u7801\uff0c\u7528\u65f6 :{}", (Object)timer.intervalRestart());
                if (ObjectUtil.isNotEmpty((Object)apisPfpRationMain)) {
                    itemMainDTO.setPlanCode(apisPfpRationMain.getRationCode() == null ? "" : apisPfpRationMain.getRationCode());
                    itemMainDTO.setPlanName(apisPfpRationMain.getRationName() == null ? "" : apisPfpRationMain.getRationName());
                }
                itemMainDTO.setGoodsVersion(apisPfpRationMain.getRationVersion());
                ++itemNo;
            }
        }
    }

    public Map getChannelUserInfo(StanderRequest request) throws ApisDataCompletionException {
        Map userMap = this.baseCodeConvertUtils.getCodeData("channel:user:" + request.getHeader().getUserCode());
        if (ObjectUtils.isEmpty((Object)userMap) || userMap.size() == 0) {
            log.error("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u8d26\u53f7\u4fe1\u606f\uff0c\u8d26\u53f7\uff1a{}", (Object)request.getHeader().getUserCode());
            throw ApisDataCompletionException.builder().errorCode(ChannelErrorCodeEnum.ERR_C10173.getKey()).message(ChannelErrorCodeEnum.ERR_C10173.getValue()).build();
        }
        return userMap;
    }

    public ApisPfpRationMain getApisPfpRationMainInfo(String planCode, String rationFlag) {
        ApisPfpRationMain apisPfpRationMain = new ApisPfpRationMain();
        apisPfpRationMain.setRationCode(planCode);
        String rationFlagOne = "1";
        if (rationFlagOne.equals(rationFlag)) {
            apisPfpRationMain.setRationFlag("2");
        } else {
            apisPfpRationMain.setRationFlag(rationFlag);
        }
        apisPfpRationMain.setDeleted(Integer.valueOf(0));
        apisPfpRationMain.setValidStatus(Integer.valueOf(1));
        QueryWrapper queryWrapper = new QueryWrapper((Object)apisPfpRationMain);
        List rationMainList = new ArrayList();
        rationMainList = this.apisPfpRationMainService.list((Wrapper)queryWrapper);
        if (rationFlagOne.equals(rationFlag) && ObjectUtil.isNotEmpty(rationMainList) && rationMainList.size() > 0) {
            QueryWrapper queryWrapperT = new QueryWrapper();
            queryWrapperT.eq((Object)"ration_flag", (Object)rationFlag);
            queryWrapperT.eq((Object)"ration_code", (Object)((ApisPfpRationMain)rationMainList.get(0)).getRelateRationCode());
            queryWrapperT.eq((Object)"deleted", (Object)0);
            queryWrapperT.eq((Object)"valid_status", (Object)1);
            rationMainList = this.apisPfpRationMainService.list((Wrapper)queryWrapperT);
        }
        if (ObjectUtil.isNotEmpty(rationMainList) && rationMainList.size() > 0) {
            return (ApisPfpRationMain)rationMainList.get(0);
        }
        return null;
    }

    public String convertCode(String code, String channelValue) throws ApisDataCompletionException {
        String value = "";
        Map map = this.baseCodeConvertUtils.getCodeData("channel:code:/:" + code);
        if (ObjectUtil.isNotEmpty((Object)map) && map.size() > 0) {
            value = (String)map.get(channelValue);
        } else {
            ApisChannelCode apisChannelCode = new ApisChannelCode();
            apisChannelCode.setCode(code);
            apisChannelCode.setChannelValue(channelValue);
            apisChannelCode.setDeleted(Integer.valueOf(0));
            QueryWrapper queryWrapper = new QueryWrapper((Object)apisChannelCode);
            List apisChannelCodeResult = this.apisChannelCodeService.list((Wrapper)queryWrapper);
            if (ObjectUtils.isNotEmpty((Object)apisChannelCodeResult) && apisChannelCodeResult.size() > 0) {
                value = ((ApisChannelCode)apisChannelCodeResult.get(0)).getValue();
            }
        }
        return value;
    }

    public String reversalCode(String code, String value) {
        ApisChannelCode apisChannelCode = new ApisChannelCode();
        apisChannelCode.setCode(code);
        apisChannelCode.setValue(value);
        apisChannelCode.setDeleted(Integer.valueOf(0));
        QueryWrapper queryWrapper = new QueryWrapper((Object)apisChannelCode);
        ApisChannelCode apisChannelCodeResult = (ApisChannelCode)this.apisChannelCodeService.getOne((Wrapper)queryWrapper);
        if (ObjectUtils.isNotEmpty((Object)apisChannelCodeResult) && StringUtils.isNotEmpty((CharSequence)apisChannelCodeResult.getChannelValue())) {
            return apisChannelCodeResult.getChannelValue();
        }
        return "";
    }

    public static boolean judgeDate(Date startDate, Date endDate) {
        boolean flag = false;
        try {
            String format = "yyyy-MM-dd";
            Calendar startDateCalendar = Calendar.getInstance();
            startDateCalendar.setTime(startDate);
            Calendar endDateCalendar = Calendar.getInstance();
            endDateCalendar.setTime(endDate);
            boolean startFlag = DateUtils.isLeapYear((String)DateUtil.format((Date)startDate, (String)"yyyy-MM-dd"));
            boolean endFlag = DateUtils.isLeapYear((String)DateUtil.format((Date)endDate, (String)"yyyy-MM-dd"));
            Integer start = 0;
            Integer end = 0;
            if (startFlag && endFlag) {
                start = DateUtil.year((Date)startDate);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new SimpleDateFormat(format).parse(start + "-03-01"));
                flag = calendar.after(startDateCalendar) && calendar.before(endDateCalendar);
            } else if (startFlag && !endFlag) {
                start = DateUtil.year((Date)startDate);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new SimpleDateFormat(format).parse(start + "-03-01"));
                flag = calendar.after(startDateCalendar);
            } else if (!startFlag && endFlag) {
                end = DateUtil.year((Date)endDate);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new SimpleDateFormat(format).parse(end + "-02-28"));
                flag = calendar.before(endDateCalendar);
            }
        }
        catch (Exception e) {
            log.error("\n\u7a0b\u5e8f\u5f02\u5e38", (Throwable)e);
        }
        return flag;
    }

    public ApisChannelConfigs getConfig(StanderRequest request, String configCode) {
        String userCode = request.getHeader().getUserCode();
        String productCode = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getRiskCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"deleted", (Object)ApisChannelConfigs.DELETE_FLAG_FALSE);
        queryWrapper.eq((Object)"user_code", (Object)userCode);
        queryWrapper.eq((Object)"config_code", (Object)configCode);
        queryWrapper.like((Object)"product_code", (Object)productCode);
        List list = this.apisChannelConfigsService.list((Wrapper)queryWrapper);
        if (ObjectUtil.isNotEmpty((Object)list) && list.size() > 0) {
            return (ApisChannelConfigs)list.get(0);
        }
        return null;
    }

    public int calculateAge(Date startDate, Date birthDay) throws ApisDataCompletionException {
        if (ObjectUtil.isEmpty((Object)birthDay)) {
            log.error("\u88ab\u4fdd\u9669\u4eba\u51fa\u751f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10401.getValue(), ChannelErrorCodeEnum.ERR_C10401.getKey());
        }
        if (ObjectUtil.isEmpty((Object)startDate)) {
            log.error("\u8d77\u4fdd\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N30003.getValue(), ErrorNullValueCodeEnum.ERR_N30003.getKey());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        if (cal.before(birthDay)) {
            log.error("\u51fa\u751f\u65e5\u671f\u665a\u4e8e\u8d77\u4fdd\u65e5\u671f\uff0c\u65e0\u6cd5\u8ba1\u7b97\u5e74\u9f84");
            throw new ApisDataCompletionException(ErrorBisCodeEnum.ERR_B30004.getValue(), ErrorBisCodeEnum.ERR_B30004.getKey());
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public static <T> T castToClass(Class<T> type, Object value) {
        return (T)DataCompletionUtil.castToClass(type, (Object)value, (boolean)true);
    }

    public static <T> T castToClass(Class<T> type, Object value, boolean isQuietly) {
        if (null == type) {
            return null;
        }
        if (null == value) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        if (isQuietly) {
            return null;
        }
        throw new ClassCastException("Cannot cast " + value.getClass().getName() + " to " + type.getName());
    }
}

