/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util;

import com.jdaz.sinosoftgz.apis.commons.model.api.asynInsure.request.Insured;
import com.jdaz.sinosoftgz.apis.commons.model.api.asynInsure.request.Policy;
import com.jdaz.sinosoftgz.apis.commons.model.api.asynInsure.request.PolicyHolder;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderPacket;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceServiceRequestDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.RequestHeadDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.SalesDTO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class DataConversionUtil {
    public StanderRequest dataConversion(StanderPacket standerPacket) {
        RequestHeadDTO requestHeadDTO = RequestHeadDTO.initRequestHead();
        requestHeadDTO.setConsumerSeqNo(standerPacket.getUserCode() + standerPacket.getHead().getRequestType() + standerPacket.getBody().getPolicy().getAgencyPolicyRef());
        QuotePriceServiceRequest quotePriceServiceRequest = QuotePriceServiceRequest.builder().requestHead(requestHeadDTO).build();
        QuotePriceDTO quotePriceDTO = QuotePriceDTO.builder().build();
        MainDTO main = this.buildMainDTO(standerPacket);
        quotePriceDTO.setMain(main);
        SalesDTO sales = SalesDTO.builder().agentCode(standerPacket.getBody().getAgency().getAgencyCode()).build();
        quotePriceDTO.setSales(sales);
        List appliClientDTOList = this.buildAppliClient(standerPacket);
        quotePriceDTO.setAppliClient(appliClientDTOList);
        List insuredDTOList = this.buildInsured(standerPacket);
        quotePriceDTO.setInsuredList(insuredDTOList);
        ArrayList<ItemMainDTO> itemMainDTOList = new ArrayList<ItemMainDTO>();
        itemMainDTOList.add(ItemMainDTO.builder().goodsCode(standerPacket.getBody().getPolicy().getPlanCode()).build());
        quotePriceDTO.setItemMainList(itemMainDTOList);
        QuotePriceServiceRequestDTO quotePriceServiceRequestDTO = QuotePriceServiceRequestDTO.builder().quotePrice(quotePriceDTO).build();
        quotePriceServiceRequest.setRequestBody(quotePriceServiceRequestDTO);
        return StanderRequest.builder().header(StanderHeader.builder().bussinessType("quotePrice").build()).quotePriceServiceRequest(quotePriceServiceRequest).build();
    }

    private List<InsuredDTO> buildInsured(StanderPacket standerPacket) {
        ArrayList<InsuredDTO> insuredDTOList = new ArrayList<InsuredDTO>();
        List insureds = standerPacket.getBody().getInsuredList();
        for (Insured insured : insureds) {
            InsuredDTO insuredDTO = InsuredDTO.builder().build();
            insuredDTO.setInsuredId(insured.getInsuredId().toString());
            insuredDTO.setInsuredIDCache(insured.getInsuredId().toString());
            insuredDTO.setInsuredName(insured.getInsuredName());
            insuredDTO.setInsuredEname(insured.getInsuredEname());
            insuredDTO.setIdentifyNumber(insured.getIdNumber());
            insuredDTO.setIdentifyType(insured.getIdType());
            insuredDTO.setBirthday(insured.getBirthDate());
            insuredDTO.setMobile(insured.getMobile());
            insuredDTO.setEmail(insured.getEmail());
            insuredDTO.setSex(insured.getGender());
            insuredDTO.setSocialSecurityFlag(insured.getSocialSecurityFlag());
            insuredDTO.setOccupationCode(insured.getOccupationCode());
            insuredDTO.setInsuredAddress(insured.getResideAddress());
            insuredDTOList.add(insuredDTO);
        }
        return insuredDTOList;
    }

    private List<AppliClientDTO> buildAppliClient(StanderPacket standerPacket) {
        ArrayList<AppliClientDTO> appliClientDTOList = new ArrayList<AppliClientDTO>();
        PolicyHolder policyHolder = standerPacket.getBody().getPolicyHolder();
        AppliClientDTO appliClientDTO = AppliClientDTO.builder().insuredName(policyHolder.getPolicyHolderName()).insuredEname(policyHolder.getPolicyHolderEname()).birthday(policyHolder.getPhBirthDate()).insuredType(policyHolder.getPolicyHolderType()).identifyNumber(policyHolder.getPhIdNumber()).identifyType(policyHolder.getPhIdType()).birthday(policyHolder.getPhBirthDate()).insuredAddress(policyHolder.getPhAddress()).email(policyHolder.getPhEmail()).build();
        if ("1".equals(policyHolder.getPolicyHolderType())) {
            appliClientDTO.setMobile(policyHolder.getPhTelephone());
        } else {
            appliClientDTO.setContactPhone(policyHolder.getPhTelephone());
        }
        appliClientDTOList.add(appliClientDTO);
        return appliClientDTOList;
    }

    private MainDTO buildMainDTO(StanderPacket standerPacket) {
        Policy policy = standerPacket.getBody().getPolicy();
        MainDTO mainDTO = MainDTO.builder().build();
        mainDTO.setOrderNo(policy.getAgencyPolicyRef());
        mainDTO.setInputDate(policy.getIssueDate());
        mainDTO.setStartDate(policy.getEffectiveDate());
        mainDTO.setEndDate(policy.getExpireDate());
        mainDTO.setSumPremium(Double.valueOf(policy.getTotalPremium().doubleValue()));
        mainDTO.setOutRemark(policy.getRemark());
        mainDTO.setSumQuantity(policy.getGroupSize());
        return mainDTO;
    }
}

