/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util;

import cn.hutool.core.lang.PatternPool;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.IdNumberUtil;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class IdNumberUtil {
    private static final Logger log = LoggerFactory.getLogger(IdNumberUtil.class);
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;

    private boolean isInWhiteListAllowUsingOtherDocument(String idType, String riskCode, PersonnelType personType, ClientType clientType, String channelCode, String userCode) {
        if (ObjectUtil.isNotEmpty((Object)channelCode) || ObjectUtil.isNotEmpty((Object)userCode)) {
            ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
            apisChannelConfigs.setConfigCode("AGENT_ALLOW_OTHER_DOC");
            String personnelType = null != personType ? personType.code : "";
            String customerType = null != clientType ? ClientType.access$000((ClientType)clientType) : "";
            apisChannelConfigs.setDeleted(Integer.valueOf(0));
            String prefix = RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code + "white:list:";
            List apisChannelConfigsList = this.redisTemplateUtil.getApisChannelConfigList(apisChannelConfigs, prefix);
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigsList)) {
                boolean isInWhiteList = apisChannelConfigsList.stream().anyMatch(p -> !(!ObjectUtil.isEmpty((Object)p.getValueType()) && !p.getValueType().equals(personnelType) || !ObjectUtil.isEmpty((Object)p.getConfigValue()) && !p.getConfigValue().equals(idType) || !ObjectUtil.isEmpty((Object)p.getRationCode()) && !p.getRationCode().equals(customerType) || !ObjectUtil.isEmpty((Object)p.getProductCode()) && !p.getProductCode().contains(riskCode) || !ObjectUtil.isEmpty((Object)p.getUserCode()) && !p.getUserCode().equals(userCode) || !ObjectUtil.isEmpty((Object)p.getChannelCode()) && !p.getChannelCode().equals(channelCode)));
                return isInWhiteList;
            }
        }
        return false;
    }

    public boolean whetherAllowUsingOtherDocument(String idType, String riskCode, PersonnelType personType, ClientType clientType, String channelCode, String userCode) {
        boolean existConfig;
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        String personnelType = null != personType ? personType.code : "";
        String customerType = null != clientType ? ClientType.access$000((ClientType)clientType) : "";
        apisChannelConfigs.setConfigCode("NO_ALLOW_OTHER_DOCUMENTS");
        apisChannelConfigs.setDeleted(Integer.valueOf(0));
        apisChannelConfigs.setValueType(personnelType);
        apisChannelConfigs.setConfigValue(idType);
        apisChannelConfigs.setRationCode(customerType);
        String prefix = RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code + (null != idType ? idType : "") + ":" + personnelType + ":" + customerType + ":";
        List apisChannelConfigsList = this.redisTemplateUtil.getApisChannelConfigList(apisChannelConfigs, prefix);
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigsList) && (existConfig = apisChannelConfigsList.stream().anyMatch(acc -> null != acc && StrUtil.contains((CharSequence)acc.getProductCode(), (CharSequence)riskCode)))) {
            if (this.isInWhiteListAllowUsingOtherDocument(idType, riskCode, personType, clientType, channelCode, userCode)) {
                log.warn("\u6e20\u9053\uff1a{}\uff0c\u8d26\u53f7\uff1a{}\u5728\u767d\u540d\u5355\u4e2d\uff0c\u5f00\u653e\u4f7f\u7528\u8bc1\u4ef6\u7c7b\u578b\uff1a{}\u6295\u4fdd", new Object[]{channelCode, userCode, idType});
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean validateIdNumberByIdType(String idType, String idCard) {
        if ("74".equals(idType)) {
            return this.validateUnifiedSocialCreditCode(idCard);
        }
        if ("73".equals(idType)) {
            return this.validateBusinessLicenseNumber(idCard);
        }
        if ("72".equals(idType)) {
            return this.validateTaxRegistrationCertificate(idCard);
        }
        if ("71".equals(idType)) {
            return this.validateOrganizationCode(idCard);
        }
        if ("11".equals(idType)) {
            return this.validateHomeVisitedCertificate(idCard);
        }
        if ("15".equals(idType)) {
            return this.validateBirthCertificate(idCard);
        }
        if ("16".equals(idType)) {
            return this.validateMtp4tr(idCard);
        }
        if ("07".equals(idType)) {
            return this.validateChinaPassport(idCard);
        }
        if ("09".equals(idType)) {
            return this.validateHkmPass(idCard);
        }
        return true;
    }

    public boolean regexMatch(String regex, String str) {
        Pattern pattern = PatternPool.get((String)regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public boolean isValidate(String regex) {
        return StringUtils.isNotBlank((CharSequence)regex) && !"NoData".equalsIgnoreCase(regex) && !"NoCheck".equalsIgnoreCase(regex);
    }

    public boolean regexMatchByConfig(String regex, String str) {
        if (this.isValidate(regex)) {
            return this.regexMatch(regex, str);
        }
        return true;
    }

    public boolean validateUnifiedSocialCreditCode(String idCard) {
        String regTysh = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_ID_NO_TYSH", RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code);
        return this.regexMatchByConfig(regTysh, idCard);
    }

    public boolean validateBusinessLicenseNumber(String idCard) {
        String regYyzz = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_ID_NO_YYZZ", RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code);
        return this.regexMatchByConfig(regYyzz, idCard);
    }

    public boolean validateOrganizationCode(String idCard) {
        String regZzjg = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_ID_NO_ZZJG", RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code);
        return this.regexMatchByConfig(regZzjg, idCard);
    }

    public boolean validateTaxRegistrationCertificate(String idCard) {
        String regSwdj = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_ID_NO_SWDJ", RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code);
        return this.regexMatchByConfig(regSwdj, idCard);
    }

    public boolean validateHomeVisitedCertificate(String idCard) {
        String regHxz = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_ID_NO_HXZ", RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code);
        return this.regexMatchByConfig(regHxz, idCard);
    }

    public boolean validateBirthCertificate(String idCard) {
        String regCsz = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_ID_NO_CSZ", RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code);
        return this.regexMatchByConfig(regCsz, idCard);
    }

    public boolean validateMtp4tr(String idCard) {
        String regTbz = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_ID_NO_TBZ", RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code);
        return this.regexMatchByConfig(regTbz, idCard);
    }

    public boolean validateChinaPassport(String idCard) {
        String regZghz = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_ID_NO_ZGHZ", RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code);
        return this.regexMatchByConfig(regZghz, idCard);
    }

    public boolean validateHkmPass(String idCard) {
        String regGatxz = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_ID_NO_GATXZ", RedisTemplateUtil.RedisConfigCodePrefix.REG_ID_NUMBER.code);
        return this.regexMatchByConfig(regGatxz, idCard);
    }
}

