/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.IdNumberUtil;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.RedisTemplateUtil;
import com.jdaz.sinosoftgz.apis.business.app.starter.constants.BusinessConstants;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisDataCompletionException;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.business.app.starter.utils.BaseCodeConvertUtils;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderBody;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderPacket;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderHeader;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.request.StanderRequest;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.AppliClientDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.BeneficiaryDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.InsuredDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.ItemMainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.MainDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.request.QuotePriceDTO;
import com.jdaz.sinosoftgz.apis.commons.model.api.insure.resp.InsuredPremiumDTO;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.entity.ApisBusiAsyncChannelOrder;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.entity.ApisBusiAsyncChannelOrderIns;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncChannelOrderInsService;
import com.jdaz.sinosoftgz.apis.commons.model.asynInsure.service.ApisBusiAsyncChannelOrderService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelCodeService;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfpRationMain;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.entity.ApisPfsInsuredType;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfpRationClauseKindFactoryMapper;
import com.jdaz.sinosoftgz.apis.commons.model.pfp.mapper.ApisPfsInsuredTypeMapper;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.dsl.GeneralRegxs;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationClauseKindFactoryService;
import com.jdaz.sinosoftgz.apis.commons.service.pfp.service.ApisPfpRationMainService;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorBisCodeEnum;
import com.jdaz.sinosoftgz.apis.constants.ErrorNullValueCodeEnum;
import com.jdaz.sinosoftgz.coreapi.insure.CoreInsureApi;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import sinosoftgz.utils.data.DateUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class QuotePriceValidate {
    private static Logger log = LoggerFactory.getLogger(QuotePriceValidate.class);
    @Autowired
    private ApisChannelConfigsService apisChannelConfigsService;
    @Autowired
    private ApisPfpRationMainService apisPfpRationMainService;
    @Autowired
    private RedisTemplateUtil redisTemplateUtil;
    @Autowired
    CoreInsureApi coreInsureApi;
    @Autowired
    ApisChannelCodeService apisChannelCodeService;
    @Autowired
    ApisBusinessService apisBusinessService;
    @Value(value="${system.backSignSwitch}")
    private String backSignSwitch;
    @Autowired
    private IdNumberUtil idNumberUtil;
    @Autowired
    BaseCodeConvertUtils baseCodeConvertUtils;
    @Autowired
    ApisPfsInsuredTypeMapper apisPfsInsuredTypeMapper;
    @Autowired
    ApisPfpRationClauseKindFactoryMapper apisPfpRationClauseKindFactoryMapper;
    @Autowired
    ApisBusiAsyncChannelOrderService apisBusiAsyncChannelOrderService;
    @Autowired
    ApisBusiAsyncChannelOrderInsService apisBusiAsyncChannelOrderInsService;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ApisPfpRationClauseKindFactoryService apisPfpRationClauseKindFactoryService;
    private static String[] PLAN_YEAR_ARRAY = new String[]{"4", "7", "8", "10", "11"};
    public static String[] ACCIDENT_HEALTH_RISKCODE = new String[]{"P090001", "P070005", "P070002", "P070006", "P070004", "P090002"};

    public void verifyRepeatRequest(StanderPacket standerPacket) throws ApisBusinessException {
        String orderNo = standerPacket.getBody().getPolicy().getAgencyPolicyRef();
        String userCode = standerPacket.getUserCode();
        if (!this.lock(userCode + standerPacket.getHead().getRequestType() + orderNo)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10007.getValue(), ChannelErrorCodeEnum.ERR_C10007.getKey());
        }
    }

    public boolean lock(String key) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)key, 3L, TimeUnit.MINUTES);
    }

    public void unLock(StanderPacket standerPacket) {
        String orderNo = standerPacket.getBody().getPolicy().getAgencyPolicyRef();
        String userCode = standerPacket.getUserCode();
        this.redisTemplate.delete((Object)(userCode + standerPacket.getHead().getRequestType() + orderNo));
    }

    public StanderPacket checkIdempotent(StanderPacket standerPacket) {
        String orderNo = standerPacket.getBody().getPolicy().getAgencyPolicyRef();
        String userCode = standerPacket.getUserCode();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"user_code", (Object)userCode);
        queryWrapper.eq((Object)"agency_policy_ref", (Object)orderNo);
        ApisBusiAsyncChannelOrder apisBusiAsyncChannelOrder = (ApisBusiAsyncChannelOrder)this.apisBusiAsyncChannelOrderService.getOne((Wrapper)queryWrapper, false);
        if (ObjectUtil.isNotEmpty((Object)apisBusiAsyncChannelOrder)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"agency_policy_ref", (Object)orderNo);
            List apisBusiAsyncChannelOrderInsList = this.apisBusiAsyncChannelOrderInsService.list((Wrapper)wrapper);
            if (ObjectUtil.isNotEmpty((Object)apisBusiAsyncChannelOrderInsList)) {
                Date startDate = Date.from(apisBusiAsyncChannelOrder.getEffectiveDate().atZone(ZoneId.systemDefault()).toInstant());
                Date endDate = Date.from(apisBusiAsyncChannelOrder.getExpireDate().atZone(ZoneId.systemDefault()).toInstant());
                Date issueDate = Date.from(apisBusiAsyncChannelOrder.getIssueDate().atZone(ZoneId.systemDefault()).toInstant());
                StanderBody standerBody = StanderBody.builder().agencyPolicyRef(orderNo).policyRef(apisBusiAsyncChannelOrder.getPolicyRef()).effectiveDate(startDate).expireDate(endDate).ePolicyUrl(apisBusiAsyncChannelOrder.getEpolicyUrl()).issueDate(issueDate).totalPremium(apisBusiAsyncChannelOrder.getTotalPremium()).policyStatus(apisBusiAsyncChannelOrder.getStatus()).build();
                ArrayList<InsuredPremiumDTO> insuredPremiumList = new ArrayList<InsuredPremiumDTO>();
                for (ApisBusiAsyncChannelOrderIns asyncChannelOrderIns : apisBusiAsyncChannelOrderInsList) {
                    InsuredPremiumDTO insuredPremiumDTO = InsuredPremiumDTO.builder().insuredId(asyncChannelOrderIns.getInsuredId().toString()).insuredName(asyncChannelOrderIns.getInsuredName()).premium(Double.valueOf(asyncChannelOrderIns.getPremium().doubleValue())).build();
                    insuredPremiumList.add(insuredPremiumDTO);
                }
                standerBody.setInsuredPremiumList(insuredPremiumList);
                StanderHead head = standerPacket.getHead();
                head.setResponseCode("1");
                StanderPacket packet = StanderPacket.builder().head(head).body(standerBody).build();
                return packet;
            }
        }
        return null;
    }

    public void verifyRepeatInsurance(StanderRequest standerRequest) throws ApisBusinessException {
        Date startDate;
        String rationCode;
        String idNo = ((AppliClientDTO)standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getAppliClient().get(0)).getIdentifyNumber();
        int count = this.apisBusiAsyncChannelOrderService.verifyRepeatInsurance(idNo, rationCode = ((ItemMainDTO)standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getItemMainList().get(0)).getGoodsCode(), startDate = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getStartDate());
        if (count > 0) {
            String rationName = ((ItemMainDTO)standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getItemMainList().get(0)).getGoodsName();
            Date endDate = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getEndDate();
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10752.getValue().replaceFirst("##", idNo).replaceFirst("##", rationName).replaceFirst("##", DateUtil.format((Date)startDate, (String)"yyyy-MM-dd HH:mm:ss") + "~" + DateUtil.format((Date)endDate, (String)"yyyy-MM-dd HH:mm:ss")), ChannelErrorCodeEnum.ERR_C10752.getKey());
        }
    }

    public void validateRequest(StanderRequest standerRequest) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        ArrayList<ApisPfpRationMain> apisPfpRationMainList = new ArrayList<ApisPfpRationMain>();
        for (ItemMainDTO item : quotePriceDTO.getCoverage().getItemList()) {
            ApisPfpRationMain apm = this.apisPfpRationMainService.getPlanMain(item.getGoodsCode());
            apisPfpRationMainList.add(apm);
        }
        this.verifyRepeatInsurance(standerRequest);
        this.validNull(standerRequest, (ApisPfpRationMain)apisPfpRationMainList.get(0));
        this.validFormat(standerRequest, (ApisPfpRationMain)apisPfpRationMainList.get(0));
        this.validProduct(standerRequest, apisPfpRationMainList);
    }

    public void validNull(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        MainDTO mainDTO = quotePriceDTO.getMain();
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10384.getValue(), ChannelErrorCodeEnum.ERR_C10384.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getInsuredName())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10387.getValue(), ChannelErrorCodeEnum.ERR_C10387.getKey());
            }
            if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
                if ("1".equals(appliClientDTO.getInsuredType())) {
                    if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyType())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10385.getValue(), ChannelErrorCodeEnum.ERR_C10385.getKey());
                    }
                    if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyNumber())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10386.getValue(), ChannelErrorCodeEnum.ERR_C10386.getKey());
                    }
                }
            } else {
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyType())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10082.getValue(), ChannelErrorCodeEnum.ERR_C10082.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10083.getValue(), ChannelErrorCodeEnum.ERR_C10083.getKey());
                }
            }
            if (Arrays.asList(BusinessConstants.HOME_PROPERTY_RISKCODE).contains(mainDTO.getRiskCode()) && "1".equals(appliClientDTO.getInsuredType()) && ObjectUtil.isEmpty((Object)appliClientDTO.getBirthday())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10079.getValue(), ChannelErrorCodeEnum.ERR_C10079.getKey());
            }
            if ("1".equals(appliClientDTO.getReqElecFaPiao()) && StringUtils.isEmpty((CharSequence)appliClientDTO.getEmail()) && StringUtils.isEmpty((CharSequence)appliClientDTO.getMobile())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10130.getValue(), ChannelErrorCodeEnum.ERR_C10130.getKey());
            }
            if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode()) || !StringUtils.isNotEmpty((CharSequence)appliClientDTO.getReqFaPiao()) || !"1".equals(appliClientDTO.getReqFaPiao())) continue;
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getMailType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10070.getValue(), ChannelErrorCodeEnum.ERR_C10070.getKey());
            }
            if (StringUtils.isEmpty((CharSequence)appliClientDTO.getPhAddress())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10072.getValue(), ChannelErrorCodeEnum.ERR_C10072.getKey());
            }
            if (!StringUtils.isEmpty((CharSequence)appliClientDTO.getInvoiceTitle())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10071.getValue(), ChannelErrorCodeEnum.ERR_C10071.getKey());
        }
        if (StringUtils.isEmpty((CharSequence)mainDTO.getOrderNo())) {
            throw new ApisBusinessException("\u7b2c\u4e09\u65b9\u6e20\u9053\u516c\u53f8\u4fdd\u5355\u53f7\u7801\u6216\u8005\u7b2c\u4e09\u65b9\u6e20\u9053\u516c\u53f8\u8ba2\u5355\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a", ChannelErrorCodeEnum.ERR_C10008.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getStartDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10066.getValue(), ChannelErrorCodeEnum.ERR_C10066.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10066.getValue(), ChannelErrorCodeEnum.ERR_C10066.getKey());
        }
        if (ObjectUtil.isEmpty((Object)mainDTO.getInputDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10391.getValue(), ChannelErrorCodeEnum.ERR_C10391.getKey());
        }
    }

    public void validateIdNumberByIdType(String idType, String idCard, String riskCode, IdNumberUtil.PersonnelType personType, IdNumberUtil.ClientType clientType, String channelCode, String userCode) throws ApisBusinessException {
        if (!this.idNumberUtil.whetherAllowUsingOtherDocument(idType, riskCode, personType, clientType, channelCode, userCode)) {
            String idTypeDesc = (String)BusinessConstants.idTypeDescMap.get(idType);
            if (StrUtil.isBlank((CharSequence)idTypeDesc)) {
                idTypeDesc = idType;
            }
            if (IdNumberUtil.ClientType.CLIENT == clientType) {
                if (IdNumberUtil.PersonnelType.HOLDER == personType) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10646.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10646.getKey());
                }
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10645.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10645.getKey());
            }
            if (IdNumberUtil.PersonnelType.HOLDER == personType) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10636.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10636.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10635.getValue().replaceFirst("##", idTypeDesc), ChannelErrorCodeEnum.ERR_C10635.getKey());
        }
        if (!this.idNumberUtil.validateIdNumberByIdType(idType, idCard)) {
            if (IdNumberUtil.PersonnelType.HOLDER == personType) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replaceFirst("##", idCard), ChannelErrorCodeEnum.ERR_C10073.getKey());
            }
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10078.getValue().replaceFirst("##", idCard), ChannelErrorCodeEnum.ERR_C10078.getKey());
        }
    }

    public void validFormat(StanderRequest standerRequest, ApisPfpRationMain apisPfpRationMain) throws ApisBusinessException {
        String regexEnName;
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        StanderHeader header = standerRequest.getHeader();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        if (!DateUtils.dateToStr((Date)mainDTO.getStartDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "startDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        if (!DateUtils.dateToStr((Date)mainDTO.getEndDate(), (String)"yyyyMMddHHmmss").matches(GeneralRegxs.DateFormat)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10009.getValue().replaceFirst("##", "endDate").replace("##", "yyyyMMddHHmmss"), ChannelErrorCodeEnum.ERR_C10009.getKey());
        }
        String regexName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        if (StringUtils.isBlank((CharSequence)regexName) || "NoData".equalsIgnoreCase(regexName)) {
            regexName = GeneralRegxs.Name_2;
        }
        if (StringUtils.isBlank((CharSequence)(regexEnName = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_NAME_EN", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code))) || "NoData".equalsIgnoreCase(regexEnName)) {
            regexEnName = GeneralRegxs.Ename;
        }
        boolean isValidEname = StringUtils.isNotBlank((CharSequence)regexEnName) && !"NoCheck".equals(regexEnName);
        String regexContactInfo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_CONTACT_INFO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        String regexMobileNo = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_MOBILE_NO", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        String regexContactPhone = this.redisTemplateUtil.getApisChannelConfigsByConfigCode("REG_CONTACT_PHONE", RedisTemplateUtil.RedisConfigCodePrefix.REG_CONTACT_INFO.code);
        boolean isValidContactInfoFormat = StringUtils.isNotBlank((CharSequence)regexContactInfo) && !"NoData".equalsIgnoreCase(regexContactInfo) && !"NoCheck".equalsIgnoreCase(regexContactInfo);
        boolean isValidMobileNoFormat = StringUtils.isNotBlank((CharSequence)regexMobileNo) && !"NoData".equalsIgnoreCase(regexMobileNo) && !"NoCheck".equalsIgnoreCase(regexMobileNo);
        boolean isValidContactPhone = StringUtils.isNotBlank((CharSequence)regexContactPhone) && !"NoData".equalsIgnoreCase(regexContactPhone) && !"NoCheck".equalsIgnoreCase(regexContactPhone);
        for (AppliClientDTO appliClientDTO : appliClientList) {
            if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode()) && !"NoCheck".equalsIgnoreCase(regexName) && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getInsuredName()) && !appliClientDTO.getInsuredName().trim().replace(" ", "").matches(regexName)) {
                log.warn("\u59d3\u540d\u6821\u9a8c\u62e6\u622a\uff0c\u6b63\u5219\u8868\u8fbe\u5f0f\uff1a{}", (Object)regexName);
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10477.getValue().replaceFirst("##", appliClientDTO.getInsuredName()).replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10477.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getInsuredEname()) && isValidEname && !appliClientDTO.getInsuredEname().trim().matches(regexEnName)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", appliClientDTO.getInsuredEname()), ChannelErrorCodeEnum.ERR_C10619.getKey());
            }
            if ("1".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("2".equals(appliClientDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(appliClientDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("01".equals(appliClientDTO.getIdentifyType()) || "13".equals(appliClientDTO.getIdentifyType())) {
                if (StringUtils.isNotBlank((CharSequence)appliClientDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)appliClientDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10073.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10073.getKey());
                }
                String birthDateStr = IdcardUtil.getBirth((String)appliClientDTO.getIdentifyNumber());
                if (ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday())) {
                    String birthDay = DateUtils.dateToStr((Date)appliClientDTO.getBirthday(), (String)"yyyyMMdd");
                    if (!birthDateStr.equals(birthDay)) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10240.getValue().replace("##", appliClientDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10240.getKey());
                    }
                } else {
                    try {
                        appliClientDTO.setBirthday(DateUtils.parseToDate((String)birthDateStr, (String)"yyyyMMdd"));
                    }
                    catch (Exception e) {
                        log.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
                    }
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getSex())) {
                    appliClientDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)appliClientDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                } else if (!appliClientDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)appliClientDTO.getIdentifyNumber()) == 1 ? 1 : 2))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10616.getValue(), ChannelErrorCodeEnum.ERR_C10616.getKey());
                }
            } else {
                IdNumberUtil.ClientType clientType = null;
                if ("1".equals(appliClientDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.PERSONAL;
                } else if ("2".equals(appliClientDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.CLIENT;
                }
                this.validateIdNumberByIdType(appliClientDTO.getIdentifyType(), appliClientDTO.getIdentifyNumber(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.HOLDER, clientType, header.getChannelCode(), header.getUserCode());
            }
            if (isValidContactInfoFormat) {
                if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getMobile()) && !appliClientDTO.getMobile().matches(regexContactInfo)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", appliClientDTO.getMobile()), ChannelErrorCodeEnum.ERR_C10618.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)appliClientDTO.getContactPhone()) && isValidMobileNoFormat && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getMobile()) && !appliClientDTO.getMobile().matches(regexMobileNo)) {
                    appliClientDTO.setContactPhone(appliClientDTO.getMobile());
                    appliClientDTO.setMobile(null);
                }
            }
            if (isValidContactPhone && StringUtils.isNotEmpty((CharSequence)appliClientDTO.getContactPhone()) && !appliClientDTO.getContactPhone().matches(regexContactPhone)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", appliClientDTO.getContactPhone()), ChannelErrorCodeEnum.ERR_C10618.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)appliClientDTO.getEmail()) && !appliClientDTO.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10132.getValue(), ChannelErrorCodeEnum.ERR_C10132.getKey());
            }
            if (!StringUtils.isNotEmpty((CharSequence)appliClientDTO.getTaxPayerId()) || appliClientDTO.getTaxPayerId().matches(GeneralRegxs.TaxpayerId)) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10478.getValue(), ChannelErrorCodeEnum.ERR_C10478.getKey());
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (InsuredDTO insuredDTO : insuredList) {
            String birthDateStr;
            if ("1".equals(insuredDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_PERSONAL).contains(insuredDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if ("2".equals(insuredDTO.getInsuredType()) && !Arrays.asList(BusinessConstants.ID_TYPE_COMPANY).contains(insuredDTO.getIdentifyType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10608.getValue(), ChannelErrorCodeEnum.ERR_C10608.getKey());
            }
            if (map.containsKey(insuredDTO.getInsuredIDCache())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10221.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10221.getKey());
            }
            map.put(insuredDTO.getInsuredIDCache(), insuredDTO.getInsuredName());
            if (idMap.containsKey(insuredDTO.getIdentifyNumber())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10404.getValue(), ChannelErrorCodeEnum.ERR_C10404.getKey());
            }
            idMap.put(insuredDTO.getIdentifyNumber(), insuredDTO.getInsuredName());
            if (Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
                if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredName()) && insuredDTO.getInsuredName().trim().length() < 2 && !insuredDTO.getInsuredName().trim().replace(" ", "").matches(GeneralRegxs.Name)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10134.getValue(), ChannelErrorCodeEnum.ERR_C10134.getKey());
                }
                if (!"NoCheck".equalsIgnoreCase(regexName) && StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredName()) && !insuredDTO.getInsuredName().trim().replace(" ", "").matches(regexName)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10477.getValue().replaceFirst("##", insuredDTO.getInsuredName()).replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10477.getKey());
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getInsuredEname()) && isValidEname && !insuredDTO.getInsuredEname().trim().matches(regexEnName)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10619.getValue().replaceFirst("##", insuredDTO.getInsuredEname()), ChannelErrorCodeEnum.ERR_C10619.getKey());
            }
            if (StringUtils.isNotBlank((CharSequence)insuredDTO.getSecondIdNum()) && StringUtils.isBlank((CharSequence)insuredDTO.getSecondIdType()) || StringUtils.isBlank((CharSequence)insuredDTO.getSecondIdNum()) && StringUtils.isNotBlank((CharSequence)insuredDTO.getSecondIdType())) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10709.getValue(), ChannelErrorCodeEnum.ERR_C10709.getKey());
            }
            if (StringUtils.isNotBlank((CharSequence)insuredDTO.getSecondIdType())) {
                if ("01".equals(insuredDTO.getSecondIdType()) || "13".equals(insuredDTO.getSecondIdType())) {
                    if (StringUtils.isNotBlank((CharSequence)insuredDTO.getSecondIdNum()) && !IdcardUtil.isValidCard((String)insuredDTO.getSecondIdNum())) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10118.getValue().replace("##", insuredDTO.getSecondIdNum()), ChannelErrorCodeEnum.ERR_C10118.getKey());
                    }
                    birthDateStr = IdcardUtil.getBirth((String)insuredDTO.getIdentifyNumber());
                    if (ObjectUtils.isEmpty((Object)insuredDTO.getBirthday())) {
                        insuredDTO.setBirthday(DateUtils.strToDate((String)birthDateStr, (String)"yyyyMMdd"));
                    } else if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                    }
                    if (StringUtils.isEmpty((CharSequence)insuredDTO.getSex())) {
                        insuredDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getSecondIdNum()) == 1 ? 1 : 2));
                    } else if (!insuredDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getSecondIdNum()) == 1 ? 1 : 2))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10617.getValue(), ChannelErrorCodeEnum.ERR_C10617.getKey());
                    }
                } else {
                    IdNumberUtil.ClientType clientType = null;
                    if ("1".equals(insuredDTO.getInsuredType())) {
                        clientType = IdNumberUtil.ClientType.PERSONAL;
                    } else if ("2".equals(insuredDTO.getInsuredType())) {
                        clientType = IdNumberUtil.ClientType.CLIENT;
                    }
                    this.validateIdNumberByIdType(insuredDTO.getSecondIdType(), insuredDTO.getSecondIdNum(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.INSURE, clientType, header.getChannelCode(), header.getUserCode());
                }
            }
            if ("01".equals(insuredDTO.getIdentifyType()) || "13".equals(insuredDTO.getIdentifyType())) {
                if (StringUtils.isNotBlank((CharSequence)insuredDTO.getIdentifyNumber()) && !IdcardUtil.isValidCard((String)insuredDTO.getIdentifyNumber())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10118.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10118.getKey());
                }
                birthDateStr = IdcardUtil.getBirth((String)insuredDTO.getIdentifyNumber());
                if (ObjectUtils.isEmpty((Object)insuredDTO.getBirthday())) {
                    insuredDTO.setBirthday(DateUtils.strToDate((String)birthDateStr, (String)"yyyyMMdd"));
                } else if (!birthDateStr.equals(DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10119.getValue().replace("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10119.getKey());
                }
                if (StringUtils.isEmpty((CharSequence)insuredDTO.getSex())) {
                    insuredDTO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getIdentifyNumber()) == 1 ? 1 : 2));
                } else if (!insuredDTO.getSex().equals(String.valueOf(IdcardUtil.getGenderByIdCard((String)insuredDTO.getIdentifyNumber()) == 1 ? 1 : 2))) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10617.getValue(), ChannelErrorCodeEnum.ERR_C10617.getKey());
                }
            } else {
                IdNumberUtil.ClientType clientType = null;
                if ("1".equals(insuredDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.PERSONAL;
                } else if ("2".equals(insuredDTO.getInsuredType())) {
                    clientType = IdNumberUtil.ClientType.CLIENT;
                }
                this.validateIdNumberByIdType(insuredDTO.getIdentifyType(), insuredDTO.getIdentifyNumber(), mainDTO.getRiskCode(), IdNumberUtil.PersonnelType.INSURE, clientType, header.getChannelCode(), header.getUserCode());
            }
            if (isValidContactInfoFormat && StringUtils.isNotEmpty((CharSequence)insuredDTO.getMobile()) && !insuredDTO.getMobile().matches(regexContactInfo)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", insuredDTO.getMobile()), ChannelErrorCodeEnum.ERR_C10618.getKey());
            }
            if (isValidContactPhone && StringUtils.isNotEmpty((CharSequence)insuredDTO.getContactPhone()) && !insuredDTO.getContactPhone().matches(regexContactPhone)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10618.getValue().replace("##", insuredDTO.getContactPhone()), ChannelErrorCodeEnum.ERR_C10618.getKey());
            }
            if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getEmail()) && !insuredDTO.getEmail().matches(GeneralRegxs.Email)) {
                throw new ApisBusinessException("\u88ab\u4fdd\u9669\u4eba\u3010" + insuredDTO.getInsuredName() + "\u3011\u3010\u8bc1\u4ef6\u53f7" + insuredDTO.getIdentifyNumber() + "\u3011\u90ae\u7bb1\u3010" + insuredDTO.getEmail() + "\u3011\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u786e\u8ba4!", ChannelErrorCodeEnum.ERR_C10133.getKey());
            }
            if ("2".equals(insuredDTO.getBenefitModeCode()) && "1".equals(insuredDTO.getBenefitOrder())) {
                int sumShare = 0;
                for (BeneficiaryDTO beneficiaryDTO : insuredDTO.getBeneficiary()) {
                    int share = Integer.valueOf(beneficiaryDTO.getShare());
                    sumShare += share;
                }
                if (sumShare != 100) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10038.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10038.getKey());
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)insuredDTO.getRelationToAppnt()) || !"01".equals(insuredDTO.getRelationToAppnt()) || insuredDTO.getInsuredName().contains(((AppliClientDTO)appliClientList.get(0)).getInsuredName()) && insuredDTO.getIdentifyNumber().equals(((AppliClientDTO)appliClientList.get(0)).getIdentifyNumber())) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10138.getValue().replace("##", insuredDTO.getInsuredName()), ChannelErrorCodeEnum.ERR_C10138.getKey());
        }
        if (mainDTO.getSumQuantity().intValue() != insuredList.size()) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10036.getValue(), ChannelErrorCodeEnum.ERR_C10036.getKey());
        }
    }

    public void validProduct(StanderRequest standerRequest, List<ApisPfpRationMain> apisPfpRationMainList) throws ApisBusinessException {
        ApisPfpRationMain apisPfpRationMain = apisPfpRationMainList.get(0);
        QuotePriceDTO quotePriceDTO = standerRequest.getQuotePriceServiceRequest().getRequestBody().getQuotePrice();
        List appliClientList = quotePriceDTO.getAppliClient();
        List insuredList = quotePriceDTO.getInsuredList();
        MainDTO mainDTO = quotePriceDTO.getMain();
        Date startDate = mainDTO.getStartDate();
        long lessFifty = 0L;
        int parentCount = 0;
        int childCount = 0;
        boolean myCount = false;
        boolean spouseCount = false;
        int juveniles = 0;
        boolean adult = false;
        String caclMethod = "";
        if (!"ZR-SSBQ-FY-2C".equals(apisPfpRationMain.getRationCode()) && !"HY-GN- LAND-7D-WBHW-2C".equals(apisPfpRationMain.getRationCode())) {
            caclMethod = this.apisPfpRationClauseKindFactoryService.getCalculateMethod(apisPfpRationMain.getRationCode());
        }
        if (startDate.after(mainDTO.getEndDate())) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10067.getValue(), ChannelErrorCodeEnum.ERR_C10067.getKey());
        }
        ApisChannelConfigs channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("backSign");
        channelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
        ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isEmpty((Object)channelConfigs) && startDate.before(new Date()) && "1".equals(this.backSignSwitch)) {
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10035.getValue(), ChannelErrorCodeEnum.ERR_C10035.getKey());
        }
        for (Object appliClientDTO : appliClientList) {
            long year;
            if (!"1".equals(appliClientDTO.getInsuredType())) continue;
            ApisChannelConfigs apisChannelConfigsCondition = new ApisChannelConfigs();
            apisChannelConfigsCondition.setConfigCode("MINOR_INSURE_PLANS");
            apisChannelConfigsCondition.setUserCode(standerRequest.getHeader().getUserCode());
            apisChannelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigsCondition);
            if (ObjectUtil.isEmpty((Object)apisChannelConfigs) && ObjectUtil.isNotEmpty((Object)appliClientDTO.getBirthday()) && (year = (long)this.calculateAge(startDate, appliClientDTO.getBirthday())) < 18L) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10124.getValue(), ChannelErrorCodeEnum.ERR_C10124.getKey());
            }
            int age = this.calculateAge(mainDTO.getStartDate(), appliClientDTO.getBirthday());
            if (age >= 16 && age <= 65) continue;
            throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10753.getValue(), ChannelErrorCodeEnum.ERR_C10753.getKey());
        }
        channelConfigsCondition = new ApisChannelConfigs();
        channelConfigsCondition.setConfigCode("ONE_INSURED");
        channelConfigsCondition.setRationCode(apisPfpRationMain.getRationCode());
        ApisChannelConfigs configsOneInsured = this.apisChannelConfigsService.getChannelConfig(channelConfigsCondition);
        if (ObjectUtil.isNotEmpty((Object)insuredList) && insuredList.size() > 0) {
            if (ObjectUtil.isNotEmpty((Object)configsOneInsured) && insuredList.size() > 1) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10269.getValue(), ChannelErrorCodeEnum.ERR_C10269.getKey());
            }
            for (InsuredDTO insuredDTO : insuredList) {
                String[] arr;
                if ("01".equals(insuredDTO.getIdentifyType())) {
                    String birthDay;
                    String birthDateStr = IdcardUtil.getBirth((String)insuredDTO.getIdentifyNumber());
                    if (!birthDateStr.equals(birthDay = DateUtils.dateToStr((Date)insuredDTO.getBirthday(), (String)"yyyyMMdd"))) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10267.getValue(), ChannelErrorCodeEnum.ERR_C10267.getKey());
                    }
                    int age = this.calculateAge(mainDTO.getStartDate(), insuredDTO.getBirthday());
                    if (age < 16 || age > 65) {
                        throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10753.getValue(), ChannelErrorCodeEnum.ERR_C10753.getKey());
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)insuredDTO.getRelationToAppnt()) && StringUtils.isNotEmpty((CharSequence)apisPfpRationMain.getAppliRelation().trim()) && !Arrays.asList(arr = apisPfpRationMain.getAppliRelation().trim().split(",")).contains(insuredDTO.getRelationToAppnt())) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10135.getValue().replace("##", apisPfpRationMain.getRationCode()), ChannelErrorCodeEnum.ERR_C10135.getKey());
                }
                if (!Arrays.asList(PLAN_YEAR_ARRAY).contains(caclMethod) || QuotePriceValidate.isOutOneYear((Date)startDate, (Date)mainDTO.getEndDate(), (boolean)true) || !"01".equals(apisPfpRationMain.getPaymentType())) continue;
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10043.getValue(), ChannelErrorCodeEnum.ERR_C10043.getKey());
            }
        }
        if ("3".equals(mainDTO.getCalcType()) && Arrays.asList(ACCIDENT_HEALTH_RISKCODE).contains(mainDTO.getRiskCode())) {
            if ("P070002".equals(mainDTO.getRiskCode()) || "P090002".equals(mainDTO.getRiskCode())) {
                ApisChannelConfigs fityfAgeConfig = new ApisChannelConfigs();
                fityfAgeConfig.setConfigCode("doubleBelowFiftyAge");
                fityfAgeConfig.setRationCode(apisPfpRationMain.getRelateRationCode());
                ApisChannelConfigs acConfigs = this.apisChannelConfigsService.getChannelConfig(fityfAgeConfig);
                if (!(!"P070002P154".equals(apisPfpRationMain.getRelateRationCode()) && !ObjectUtil.isNotEmpty((Object)acConfigs) || "1".equals(mainDTO.getRenewalFlag()) || "underwrit".equals(standerRequest.getHeader().getBussinessType()) && StringUtils.isNotBlank((CharSequence)mainDTO.getRenewalPolicyNo()) || lessFifty >= 2L)) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10353.getValue().replaceFirst("##", "2").replace("##", "50"), ChannelErrorCodeEnum.ERR_C10353.getKey());
                }
                if (quotePriceDTO.getCoverage().getInsuredIdvList().size() < 2 || quotePriceDTO.getCoverage().getInsuredIdvList().size() > 8) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10352.getValue().replaceFirst("##", "2").replace("##", "8"), ChannelErrorCodeEnum.ERR_C10352.getKey());
                }
                if (myCount > true || spouseCount > true) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10356.getValue(), ChannelErrorCodeEnum.ERR_C10356.getKey());
                }
            }
            if ("P070006".equals(mainDTO.getRiskCode()) && ("11".equals(caclMethod) || "12".equals(caclMethod))) {
                if (childCount > 2) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10360.getValue(), ChannelErrorCodeEnum.ERR_C10360.getKey());
                }
                if (parentCount > 2) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10358.getValue(), ChannelErrorCodeEnum.ERR_C10358.getKey());
                }
                if (myCount > true || spouseCount > true) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10356.getValue(), ChannelErrorCodeEnum.ERR_C10356.getKey());
                }
                if (!myCount) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10357.getValue(), ChannelErrorCodeEnum.ERR_C10357.getKey());
                }
            }
            ApisChannelConfigs juvenileConfig = new ApisChannelConfigs();
            juvenileConfig.setConfigCode("juveniles_not_proposal");
            juvenileConfig.setRationCode(apisPfpRationMain.getRelateRationCode());
            ApisChannelConfigs apisChannelConfigs = this.apisChannelConfigsService.getChannelConfig(juvenileConfig);
            if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs) && juveniles > 0 && !adult) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10282.getValue(), ChannelErrorCodeEnum.ERR_C10282.getKey());
            }
        }
    }

    public static boolean isOutOneYear(Date start, Date end, boolean yearFlag) {
        long yearDays = 365L;
        if (start.after(end)) {
            return false;
        }
        Calendar startDay = Calendar.getInstance();
        Calendar endDay = Calendar.getInstance();
        startDay.setTime(start);
        endDay.setTime(end);
        long month = startDay.get(2) + 1;
        int year = month < 3L ? startDay.get(1) : endDay.get(1);
        if (DateUtil.isLeapYear((int)year)) {
            yearDays = 366L;
        }
        endDay.add(12, 1);
        long time = endDay.getTimeInMillis() - startDay.getTimeInMillis();
        long yearTime = DateUnit.DAY.getMillis() * yearDays + DateUnit.MINUTE.getMillis();
        if (time > yearTime) {
            return false;
        }
        return !yearFlag || yearTime - time <= DateUnit.MINUTE.getMillis();
    }

    public int calculateAge(Date startDate, Date birthDay) throws ApisDataCompletionException {
        if (ObjectUtil.isEmpty((Object)birthDay)) {
            log.error("\u88ab\u4fdd\u9669\u4eba\u51fa\u751f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApisDataCompletionException(ChannelErrorCodeEnum.ERR_C10401.getValue(), ChannelErrorCodeEnum.ERR_C10401.getKey());
        }
        if (ObjectUtil.isEmpty((Object)startDate)) {
            log.error("\u8d77\u4fdd\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ApisDataCompletionException(ErrorNullValueCodeEnum.ERR_N30003.getValue(), ErrorNullValueCodeEnum.ERR_N30003.getKey());
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        if (cal.before(birthDay)) {
            log.error("\u51fa\u751f\u65e5\u671f\u665a\u4e8e\u8d77\u4fdd\u65e5\u671f\uff0c\u65e0\u6cd5\u8ba1\u7b97\u5e74\u9f84");
            throw new ApisDataCompletionException(ErrorBisCodeEnum.ERR_B30004.getValue(), ErrorBisCodeEnum.ERR_B30004.getKey());
        }
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthDay);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        if (monthNow <= monthBirth) {
            if (monthNow == monthBirth) {
                if (dayOfMonthNow < dayOfMonthBirth) {
                    --age;
                }
            } else {
                --age;
            }
        }
        return age;
    }

    public void checkInsuredInfo(StanderRequest request) throws ApisBusinessException {
        String classCode = "";
        String planCode = "";
        if (StringUtils.isNotEmpty((CharSequence)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getPlanCode())) {
            planCode = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getPlanCode();
            ApisPfpRationMain apisPfpRationMain = this.apisPfpRationMainService.getPlanMain(planCode);
            classCode = apisPfpRationMain.getClassCode();
        } else {
            classCode = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getClassCode();
        }
        if (!"07".equals(classCode) && !"09".equals(classCode)) {
            return;
        }
        List insuredList = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getInsuredList();
        String alipayFlag = request.getQuotePriceServiceRequest().getRequestBody().getQuotePrice().getMain().getAlipayFlag();
        Date startDate = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getStartDate();
        if ("1".equals(alipayFlag)) {
            Date inputDate;
            startDate = inputDate = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getInputDate();
        }
        int index = 0;
        for (InsuredDTO insuredDTO : insuredList) {
            Date endDate = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getEndDate();
            Integer age = this.calculateAge(startDate, insuredDTO.getBirthday());
            String insuredType = insuredDTO.getInsuredType();
            ApisPfsInsuredType apisPfsInsuredType = this.apisPfsInsuredTypeMapper.queryByInsuredType(insuredType);
            if (ObjectUtil.isNotEmpty((Object)apisPfsInsuredType)) {
                if (age < apisPfsInsuredType.getAgeFrom() || age > apisPfsInsuredType.getAgeTo()) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10041.getValue().replaceFirst("##", insuredDTO.getInsuredName()).replaceFirst("##", insuredDTO.getIdentifyNumber()), ChannelErrorCodeEnum.ERR_C10041.getKey());
                }
            } else {
                log.error("\u4fdd\u8d39\u8ba1\u7b97\u6821\u9a8c>>\u6570\u636e\u5e93\u83b7\u53d6\u88ab\u4fdd\u9669\u4eba\u7c7b\u578b\u56e0\u5b50\u5931\u8d25");
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10210.getValue(), ChannelErrorCodeEnum.ERR_C10210.getKey());
            }
            int akIndex = request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().size() > 1 ? index : 0;
            String goodsCode = ((ItemMainDTO)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getCoverage().getItemList().get(akIndex)).getGoodsCode();
            List insuredTypeList = this.apisPfpRationClauseKindFactoryMapper.queryInsuredTypeByRationCode(goodsCode);
            log.warn("\u5f53\u524d\u7684\u5546\u54c1\u4ee3\u7801\u4e3a:{},\u88ab\u4fdd\u4eba\u7c7b\u578b\u4e3a:{}", (Object)goodsCode, (Object)insuredType);
            if (!insuredTypeList.contains(insuredType)) {
                throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10042.getValue().replaceFirst("##", insuredDTO.getInsuredName()).replaceFirst("##", insuredDTO.getIdentifyNumber()).replaceFirst("##", goodsCode), ChannelErrorCodeEnum.ERR_C10042.getKey());
            }
            String methodType = this.apisPfpRationClauseKindFactoryService.getCalculateMethod(goodsCode);
            if ("1".equals(methodType)) {
                long days = DateUtils.getDays((String)DateUtils.dateToStr((Date)endDate), (String)DateUtils.dateToStr((Date)request.getPolicyCalculateServiceRequest().getRequestBody().getQuotePrice().getMain().getStartDate()));
                SimpleDateFormat formatter = new SimpleDateFormat("HHmmss");
                Integer endHm = Integer.parseInt(formatter.format(endDate));
                if (endHm >= 235900) {
                    ++days;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("gdInsuredType", insuredType);
                map.put("rationCode", goodsCode);
                map.put("gd_day", days);
                List apisPfpRationClauseKindFactorys = this.apisPfpRationClauseKindFactoryMapper.getApisPfpRationClauseKindFactory(map);
                if (ObjectUtil.isEmpty((Object)apisPfpRationClauseKindFactorys) || apisPfpRationClauseKindFactorys.size() == 0) {
                    throw new ApisBusinessException(ChannelErrorCodeEnum.ERR_C10447.getValue(), ChannelErrorCodeEnum.ERR_C10447.getKey());
                }
            }
            ++index;
        }
    }
}

