/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jdaz.sinosoftgz.apis.commons.model.channel.entity.ApisChannelConfigs;
import com.jdaz.sinosoftgz.apis.commons.model.channel.service.ApisChannelConfigsService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class RedisTemplateUtil {
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    ApisChannelConfigsService apisChannelConfigsService;
    public static final String NO_DATA = "NoData";
    public static final String NO_CHECK = "NoCheck";
    private static Logger log = LoggerFactory.getLogger(RedisTemplateUtil.class);
    private final ReentrantLock queryLock = new ReentrantLock();
    private final ReentrantLock queryJsonLock = new ReentrantLock();

    public void setKey(String key, Object value, Long time, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)(null == value ? null : value.toString()), time.longValue(), timeUnit);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public String getKey(String key) {
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public String getApisChannelConfigsByConfigCode(String configCode, String prefix) {
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode(configCode);
        String val = null;
        try {
            val = this.getApisChannelConfigs(apisChannelConfigs, prefix);
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u914d\u7f6e\u6570\u636e\u3010config_code={}\u3011\u5931\u8d25\uff01", (Object)configCode, (Object)e);
        }
        return val;
    }

    public String getApisChannelConfigsByConfigCodeAndRationCode(String configCode, String rationCode, String prefix) {
        ApisChannelConfigs apisChannelConfigs = new ApisChannelConfigs();
        apisChannelConfigs.setConfigCode(configCode);
        apisChannelConfigs.setRationCode(rationCode);
        String val = null;
        try {
            val = this.getApisChannelConfigs(apisChannelConfigs, prefix);
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u914d\u7f6e\u6570\u636e\u3010config_code={}\u3011\u5931\u8d25\uff01", (Object)configCode, (Object)e);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getApisChannelConfigs(ApisChannelConfigs apisChannelConfigs, String prefix) throws InterruptedException {
        if (ObjectUtil.isEmpty((Object)apisChannelConfigs.getConfigCode())) {
            return null;
        }
        String key = apisChannelConfigs.getConfigCode();
        if (ObjectUtil.isNotEmpty((Object)apisChannelConfigs.getRationCode())) {
            key = apisChannelConfigs.getConfigCode() + ":" + apisChannelConfigs.getRationCode();
        }
        if (ObjectUtil.isNotEmpty((Object)prefix)) {
            key = prefix + key;
        }
        String val = this.getKey(key);
        if (!this.hasKey(key).booleanValue()) {
            this.queryLock.lockInterruptibly();
            try {
                val = this.getKey(key);
                if (!this.hasKey(key).booleanValue()) {
                    ApisChannelConfigs channelConfigs = this.apisChannelConfigsService.getChannelConfig(apisChannelConfigs);
                    val = ObjectUtil.isEmpty((Object)channelConfigs) || StringUtils.isEmpty((CharSequence)channelConfigs.getConfigValue()) ? null : channelConfigs.getConfigValue();
                    log.warn(String.format("\u67e5\u8be2\u6570\u636e\uff1a%s - %s", apisChannelConfigs.getConfigCode(), val));
                    this.setKey(key, (Object)val, Long.valueOf(RandomUtil.randomLong((long)541L, (long)601L)), TimeUnit.SECONDS);
                }
            }
            finally {
                this.queryLock.unlock();
            }
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getApisChannelConfigsJsonStr(ApisChannelConfigs apisChannelConfigs, String prefix) throws InterruptedException {
        if (ObjectUtil.isEmpty((Object)apisChannelConfigs.getConfigCode())) {
            return null;
        }
        String key = apisChannelConfigs.getConfigCode();
        if (ObjectUtil.isNotEmpty((Object)prefix)) {
            key = prefix + key;
        }
        String val = this.getKey(key);
        if (!this.hasKey(key).booleanValue()) {
            this.queryJsonLock.lockInterruptibly();
            try {
                val = this.getKey(key);
                if (!this.hasKey(key).booleanValue()) {
                    QueryWrapper queryWrapper = new QueryWrapper((Object)apisChannelConfigs);
                    List channelConfigList = this.apisChannelConfigsService.list((Wrapper)queryWrapper);
                    val = ObjectUtil.isEmpty((Object)channelConfigList) ? null : JSONArray.toJSONString((Object)channelConfigList);
                    log.warn(String.format("\u67e5\u8be2\u6570\u636e\uff1a%s - %s", apisChannelConfigs, val));
                    this.setKey(key, (Object)val, Long.valueOf(RandomUtil.randomLong((long)541L, (long)601L)), TimeUnit.SECONDS);
                }
            }
            finally {
                this.queryJsonLock.unlock();
            }
        }
        return val;
    }

    public List<ApisChannelConfigs> getApisChannelConfigList(ApisChannelConfigs apisChannelConfigs, String prefix) {
        String val = null;
        List<Object> ret = null;
        try {
            val = this.getApisChannelConfigsJsonStr(apisChannelConfigs, prefix);
            ret = ObjectUtil.isEmpty((Object)val) || NO_DATA.equalsIgnoreCase(val) ? new ArrayList<ApisChannelConfigs>(0) : JSONArray.parseArray((String)val, ApisChannelConfigs.class);
            return ret;
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u914d\u7f6e\u6570\u636e\u3010{}\u3011\u5931\u8d25\uff01", (Object)apisChannelConfigs.toString(), (Object)e);
            return null;
        }
    }

    public String generatePrefix(String prefix, Object ... args) {
        String ret;
        String string = ret = null == prefix ? "" : prefix;
        if (ObjectUtil.isNotEmpty((Object)args)) {
            for (Object obj : args) {
                ret = ret + obj + ":";
            }
        }
        return ret;
    }
}

