/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.web;

import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.aop.JDAZAesAnnotation;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.handler.StanderDdQuotePriceHandler;
import com.jdaz.sinosoftgz.apis.business.app.asyninsureapp.util.QuotePriceValidate;
import com.jdaz.sinosoftgz.apis.business.app.starter.exception.ApisBusinessException;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderHead;
import com.jdaz.sinosoftgz.apis.commons.model.api.base.StanderPacket;
import com.jdaz.sinosoftgz.apis.constants.ChannelErrorCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/TGW"})
public class DDController {
    private static final Logger log = LoggerFactory.getLogger(DDController.class);
    @Autowired
    StanderDdQuotePriceHandler standerDdQuotePriceHandler;
    @Autowired
    QuotePriceValidate quotePriceValidate;

    @PostMapping(value={"/DD-policyConfirm"})
    @JDAZAesAnnotation
    public StanderPacket policyConfirm(@Validated @RequestBody StanderPacket standerPacket) {
        try {
            return this.standerDdQuotePriceHandler.policyConfirm(standerPacket);
        }
        catch (ApisBusinessException e) {
            if (!ChannelErrorCodeEnum.ERR_C10007.getKey().equals(e.getErrorCode())) {
                this.quotePriceValidate.unLock(standerPacket);
            }
            StanderHead head = StanderHead.builder().requestId(standerPacket.getHead().getRequestId()).requestType(standerPacket.getHead().getRequestType()).responseCode("0").errorCode(e.getErrorCode()).errorMessage(e.getMessage()).build();
            return StanderPacket.builder().head(head).build();
        }
        catch (Exception e) {
            log.error("\u8fbe\u8fbe\u4e0b\u5355\u63a5\u53e3\u51fa\u9519\uff1a{}", (Throwable)e);
            this.quotePriceValidate.unLock(standerPacket);
            StanderHead head = StanderHead.builder().requestId(standerPacket.getHead().getRequestId()).requestType(standerPacket.getHead().getRequestType()).responseCode("0").errorCode(ChannelErrorCodeEnum.ERR_C10006.getKey()).errorMessage(ChannelErrorCodeEnum.ERR_C10006.getValue()).build();
            return StanderPacket.builder().head(head).build();
        }
    }
}

