/*
 * Decompiled with CFR 0.152.
 */
package com.jdaz.sinosoftgz.apis.business.app.starter.config;

import com.jdaz.sinosoftgz.apis.business.app.starter.config.HandlerFactoryProperties;
import com.jdaz.sinosoftgz.apis.business.app.starter.factory.BudinessHandlerFactory;
import com.jdaz.sinosoftgz.apis.business.app.starter.factory.impl.SpringBootPropertyBusinessHandlerFactory;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.ApisBusinessService;
import com.jdaz.sinosoftgz.apis.business.app.starter.service.impl.ApisBusinessServiceImpl;
import com.jdaz.sinosoftgz.apis.common.configs.MybatisAutoConfig;
import com.jdaz.sinosoftgz.apis.common.configs.RedisTemplateConfig;
import com.jdaz.sinosoftgz.apis.common.configs.SwaggerConfig;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.configs.DslLoaderProperties;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.ApisRuleRouteService;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.DslLoader;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.RuleExecutorService;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.impl.ApisRuleRouteServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.impl.ClasspathDslLoader;
import com.jdaz.sinosoftgz.apis.commons.rulesengine.service.impl.RuleExecutorServiceImpl;
import com.jdaz.sinosoftgz.apis.commons.service.configs.CommonOrikaAutoConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScans(value={@ComponentScan(value={"com.jdaz.sinosoftgz.apis.commons.model.*"}), @ComponentScan(value={"com.jdaz.sinosoftgz.apis.common.configs"}), @ComponentScan(value={"com.jdaz.sinosoftgz.apis.commons.service"}), @ComponentScan(value={"com.jdaz.sinosoftgz.coreapi.*"}), @ComponentScan(value={"com.jdaz.sinosoftgz.coreapi.claims.*"}), @ComponentScan(value={"com.jdaz.sinosoftgz.apis.business.app.starter.utils"})})
@ImportAutoConfiguration(value={MybatisAutoConfig.class, RedisTemplateConfig.class, SwaggerConfig.class, CommonOrikaAutoConfig.class})
@EnableConfigurationProperties(value={HandlerFactoryProperties.class})
@ConditionalOnMissingBean(value={ApisBusinessAutoConfig.class})
public class ApisBusinessAutoConfig {
    @Bean
    DslLoader dslLoader() {
        return ClasspathDslLoader.builder().loaderProperties(DslLoaderProperties.builder().className("com.jdaz.sinosoftgz.apis.commons.rulesengine.service.impl.ClasspathDslLoader").path("dsl/rules").suffix("dsl").build()).build();
    }

    @Bean
    ApisRuleRouteService apisRuleRouteService(@Autowired DslLoader dslLoader) {
        return new ApisRuleRouteServiceImpl(dslLoader);
    }

    @Bean
    RuleExecutorService ruleExecutorService() {
        return new RuleExecutorServiceImpl();
    }

    @Bean
    BudinessHandlerFactory budinessHandlerFactory(@Autowired HandlerFactoryProperties handlerFactoryProperties) {
        return new SpringBootPropertyBusinessHandlerFactory(handlerFactoryProperties);
    }

    @Bean
    ApisBusinessService apisBusinessService(@Autowired RuleExecutorService ruleExecutorService, @Autowired BudinessHandlerFactory budinessHandlerFactory) {
        return new ApisBusinessServiceImpl(budinessHandlerFactory, ruleExecutorService);
    }
}

